/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZoneOffset;

public final class ContextSummarySection
extends SmfData {
    private ContextSummarySection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long hftsInfo() {
        return Util.ConvertSignedBinary8(this.data, 0);
    }

    public int releaseIndex() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int withinReleaseIndex() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int prototypeIndex() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public String prodlevel() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public Duration exitSerialTod() {
        return Util.Binary8StckInterval(this.data, 32);
    }

    public double exitSerialTodSeconds() {
        return Util.ToSeconds(this.exitSerialTod());
    }

    public long exitSerialTodRawValue() {
        return Util.ConvertSignedBinary8(this.data, 32);
    }

    public Duration exitTimeUsed() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double exitTimeUsedSeconds() {
        return Util.ToSeconds(this.exitTimeUsed());
    }

    public long exitTimeUsedRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public ZoneOffset cvtldto() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 48);
    }

    public long cvtldtoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    public Duration cvtlso() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    public double cvtlsoSeconds() {
        return Util.ToSeconds(this.cvtlso());
    }

    public long cvtlsoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public ZoneOffset ecvtldto() {
        return Util.Binary16_STCKE_GMT_Offset(this.data, 64);
    }

    public BigInteger ecvtldtoRawValue() {
        return Util.ConvertBigInteger(this.data, 64, 16);
    }

    public Duration ecvtlso() {
        return Util.Binary16StckeInterval(this.data, 80);
    }

    public double ecvtlsoSeconds() {
        return Util.ToSeconds(this.ecvtlso());
    }

    public BigInteger ecvtlsoRawValue() {
        return Util.ConvertBigInteger(this.data, 80, 16);
    }

    public static ContextSummarySection create(byte[] Data2, int offset, int length) {
        return new ContextSummarySection(Data2, offset, length);
    }

    static enum Field {
        hftsInfo(0, 8),
        releaseIndex(8, 2),
        withinReleaseIndex(10, 2),
        prototypeIndex(12, 2),
        prodlevel(16, 16),
        exitSerialTod(32, 8),
        exitTimeUsed(40, 8),
        cvtldto(48, 8),
        cvtlso(56, 8),
        ecvtldto(64, 16),
        ecvtlso(80, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

