/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.AggregateBucket;
import com.blackhillsoftware.smf.smf98.ContextSummarySection;
import com.blackhillsoftware.smf.smf98.IdentificationSection;
import com.blackhillsoftware.smf.smf98.JobIndex;
import com.blackhillsoftware.smf.smf98.JobList;
import com.blackhillsoftware.smf.smf98.SelfDefiningSection;
import com.blackhillsoftware.smf.smf98.Smf98s1024Record;
import com.blackhillsoftware.smf.smf98.Smf98s1025Record;
import com.blackhillsoftware.smf.smf98.Smf98s1Record;
import com.blackhillsoftware.smf.smf98.WicData;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;

public class Smf98Record
extends SmfRecord {
    private SelfDefiningSection m_SelfDefiningSection = null;
    private IdentificationSection m_IdentificationSection = null;
    private ContextSummarySection m_ContextSummarySection = null;
    private List<WicData> m_WicData = null;
    private List<AggregateBucket> m_AggregateBucket1 = null;
    private List<AggregateBucket> m_AggregateBucket2 = null;
    private List<JobIndex> m_JobIndex = null;
    private List<JobList> m_JobList = null;
    public static final int SMF98SSF = 128;
    public static final int SMF98SBT = 64;
    public static final int SMF98More = 128;
    public static final int SMF98CONT = 64;
    public static final int SMF98NoStorage = 32;
    public static final int SMFR98_Len = 48;

    Smf98Record(byte[] data) {
        super(data);
        if (this.recordType() != 98) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    Smf98Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 98) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf98Record from(SmfRecord record) {
        Smf98Record r98 = new Smf98Record(record);
        switch (r98.subType()) {
            case 1: {
                return Smf98s1Record.from(r98);
            }
            case 1024: {
                return Smf98s1024Record.from(r98);
            }
            case 1025: {
                return Smf98s1025Record.from(r98);
            }
        }
        return r98;
    }

    public static Smf98Record from(byte[] data) {
        Smf98Record r98 = new Smf98Record(data);
        switch (r98.subType()) {
            case 1: {
                return Smf98s1Record.from(r98);
            }
            case 1024: {
                return Smf98s1024Record.from(r98);
            }
            case 1025: {
                return Smf98s1025Record.from(r98);
            }
        }
        return r98;
    }

    public SelfDefiningSection selfDefiningSection() {
        if (this.m_SelfDefiningSection != null) {
            return this.m_SelfDefiningSection;
        }
        this.m_SelfDefiningSection = SelfDefiningSection.create(this.data, 48, this.smf98sdsLen());
        return this.m_SelfDefiningSection;
    }

    public IdentificationSection identificationSection() {
        if (this.m_IdentificationSection != null) {
            return this.m_IdentificationSection;
        }
        if (this.selfDefiningSection().smf98ion() == 0) {
            return null;
        }
        if (this.selfDefiningSection().smf98ion() != 1) {
            throw new IllegalArgumentException("Unexpected Identification Section count");
        }
        this.m_IdentificationSection = IdentificationSection.create(this.data, this.selfDefiningSection().smf98iof(), this.selfDefiningSection().smf98iln());
        return this.m_IdentificationSection;
    }

    public ContextSummarySection contextSummarySection() {
        if (this.m_ContextSummarySection != null) {
            return this.m_ContextSummarySection;
        }
        if (this.selfDefiningSection().smf98cson() == 0) {
            return null;
        }
        if (this.selfDefiningSection().smf98cson() != 1) {
            throw new IllegalArgumentException("Unexpected Context Summary Section count");
        }
        this.m_ContextSummarySection = ContextSummarySection.create(this.data, this.selfDefiningSection().smf98csof(), this.selfDefiningSection().smf98csln());
        return this.m_ContextSummarySection;
    }

    public List<WicData> wicData() {
        if (this.subType() == 1) {
            return Collections.emptyList();
        }
        this.m_WicData = Util.sectionsFromTriplet(this.m_WicData, this.data, () -> this.selfDefiningSection().smf98dof(), () -> this.selfDefiningSection().smf98dln(), () -> this.selfDefiningSection().smf98don(), WicData::create);
        return this.m_WicData;
    }

    public List<AggregateBucket> aggregateBuckets1() {
        if (this.subType() == 1) {
            return Collections.emptyList();
        }
        this.m_AggregateBucket1 = Util.sectionsFromTriplet(this.m_AggregateBucket1, this.data, () -> this.wicData().get(0).aggBucketOf1(), () -> this.wicData().get(0).aggBucketLn1(), () -> this.wicData().get(0).aggBucketOn1(), AggregateBucket::create);
        return this.m_AggregateBucket1;
    }

    public List<AggregateBucket> aggregateBuckets2() {
        if (this.subType() == 1) {
            return Collections.emptyList();
        }
        this.m_AggregateBucket2 = Util.sectionsFromTriplet(this.m_AggregateBucket2, this.data, () -> this.wicData().get(0).aggBucketOf2(), () -> this.wicData().get(0).aggBucketLn2(), () -> this.wicData().get(0).aggBucketOn2(), AggregateBucket::create);
        return this.m_AggregateBucket2;
    }

    public List<JobIndex> jobIndex() {
        if (this.subType() == 1) {
            return Collections.emptyList();
        }
        this.m_JobIndex = Util.sectionsFromTriplet(this.m_JobIndex, this.data, () -> this.wicData().get(0).jobIndexOf(), () -> this.wicData().get(0).jobIndexLn(), () -> this.wicData().get(0).jobIndexOn(), JobIndex::create);
        return this.m_JobIndex;
    }

    public List<JobList> jobList() {
        if (this.subType() == 1) {
            return Collections.emptyList();
        }
        this.m_JobList = Util.sectionsFromTriplet(this.m_JobList, this.data, () -> this.wicData().get(0).jobListOf(), () -> this.wicData().get(0).jobListLn(), () -> this.wicData().get(0).jobListOn(), JobList::create);
        return this.m_JobList;
    }

    public int smf98len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf98seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf98flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf98ssf() {
        return Util.ConvertFlag(this.data, this.smf98flg(), 128);
    }

    public boolean smf98sbt() {
        return Util.ConvertFlag(this.data, this.smf98flg(), 64);
    }

    public int smf98rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf98tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf98tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf98dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf98dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf98sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf98ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf98sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf98ind() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public boolean smf98more() {
        return Util.ConvertFlag(this.data, this.smf98ind(), 128);
    }

    public boolean smf98cont() {
        return Util.ConvertFlag(this.data, this.smf98ind(), 64);
    }

    public boolean smf98noStorage() {
        return Util.ConvertFlag(this.data, this.smf98ind(), 32);
    }

    public int smf98partSeqNo() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public int smf98sdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int smf98sdsTripletsNum() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    static enum Field {
        smf98len(0, 2),
        smf98seg(2, 2),
        smf98flg(4, 1),
        smf98rty(5, 1),
        smf98tme(6, 4),
        smf98dte(10, 4),
        smf98sid(14, 4),
        smf98ssi(18, 4),
        smf98sty(22, 2),
        smf98ind(24, 1),
        smf98partSeqNo(25, 1),
        smf98sdsLen(26, 2),
        smf98sdsTripletsNum(28, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

