/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.zos;

import java.util.HashMap;
import java.util.Map;

public enum SpinLockType {
    RSM(0),
    TRACE(1),
    IOS(2),
    RSMCM(3),
    RSMGL(4),
    VSMFIX(5),
    ASMGL(6),
    RSMST(7),
    RSMXM(8),
    RSMAD(9),
    VSMPAG(10),
    DISP(11),
    ASM(12),
    SALLOC(13),
    IOSYNCH(14),
    RSMDS(15),
    IOSUCB(16),
    TPACBDEB(17),
    SRM(18),
    BMFLSD(19),
    XCFDS(20),
    XCFRES(21),
    XCFQ(22),
    ETRSET(23),
    IXLSCH(24),
    IXLSHR(25),
    IXLDS(26),
    IXLSHELL(27),
    IOSULUT(28),
    IXLREQST(29),
    WLMRES(30),
    WLMQ(31),
    CONTEXT(32),
    REGSRV(33),
    SSD(34),
    GRSINT(35),
    MISC(36),
    DONOTUS2(37),
    DONOTUS3(38),
    DONOTUS4(39),
    DONOTUS5(40),
    HCWDRLK2(41),
    HCWDRLK1(42),
    SRMENQ(43),
    RSMQ(44),
    SSDGROUP(45),
    UNKNOWN(-1);

    private static Map<Long, SpinLockType> valueMap;
    private final transient int lockId;

    private SpinLockType(int id) {
        this.lockId = id;
    }

    public static SpinLockType forLockId(long id) {
        SpinLockType result = valueMap.get(id);
        if (result == null) {
            return UNKNOWN;
        }
        return result;
    }

    public int lockId() {
        return this.lockId;
    }

    static {
        valueMap = new HashMap<Long, SpinLockType>();
        for (SpinLockType x : SpinLockType.values()) {
            if (x.lockId() < 0) continue;
            valueMap.put(Long.valueOf(x.lockId), x);
        }
    }
}

