/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.summary;

import com.blackhillsoftware.smf.summary.TopCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collector;

public class Top<T>
implements Iterable<T> {
    private transient int count;
    private PriorityQueue<T> values;
    private transient Comparator<? super T> comparator = null;

    public Top(int n, Comparator<? super T> comparator) {
        this.count = n;
        this.values = new PriorityQueue<T>(comparator);
        this.comparator = comparator;
    }

    public static <T> Collector<T, ?, List<T>> values(int n, Comparator<? super T> comparator) {
        return new TopCollector<T>(n, comparator);
    }

    public void add(T value) {
        if (this.values.size() < this.count) {
            this.values.add(value);
        } else if (this.comparator.compare(value, this.values.peek()) > 0) {
            this.values.add(value);
            this.values.remove();
        }
    }

    public boolean addAll(Collection<? extends T> collection) {
        for (T entry : collection) {
            this.add(entry);
        }
        return collection.size() > 0;
    }

    boolean addAll(Top<? extends T> c) {
        for (T entry : c.values) {
            this.add(entry);
        }
        return c.values.size() > 0;
    }

    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>(this.values);
        result.sort(this.comparator.reversed());
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<T> sortedIterator;
            {
                this.sortedIterator = Top.this.toList().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.sortedIterator.hasNext();
            }

            @Override
            public T next() {
                return this.sortedIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

