/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SmfReportDups {
    private static void printUsage() {
        System.out.println("Usage: SmfReportDups <input-file> [input-file2 ...]");
        System.out.println("");
        System.out.println("Search for duplicated data in input-file.");
        System.out.println("");
        System.out.println("  input-file        File containing SMF records. Binary data, RECFM=U or");
        System.out.println("                    V[B] records including RDW.");
        System.out.println("  input-file2 ...   Additional input file(s), to search for duplicates");
        System.out.println("                    across multiple files.");
        System.out.println("");
        System.out.println("Records and duplicate records are grouped and counted by system and minute.");
        System.out.println("If the number of duplicate records in a minute is greater than or equal");
        System.out.println("to the number of unique records in that minute, data for that minute is");
        System.out.println("likely to have been duplicated and the counts for that minute are reported.");
        System.out.println("");
        System.out.println("Specific record types might also be included multiple times in the data.");
        System.out.println("Data for each minute is checked by record type. Again, any record type");
        System.out.println("where the number of duplicate records is greater than or equal to the");
        System.out.println("number of unique records might be duplicated data so the counts are");
        System.out.println("reported.");
        System.out.println("Minutes appearing in the first part of the report are excluded to avoid");
        System.out.println("reporting every record type for those minutes.");
    }

    public static void main(String[] args) throws IOException, NoSuchAlgorithmException {
        if (args.length == 0 || args[0].equals("--help") || args[0].equals("-h")) {
            SmfReportDups.printUsage();
            System.exit(0);
        }
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        HashSet<Digest> recordHashes = new HashSet<Digest>();
        HashMap<String, Map<LocalDateTime, RecordStats>> bySystemByMinute = new HashMap<String, Map<LocalDateTime, RecordStats>>();
        HashMap<String, Map<LocalDateTime, Map<Integer, RecordStats>>> bySystemByMinuteByType = new HashMap<String, Map<LocalDateTime, Map<Integer, RecordStats>>>();
        int in = 0;
        int dups = 0;
        try {
            for (int i = 0; i < args.length; ++i) {
                try (SmfRecordReader reader = SmfRecordReader.fromName(args[i]);){
                    for (SmfRecord record : reader) {
                        ++in;
                        String system = record.system();
                        LocalDateTime minute = record.smfDateTime().truncatedTo(ChronoUnit.MINUTES);
                        Integer recordtype = record.recordType();
                        RecordStats minuteStats = bySystemByMinute.computeIfAbsent(system, key -> new HashMap()).computeIfAbsent(minute, key -> new RecordStats(null, minute));
                        RecordStats minuteRecordTypeStats = bySystemByMinuteByType.computeIfAbsent(system, key -> new HashMap()).computeIfAbsent(minute, key -> new HashMap()).computeIfAbsent(recordtype, key -> new RecordStats(recordtype, minute));
                        if (recordHashes.add(new Digest(sha1.digest(record.getBytes())))) {
                            minuteStats.countUnique();
                            minuteRecordTypeStats.countUnique();
                            continue;
                        }
                        ++dups;
                        minuteStats.countDuplicate();
                        minuteRecordTypeStats.countDuplicate();
                    }
                    continue;
                }
            }
        }
        catch (Exception e) {
            SmfReportDups.printUsage();
            throw e;
        }
        System.out.format("Finished, %d records in, %d duplicates.%n", in, dups);
        SmfReportDups.writeReport(bySystemByMinute, bySystemByMinuteByType);
    }

    private static void writeReport(Map<String, Map<LocalDateTime, RecordStats>> bySystemByMinute, Map<String, Map<LocalDateTime, Map<Integer, RecordStats>>> bySystemByMinuteByType) {
        List systems = bySystemByMinute.keySet().stream().sorted().collect(Collectors.toList());
        for (String system : systems) {
            Map<LocalDateTime, RecordStats> byMinute = bySystemByMinute.get(system);
            Map<LocalDateTime, Map<Integer, RecordStats>> byMinuteByType = bySystemByMinuteByType.get(system);
            List<RecordStats> duplicateMinutesBySystem = byMinute.values().stream().filter(entry -> entry.dupPercent() >= 100.0).sorted(Comparator.comparing(RecordStats::getMinute)).collect(Collectors.toList());
            for (RecordStats entry2 : duplicateMinutesBySystem) {
                byMinuteByType.remove(entry2.getMinute());
            }
            List<RecordStats> duplicatesByMinuteByType = byMinuteByType.values().stream().flatMap(entry -> entry.values().stream()).filter(entry -> entry.dupPercent() >= 100.0).sorted(Comparator.comparing(RecordStats::getMinute).thenComparing(RecordStats::getRecordtype)).collect(Collectors.toList());
            SmfReportDups.reportBySystem(system, duplicateMinutesBySystem);
            SmfReportDups.reportByRecordType(system, duplicatesByMinuteByType);
        }
    }

    private static void reportBySystem(String system, List<RecordStats> duplicateMinutesBySystem) {
        if (!duplicateMinutesBySystem.isEmpty()) {
            System.out.format("%nSystem : %s%n", system);
            System.out.format("%n%-20s %8s %8s %6s%n%n", "Minute", "Records", "Dup", "Dup%");
            for (RecordStats minuteEntry : duplicateMinutesBySystem) {
                System.out.format("%-20s %8d %8d %6.0f%n", minuteEntry.getMinute(), minuteEntry.getTotal(), minuteEntry.getDuplicates(), minuteEntry.dupPercent());
            }
        }
    }

    private static void reportByRecordType(String system, List<RecordStats> duplicatesByMinuteByType) {
        if (!duplicatesByMinuteByType.isEmpty()) {
            System.out.format("%nSystem : %s%n", system);
            System.out.format("%n%-20s %4s %8s %8s %6s%n%n", "Minute", "Type", "Records", "Dup", "Dup%");
            for (RecordStats recordTypeEntry : duplicatesByMinuteByType) {
                System.out.format("%-20s %4d %8d %8d %6.0f%n", recordTypeEntry.getMinute(), recordTypeEntry.getRecordtype(), recordTypeEntry.getTotal(), recordTypeEntry.getDuplicates(), recordTypeEntry.dupPercent());
            }
        }
    }

    private static class RecordStats {
        private Integer recordtype;
        private int unique = 0;
        private int duplicates = 0;
        private LocalDateTime minute;

        RecordStats(Integer recordtype, LocalDateTime minute) {
            this.recordtype = recordtype;
            this.minute = minute;
        }

        public void countUnique() {
            ++this.unique;
        }

        public void countDuplicate() {
            ++this.duplicates;
        }

        private Integer getRecordtype() {
            return this.recordtype;
        }

        private LocalDateTime getMinute() {
            return this.minute;
        }

        private int getDuplicates() {
            return this.duplicates;
        }

        private int getTotal() {
            return this.unique + this.duplicates;
        }

        private double dupPercent() {
            return (double)this.duplicates / (double)this.unique * 100.0;
        }
    }

    private static class Digest {
        private long hashCode;

        public Digest(byte[] digest) {
            this.hashCode = ByteBuffer.wrap(digest).getLong();
        }

        public int hashCode() {
            return (int)this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Digest other = (Digest)obj;
            return this.hashCode == other.hashCode;
        }
    }
}

