/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.common.KeyManager;
import com.blackhillsoftware.common.Message;
import com.blackhillsoftware.common.interfaces.Emptyable;
import com.blackhillsoftware.smf.realtime.InMemoryResource;
import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.MissedDataException;
import com.blackhillsoftware.smf.realtime.RcReason;
import com.blackhillsoftware.smf.realtime.SmfConnectionIterator;
import com.blackhillsoftware.smf.realtime.SmfConnectionSpliterator;
import com.blackhillsoftware.smf.realtime.SmfRtiConnection;
import com.blackhillsoftware.smf.realtime.SmfSimulatedConnection;
import com.blackhillsoftware.zutil.mvs.CommandHandler;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmfConnection
implements Closeable,
Iterable<byte[]>,
Emptyable {
    protected static final int RESOURCENAMELENGTH = 26;
    private String name;
    protected Consumer<MissedDataEvent> onMissedData = null;
    protected static Logger slf4jLogger;
    private static boolean simulated;
    private ArrayDeque<byte[]> inner = new ArrayDeque();
    private Object getLock = new Object();
    protected CommandHandler stopHandler = null;
    private Iterator<byte[]> theIterator = null;
    private Spliterator<byte[]> theSpliterator = null;

    static native void connect(ByteBuffer var0, int var1, byte[] var2) throws IOException, RcReason;

    static native void disconnect(ByteBuffer var0) throws IOException, RcReason;

    static native void getRecords(ByteBuffer var0) throws IOException, RcReason;

    static native int listResources(int var0, byte[] var1) throws IOException, RcReason;

    public static List<InMemoryResource> query() throws IOException {
        Map<String, String> env = System.getenv();
        if (env.containsKey("SIMULATE_RTI") && env.get("SIMULATE_RTI").startsWith("Y") || env.get("SIMULATE_RTI").startsWith("y")) {
            return env.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith("IFASMF")).map(x -> InMemoryResource.create((String)x.getKey(), (String)x.getValue())).collect(Collectors.toList());
        }
        return SmfRtiConnection.doQuery();
    }

    public static Connectable forResourceName(String name) {
        Objects.requireNonNull(name);
        SmfConnection connection = simulated ? new SmfSimulatedConnection(name) : new SmfRtiConnection(name);
        return new Connectable(connection);
    }

    void onMissedData(Consumer<MissedDataEvent> onMissedData) {
        this.onMissedData = onMissedData;
    }

    void disconnectOnStop() {
        if (!simulated) {
            this.stopHandler = CommandHandler.onStop(this::handleStop);
        }
    }

    protected abstract boolean handleStop();

    SmfConnection(String name) {
        Objects.requireNonNull(name);
        if (name.length() > 26) {
            throw new IllegalArgumentException("Resource name length cannot be longer than 26characters");
        }
        this.name = name;
    }

    abstract SmfConnection connect() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() throws IOException {
        Object object = this.getLock;
        synchronized (object) {
            if (this.inner.isEmpty()) {
                this.readRecords(this.inner);
            }
            return this.inner.poll();
        }
    }

    public synchronized Stream<byte[]> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public synchronized Iterator<byte[]> iterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theIterator = new SmfConnectionIterator(this);
        return this.theIterator;
    }

    @Override
    public synchronized Spliterator<byte[]> spliterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theSpliterator = new SmfConnectionSpliterator(this);
        return this.theSpliterator;
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Deprecated
    public boolean moreQueued() {
        return !this.inner.isEmpty();
    }

    protected abstract void readRecords(Queue<byte[]> var1) throws IOException, MissedDataException;

    @Override
    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refill(Queue<byte[]> queue, int max) throws IOException {
        Object object = this.getLock;
        synchronized (object) {
            int count = 0;
            byte[] record = this.read();
            if (record != null) {
                ++count;
                queue.add(record);
                while (!this.isEmpty()) {
                    queue.add(this.read());
                    if (++count < max) continue;
                    return true;
                }
            }
            return count > 0;
        }
    }

    public String getResourceName() {
        return this.name;
    }

    static {
        block18: {
            String sig;
            String license;
            block19: {
                int line;
                List key;
                simulated = false;
                slf4jLogger = LoggerFactory.getLogger((String)"EasySMF RTI");
                slf4jLogger.info("EasySMF RTI Version: 0.9.12 2026-02-12T03:15:48Z");
                String simFlag = System.getenv("SIMULATE_RTI");
                if (simFlag != null && (simFlag.startsWith("Y") || simFlag.startsWith("y"))) {
                    simulated = true;
                }
                if ((key = KeyManager.getKey((String)"EZSMFKEY")) == null) {
                    key = KeyManager.getKey((String)"EasySMF RTI", (String)"EZSMFKEY", (String)"EASYSMFKEY");
                }
                license = "";
                sig = "";
                for (line = 0; line < key.size() && !((String)key.get(line)).startsWith("**License:"); ++line) {
                }
                ++line;
                while (line < key.size() && !((String)key.get(line)).startsWith("**Sig:")) {
                    license = license + ((String)key.get(line)).substring(0, Math.min(((String)key.get(line)).length(), 72)).trim();
                    ++line;
                }
                ++line;
                while (line < key.size() && !((String)key.get(line)).startsWith("**End")) {
                    sig = sig + ((String)key.get(line)).substring(0, Math.min(((String)key.get(line)).length(), 72)).trim();
                    ++line;
                }
                if (license.length() != 0 || sig.length() != 0) break block19;
                Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Invalid Key"));
                System.exit(1);
                break block18;
            }
            Base64.Decoder decoder = Base64.getMimeDecoder();
            byte[] decodedLicense = decoder.decode(license);
            byte[] decodedSig = decoder.decode(sig);
            String licString = new String(decodedLicense, StandardCharsets.UTF_8);
            try {
                int systems;
                String[] lines;
                block21: {
                    block20: {
                        Signature sig2 = Signature.getInstance("SHA1WithRSA");
                        byte[] expBytes = decoder.decode("AQAB");
                        byte[] modBytes = decoder.decode("+k3UcbZ5knkhX3jzBh95ZNdbHTPIBi/i9tbUdEJbYd2Rx8Nzlzhxn4kMxrZ5fXqG23EVa1H/2wqsTT7zstBgSqyTyznPbJUiH9QnohlOCs9o0IuQWZUWaQ6z+qj7oXSllQegCO0ultm8aL55P4R6LMThZId9Zx/d/m18sg55NP8=");
                        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, modBytes), new BigInteger(1, expBytes));
                        KeyFactory fact = KeyFactory.getInstance("RSA");
                        PublicKey pubKey = fact.generatePublic(keySpec);
                        sig2.initVerify(pubKey);
                        sig2.update(decodedLicense);
                        if (!sig2.verify(decodedSig)) {
                            Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key Verification Error"));
                            System.exit(1);
                            break block18;
                        }
                        lines = licString.split("\\r?\\n");
                        systems = Integer.parseInt(lines[0]);
                        if (lines.length < 4) break block20;
                        if (lines[3].contains("RTI")) break block21;
                    }
                    Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key is not for EasySMF-RTI"));
                    System.exit(1);
                }
                LocalDate expiry = LocalDate.parse(lines[1], DateTimeFormatter.ISO_LOCAL_DATE);
                if (LocalDate.now().isAfter(expiry.plusDays(30L))) {
                    Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("EasySMF License has expired", "Expiry: " + expiry.toString()));
                    System.exit(1);
                } else if (LocalDate.now().isAfter(expiry)) {
                    Message.box(arg_0 -> ((Logger)slf4jLogger).warn(arg_0), Arrays.asList("EasySMF License has expired.", "Operating in grace period.", "Grace period expires: " + expiry.plusDays(30L).toString()));
                } else if (LocalDate.now().isAfter(expiry.plusDays(-30L))) {
                    Message.box(arg_0 -> ((Logger)slf4jLogger).warn(arg_0), Arrays.asList("EasySMF License expires in less than 30 days.", "Expiry: " + expiry.toString()));
                }
                String name = lines.length > 2 ? lines[2] : "";
                slf4jLogger.info("Licensed to: " + name);
                if (expiry.getYear() < 9999) {
                    slf4jLogger.info("Expiry: " + expiry.toString());
                }
                slf4jLogger.info("z/OS processor complexes: " + Integer.toString(systems));
            }
            catch (Exception e) {
                Message.hilite(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key Error: " + e.toString() + System.lineSeparator() + e.getCause()));
                System.exit(1);
            }
        }
    }

    public static class Connectable {
        private SmfConnection connection;

        Connectable(SmfConnection connection) {
            this.connection = connection;
        }

        public SmfConnection connect() throws IOException {
            this.connection.connect();
            return this.connection;
        }

        public Connectable disconnectOnStop() {
            this.connection.disconnectOnStop();
            return this;
        }

        public Connectable onMissedData(Consumer<MissedDataEvent> onMissedData) {
            this.connection.onMissedData(onMissedData);
            return this;
        }
    }
}

