/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.smf.realtime.SmfConnection;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;

class SmfConnectionSpliterator
implements Spliterator<byte[]> {
    private SmfConnection source;
    private int allowedSplits;
    private Queue<byte[]> buffer = new ArrayDeque<byte[]>(100);

    SmfConnectionSpliterator(SmfConnection source) {
        this.source = source;
        this.allowedSplits = Runtime.getRuntime().availableProcessors() * 2;
    }

    SmfConnectionSpliterator(SmfConnection source, int allowedSplits) {
        this.source = source;
        this.allowedSplits = allowedSplits;
    }

    @Override
    public boolean tryAdvance(Consumer<? super byte[]> action) {
        try {
            if (!this.buffer.isEmpty()) {
                action.accept((byte[])this.buffer.remove());
                return true;
            }
            this.source.refill(this.buffer, 100);
            if (!this.buffer.isEmpty()) {
                action.accept((byte[])this.buffer.remove());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Spliterator<byte[]> trySplit() {
        if (this.allowedSplits < 2) {
            return null;
        }
        this.allowedSplits /= 2;
        return new SmfConnectionSpliterator(this.source, this.allowedSplits);
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

