/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json;

import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.CompletionSection;
import com.blackhillsoftware.smf.smf30.ProcessorAccountingSection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.LocalDateTime;

public class Smf30JsonJobList {
    public static void main(String[] args) throws IOException {
        Gson gson = new EasySmfGsonBuilder().avoidScientificNotation(true).createGson();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(30, 5);){
            reader.stream().map(record -> Smf30Record.from((SmfRecord)record)).filter(r30 -> r30.completionSection() != null).forEach(r30 -> {
                JobInfo job = new JobInfo((Smf30Record)r30);
                System.out.println(gson.toJson((Object)job));
            });
        }
        System.out.println("Done");
    }

    static class JobInfo {
        LocalDateTime time;
        String system;
        String jobname;
        String jobid;
        String userid;
        CompletionSection completion;
        ProcessorAccountingSection processorAccounting;

        JobInfo(Smf30Record r30) {
            this.time = r30.smfDateTime();
            this.system = r30.system();
            this.jobname = r30.identificationSection().smf30jbn();
            this.jobid = r30.identificationSection().smf30jnm();
            this.userid = r30.identificationSection().smf30rud();
            this.completion = r30.completionSection();
            this.processorAccounting = r30.processorAccountingSection();
        }
    }
}

