/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json.cics;

import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.StProductSection;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf2json.cli.Smf2JsonCLI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CicsStatistics {
    public static void main(String[] args) throws IOException {
        Smf2JsonCLI smf2JsonCli = Smf2JsonCLI.create().description("Convert CICS Statistics Sections to JSON").includeRecords(110);
        smf2JsonCli.easySmfGsonBuilder().exclude(StProductSection.class, "smfstdat").exclude(StProductSection.class, "smfstclt");
        smf2JsonCli.easySmfGsonBuilder().exclude(StProductSection.class, "smfstrsd").exclude(StProductSection.class, "smfstrst").exclude(StProductSection.class, "smfstcst").exclude(StProductSection.class, "smfstrvn").exclude(StProductSection.class, "smfstmfl").exclude(StProductSection.class, "smfstpdn");
        smf2JsonCli.start((Smf2JsonCLI.Client)new Client(), args);
    }

    private static class Client
    implements Smf2JsonCLI.Client {
        private Client() {
        }

        public List<Object> processRecord(SmfRecord record) {
            Smf110Record r110 = Smf110Record.from((SmfRecord)record);
            ArrayList<Object> result = new ArrayList<Object>();
            String system = r110.smfsid();
            for (StatisticsDataSection stats : r110.statisticsDataSections()) {
                result.add(new CompositeEntry().add("time", (Object)r110.stProductSection().smfstdat().atTime(r110.stProductSection().smfstclt())).add("recordtype", (Object)"CICS Statistics").add("system", (Object)system).add((Object)r110.stProductSection()).add((Object)stats));
            }
            return result;
        }

        public List<Object> onEndOfData() {
            System.err.println("Finished");
            return Collections.emptyList();
        }
    }
}

