/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json.cics;

import com.blackhillsoftware.json.cics.CicsTransactionGroup;
import com.blackhillsoftware.json.cics.CicsTransactionGroupFactory;
import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.json.util.HashKey;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf2json.cli.Smf2JsonCLI;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CicsTransactionSummary {
    public static void main(String[] args) throws IOException {
        Smf2JsonCLI smf2JsonCli = Smf2JsonCLI.create().description("Summarize CICS transactions into JSON").processRecordIsThreadSafe(true).includeRecords(110, 1);
        smf2JsonCli.easySmfGsonBuilder().includeZeroValues(false).includeEmptyStrings(false).includeUnsetFlags(false);
        smf2JsonCli.start((Smf2JsonCLI.Client)new CliClient(), args);
    }

    private static class CliClient
    implements Smf2JsonCLI.Client {
        private Map<HashKey, CicsTransactionGroup> transactionGroups = new ConcurrentHashMap<HashKey, CicsTransactionGroup>();
        private Set<CicsInstanceId> noDictionary = ConcurrentHashMap.newKeySet();
        private CicsTransactionGroupFactory transactionGroupFactory = new CicsTransactionGroupFactory().exclude((MonitoringField)Field.START).exclude((MonitoringField)Field.STOP).exclude((MonitoringField)Field.TRAN).exclude((MonitoringField)Field.TTYPE).exclude((MonitoringField)Field.RTYPE).exclude((MonitoringField)Field.PGMNAME).exclude((MonitoringField)Field.SRVCLSNM).exclude((MonitoringField)Field.RPTCLSNM).exclude((MonitoringField)Field.TCLSNAME);

        public CliClient() {
            this.transactionGroupFactory.clockDetail(false);
        }

        public List<Object> processRecord(SmfRecord record) {
            Smf110Record r110 = Smf110Record.from((SmfRecord)record);
            String smfmnprn = r110.mnProductSection().smfmnprn();
            String smfmnspn = r110.mnProductSection().smfmnspn();
            if (r110.haveDictionary()) {
                r110.performanceRecords().stream().forEach(performanceRecord -> {
                    HashKey key = HashKey.of((String)"smfmnprn", (Object)smfmnprn).and("smfmnspn", (Object)smfmnspn).and("minute", (Object)performanceRecord.getField(Field.STOP).truncatedTo(ChronoUnit.MINUTES)).and("tran", (Object)performanceRecord.getField(Field.TRAN)).and("ttype", (Object)performanceRecord.getField(Field.TTYPE)).and("rtype", (Object)performanceRecord.getField(Field.RTYPE).trim()).and("pgmname", (Object)performanceRecord.getField(Field.PGMNAME)).and("srvclsnm", (Object)performanceRecord.getField(Field.SRVCLSNM)).and("rptclsnm", (Object)performanceRecord.getField(Field.RPTCLSNM)).and("tclsname", (Object)performanceRecord.getField(Field.TCLSNAME));
                    this.transactionGroups.computeIfAbsent(key, value -> this.transactionGroupFactory.createGroup()).add(performanceRecord);
                });
            } else if (this.noDictionary.add(r110.cicsInstance())) {
                System.err.println("No dictionary for: " + r110.cicsInstance().toString() + ", skipping record(s)");
            }
            return Collections.emptyList();
        }

        public List<Object> onEndOfData() {
            System.err.println("End of Data");
            return this.transactionGroups.entrySet().stream().map(entry -> new CompositeEntry().add("recordtype", (Object)"CICS Summary").add(entry.getKey()).add(entry.getValue())).collect(Collectors.toList());
        }
    }
}

