/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json.cics;

import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf2json.cli.Smf2JsonCLI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class CicsTransactions {
    public static void main(String[] args) throws IOException {
        Smf2JsonCLI smf2JsonCli = Smf2JsonCLI.create().description("Convert CICS transaction information to JSON").includeRecords(110, 1);
        CicsTransactions.setupCommandLineArgs(smf2JsonCli);
        Configuration config = CicsTransactions.readCommandLineArgs(args, smf2JsonCli);
        smf2JsonCli.easySmfGsonBuilder().cicsClockDetail(true).includeZeroValues(false).includeEmptyStrings(false).includeUnsetFlags(false);
        smf2JsonCli.start((Smf2JsonCLI.Client)new CliClient(config), args);
    }

    private static void setupCommandLineArgs(Smf2JsonCLI smf2JsonCli) {
        smf2JsonCli.options().addOption(Option.builder().longOpt("applid").hasArgs().valueSeparator(',').desc("select applid(s): --applid=AAABAAA[,BBBBBBB...]").build());
        smf2JsonCli.options().addOption(Option.builder().longOpt("xapplid").hasArgs().valueSeparator(',').desc("exclude applid(s):  --xapplid=AAABAAA[,BBBBBBB...]").build());
        smf2JsonCli.options().addOption(Option.builder((String)"ms").longOpt("milliseconds").hasArg(true).desc("report transactions longer than this duration").build());
        smf2JsonCli.options().addOption(Option.builder().longOpt("abend").hasArg(false).desc("only report abended transactions (ABCODEC or ABCODEO has a value)").build());
        smf2JsonCli.options().addOption(Option.builder().longOpt("tranid").hasArgs().valueSeparator(',').desc("select specific transactions:  --tranid=AAAA[,BBBB...]").build());
        smf2JsonCli.options().addOption(Option.builder().longOpt("xtranid").hasArgs().valueSeparator(',').desc("exclude specific transactions: --xtranid=AAAA[,BBBB...]").build());
    }

    private static Configuration readCommandLineArgs(String[] args, Smf2JsonCLI smf2JsonCli) {
        CommandLine commandLine = smf2JsonCli.commandLine(args);
        Configuration config = new Configuration();
        config.includeApplids = CicsTransactions.getValues(commandLine, "applid");
        config.excludeApplids = CicsTransactions.getValues(commandLine, "xapplid");
        config.includeTransactions = CicsTransactions.getValues(commandLine, "tranid");
        config.excludeTransactions = CicsTransactions.getValues(commandLine, "xtranid");
        config.abendsOnly = commandLine.hasOption("abend");
        if (commandLine.hasOption("ms")) {
            try {
                config.thresholdSeconds = Double.parseDouble(smf2JsonCli.commandLine(args).getOptionValue("ms")) / 1000.0;
            }
            catch (NumberFormatException ex) {
                System.err.println("Failed to parse ms option: " + ex.toString());
                System.exit(0);
            }
        }
        return config;
    }

    private static Set<String> getValues(CommandLine commandLine, String option) {
        if (!commandLine.hasOption(option)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String value : commandLine.getOptionValues(option)) {
            result.add(value);
        }
        return result;
    }

    private static class Configuration {
        Set<String> includeApplids = Collections.emptySet();
        Set<String> includeTransactions = Collections.emptySet();
        Set<String> excludeApplids = Collections.emptySet();
        Set<String> excludeTransactions = Collections.emptySet();
        double thresholdSeconds = 0.0;
        boolean abendsOnly = false;

        private Configuration() {
        }
    }

    private static class CliClient
    implements Smf2JsonCLI.Client {
        private Configuration config;

        CliClient(Configuration config) {
            this.config = config;
        }

        public List<Object> processRecord(SmfRecord record) {
            ArrayList<Object> result = new ArrayList<Object>();
            Smf110Record r110 = Smf110Record.from((SmfRecord)record);
            if (this.includeApplid(r110.mnProductSection().smfmnprn())) {
                for (PerformanceRecord transaction : r110.performanceRecords()) {
                    if (!this.includeTransaction(transaction)) continue;
                    CompositeEntry entry = new CompositeEntry().add("time", (Object)transaction.getField(Field.STOP)).add("recordtype", (Object)"CICS Transaction").add("system", (Object)r110.smfsid()).add("smfmnjbn", (Object)r110.mnProductSection().smfmnjbn()).add("smfmnprn", (Object)r110.mnProductSection().smfmnprn()).add("smfmnspn", (Object)r110.mnProductSection().smfmnspn()).add((Object)transaction);
                    result.add(entry);
                }
            }
            return result;
        }

        private boolean includeApplid(String smfmnprn) {
            if (this.config.excludeApplids.contains(smfmnprn)) {
                return false;
            }
            return this.config.includeApplids.isEmpty() || this.config.includeApplids.contains(smfmnprn);
        }

        private boolean includeTransaction(PerformanceRecord transaction) {
            if (this.config.excludeTransactions.contains(transaction.getField(Field.TRAN))) {
                return false;
            }
            if (!this.config.includeTransactions.isEmpty() && !this.config.includeTransactions.contains(transaction.getField(Field.TRAN))) {
                return false;
            }
            if (this.config.thresholdSeconds > 0.0 && !(transaction.elapsedSeconds() > this.config.thresholdSeconds)) {
                return false;
            }
            return !this.config.abendsOnly || transaction.getField(Field.ABCODEC).length() != 0 || transaction.getField(Field.ABCODEO).length() != 0;
        }

        public List<Object> onEndOfData() {
            return Collections.emptyList();
        }
    }
}

