/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.sample;

import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class RtiHttpBinary {
    public static void main(String[] args) throws IOException, InterruptedException, URISyntaxException {
        if (args.length < 2) {
            System.out.println("Usage: RtiHttpBinary <resource-name> <url>");
            return;
        }
        String inMemoryResource = args[0];
        String url = args[1];
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(new URI(url)).header("Content-Type", "application/octet-stream");
        try (SmfConnection connection = SmfConnection.forResourceName(inMemoryResource).disconnectOnStop().onMissedData(RtiHttpBinary::handleMissedData).connect();){
            ByteArrayOutputStream outputQueue = new ByteArrayOutputStream();
            for (byte[] record : connection) {
                outputQueue.write(record);
                if (connection.moreQueued() && outputQueue.size() <= 0xA00000) continue;
                RtiHttpBinary.sendData(client, requestBuilder, outputQueue.toByteArray());
                outputQueue = new ByteArrayOutputStream();
            }
            if (outputQueue.size() > 0) {
                RtiHttpBinary.sendData(client, requestBuilder, outputQueue.toByteArray());
            }
        }
    }

    private static void sendData(HttpClient client, HttpRequest.Builder requestBuilder, byte[] payload) throws IOException, InterruptedException {
        HttpRequest request = requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(payload)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            System.out.println(response.statusCode() + " " + response.body());
        }
    }

    static void handleMissedData(MissedDataEvent e) {
        System.out.println("Missed Data!");
        e.throwException(false);
    }
}

