/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.Recorg;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.dataset.Dsorg;
import com.blackhillsoftware.smf.dataset.Recfm;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public final class BackupDataset
extends DcollectRecord {
    public static final int UBINCAT = 128;
    public static final int UBNOENQ = 64;
    public static final int UBBWO = 32;
    public static final int UBNQN1 = 16;
    public static final int UBNQN2 = 8;
    public static final int UBUNIX = 4;
    public static final int UBUNIXDIR = 2;
    public static final int UBESDS = 128;
    public static final int UBKSDS = 64;
    public static final int UBLDS = 32;
    public static final int UBRRDS = 16;
    public static final int UBRACFD = 128;
    public static final int UBGDS = 64;
    public static final int UBREBLK = 32;
    public static final int UBPDSE = 16;
    public static final int UBSMSM = 8;
    public static final int UBCOMPR = 4;
    public static final int UBLFS = 2;
    public static final int UBNEWNAME = 1;
    public static final int UBNOSPHERE = 128;
    public static final int UBGVCN = 64;
    public static final int UBF_RETAIN_SPCD = 32;
    public static final int UBF_NEVER_EXP = 16;
    public static final int UBENCRP = 8;
    public static final int UBZFS = 4;
    public static final int UBENCRDP = 2;
    public static final int UBALLSP_FMB = 128;
    public static final int UBUSESP_FMB = 64;
    public static final int UBRECSP_FMB = 32;
    public static final int UBDSIZE_FMB = 16;
    public static final int UB_FMB = 8;
    public static final int UB_BSON = 4;
    public static final int UB_JSON = 2;

    BackupDataset(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.B)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    BackupDataset(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.B)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static BackupDataset from(VRecord record) {
        return new BackupDataset(record);
    }

    public String ubdsnam() {
        return Util.ConvertEbcdic(this.data, 24, 44);
    }

    public int ubflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public boolean ubincat() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 128);
    }

    public boolean ubnoenq() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 64);
    }

    public boolean ubbwo() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 32);
    }

    public boolean ubnqn1() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 16);
    }

    public boolean ubnqn2() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 8);
    }

    public boolean ubunix() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 4);
    }

    public boolean ubunixdir() {
        return Util.ConvertFlag(this.data, this.ubflag1(), 2);
    }

    public String ubdevcl() {
        return Util.ConvertEbcdic(this.data, 69, 1);
    }

    public int ubdevclRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 69);
    }

    public Dsorg ubdsorg() {
        return Dsorg.fromDsorgBytes(this.ubdsorgRawValue());
    }

    public int ubdsorgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public int ubdsize() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    public double ubdsizeMB() {
        if (this.ubdsizeFmb()) {
            return this.ubdsize();
        }
        return (double)this.ubdsize() / 1024.0;
    }

    public LocalTime ubtime() {
        return Util.Binary4hhmmssth(this.data, 76);
    }

    public long ubtimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public LocalDate ubdate() {
        return Util.Packed4YYYYDDD(this.data, 80);
    }

    public int ubdateRawValue() {
        return Util.ConvertPacked4(this.data, 80);
    }

    public LocalDateTime ubbdate() {
        return this.ubdate() != null ? this.ubdate().atTime(this.ubtime()) : null;
    }

    private int ubdclng() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public String ubdatcl() {
        if (this.data.length >= 86 + this.ubdclng()) {
            return Util.ConvertEbcdic(this.data, 86, this.ubdclng());
        }
        return null;
    }

    private int ubsclng() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public String ubstgcl() {
        if (this.data.length >= 118 + this.ubsclng()) {
            return Util.ConvertEbcdic(this.data, 118, this.ubsclng());
        }
        return null;
    }

    public int ubmclng() {
        return Util.ConvertUnsignedBinary2(this.data, 148);
    }

    private String ubmgtcl() {
        if (this.data.length >= 150 + this.ubmclng()) {
            return Util.ConvertEbcdic(this.data, 150, this.ubmclng());
        }
        return null;
    }

    public Recfm ubrecrd() {
        return Recfm.fromRecfmByte(this.ubrecrdRawValue());
    }

    public int ubrecrdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 180);
    }

    public Recorg ubrecor() {
        int value = this.ubrecorRawValue() & 0xF0;
        switch (value) {
            case 128: {
                return Recorg.ESDS;
            }
            case 64: {
                return Recorg.KSDS;
            }
            case 32: {
                return Recorg.LDS;
            }
            case 16: {
                return Recorg.RRDS;
            }
            case 0: {
                return Recorg.NULL;
            }
        }
        return Recorg.NOT_DEFINED;
    }

    public int ubrecorRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 181);
    }

    public boolean ubesds() {
        return Util.ConvertFlag(this.data, this.ubrecorRawValue(), 128);
    }

    public boolean ubksds() {
        return Util.ConvertFlag(this.data, this.ubrecorRawValue(), 64);
    }

    public boolean ublds() {
        return Util.ConvertFlag(this.data, this.ubrecorRawValue(), 32);
    }

    public boolean ubrrds() {
        return Util.ConvertFlag(this.data, this.ubrecorRawValue(), 16);
    }

    public int ubbklng() {
        return Util.ConvertUnsignedBinary2(this.data, 182);
    }

    public int ubflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 184);
    }

    public boolean ubracfd() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 128);
    }

    public boolean ubgds() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 64);
    }

    public boolean ubreblk() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 32);
    }

    public boolean ubpdse() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 16);
    }

    public boolean ubsmsm() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 8);
    }

    public boolean ubcompr() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 4);
    }

    public boolean ublfs() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 2);
    }

    public boolean ubnewname() {
        return Util.ConvertFlag(this.data, this.ubflag2(), 1);
    }

    public int ubflag3() {
        return Util.ConvertUnsignedBinary1(this.data, 185);
    }

    public boolean ubnosphere() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 128);
    }

    public boolean ubgvcn() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 64);
    }

    public boolean ubfRetainSpcd() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 32);
    }

    public boolean ubfNeverExp() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 16);
    }

    public boolean ubencrp() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 8);
    }

    public boolean ubzfs() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 4);
    }

    public boolean ubencrdp() {
        return Util.ConvertFlag(this.data, this.ubflag3(), 2);
    }

    public int ubRetaindays() {
        return Util.ConvertUnsignedBinary2(this.data, 186);
    }

    public int uballsp() {
        return Util.ConvertSignedBinary4(this.data, 188);
    }

    public double uballspMB() {
        if (this.uballspFmb()) {
            return this.uballsp();
        }
        return (double)this.uballsp() / 1024.0;
    }

    public int ubusesp() {
        return Util.ConvertSignedBinary4(this.data, 192);
    }

    public double ubusespMB() {
        if (this.ubusespFmb()) {
            return this.ubusesp();
        }
        return (double)this.ubusesp() / 1024.0;
    }

    public int ubrecsp() {
        return Util.ConvertSignedBinary4(this.data, 196);
    }

    public double ubrecspMB() {
        if (this.ubrecspFmb()) {
            return this.ubrecsp();
        }
        return (double)this.ubrecsp() / 1024.0;
    }

    public int ubUserDatasize() {
        return Util.ConvertSignedBinary4(this.data, 200);
    }

    public double ubUserDatasizeMB() {
        if (this.ubFmb()) {
            return this.ubUserDatasize();
        }
        return (double)this.ubUserDatasize() / 1024.0;
    }

    public int ubCompDatasize() {
        return Util.ConvertSignedBinary4(this.data, 204);
    }

    public double ubCompDatasizeMB() {
        if (this.ubFmb()) {
            return this.ubCompDatasize();
        }
        return (double)this.ubCompDatasize() / 1024.0;
    }

    public String ubfrvol() {
        return Util.ConvertEbcdic(this.data, 208, 6);
    }

    public int ubflag4() {
        return Util.ConvertUnsignedBinary1(this.data, 214);
    }

    public boolean uballspFmb() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 128);
    }

    public boolean ubusespFmb() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 64);
    }

    public boolean ubrecspFmb() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 32);
    }

    public boolean ubdsizeFmb() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 16);
    }

    public boolean ubFmb() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 8);
    }

    public boolean ubBson() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 4);
    }

    public boolean ubJson() {
        return Util.ConvertFlag(this.data, this.ubflag4(), 2);
    }

    public int ubpdsev() {
        return Util.ConvertUnsignedBinary1(this.data, 215);
    }

    public int ubencrpt() {
        return Util.ConvertUnsignedBinary2(this.data, 228);
    }

    public String ubencrpl() {
        return Util.ConvertEbcdic(this.data, 230, 64);
    }

    public int ubupathl() {
        return Util.ConvertUnsignedBinary2(this.data, 436);
    }

    public String ubupathn() {
        if (this.data.length >= 438 + this.ubupathl()) {
            return Util.ConvertEbcdic(this.data, 438, this.ubupathl());
        }
        return null;
    }

    static enum Field {
        ubdsnam(24, 44),
        ubflag1(68, 1),
        ubdevcl(69, 1),
        ubdsorg(70, 2),
        ubdsize(72, 4),
        ubtime(76, 4),
        ubdate(80, 4),
        ubdclng(84, 2),
        ubdatcl(86, 0),
        ubsclng(116, 2),
        ubstgcl(118, 0),
        ubmclng(148, 2),
        ubmgtcl(150, 0),
        ubrecrd(180, 1),
        ubrecor(181, 1),
        ubbklng(182, 2),
        ubflag2(184, 1),
        ubflag3(185, 1),
        ubRetaindays(186, 2),
        uballsp(188, 4),
        ubusesp(192, 4),
        ubrecsp(196, 4),
        ubUserDatasize(200, 4),
        ubCompDatasize(204, 4),
        ubfrvol(208, 6),
        ubflag4(214, 1),
        ubpdsev(215, 1),
        ubencrpt(228, 2),
        ubencrpl(230, 64),
        ubupathl(436, 2),
        ubupathn(438, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

