/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.EAttr;
import com.blackhillsoftware.dcollect.values.Recorg;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.dataset.CarriageControl;
import com.blackhillsoftware.smf.dataset.Recfm;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public final class DataClass
extends DcollectRecord {
    public static final int DDCFRORG = 128;
    public static final int DDCFLREC = 64;
    public static final int DDCFRFM = 32;
    public static final int DDCFKLEN = 16;
    public static final int DDCFKOFF = 8;
    public static final int DDCFEXP = 4;
    public static final int DDCFRET = 2;
    public static final int DDCFPSP = 1;
    public static final int DDCFSSP = 128;
    public static final int DDCFDIR = 64;
    public static final int DDCFAUN = 32;
    public static final int DDCFAVR = 16;
    public static final int DDCFVOL = 8;
    public static final int DDCFCIS = 4;
    public static final int DDCFCIF = 2;
    public static final int DDCFCAF = 1;
    public static final int DDCFXREG = 128;
    public static final int DDCFXSYS = 64;
    public static final int DDCFIMBD = 32;
    public static final int DDCFRPLC = 16;
    public static final int DDCFCOMP = 8;
    public static final int DDCFMEDI = 4;
    public static final int DDCFRECT = 2;
    public static final int DDCFVEA = 1;
    public static final int DDCSPRLF = 128;
    public static final int DDCREDUS = 64;
    public static final int DDCRABS = 32;
    public static final int DDCFCT = 16;
    public static final int DDCBLMT = 8;
    public static final int DDCCFS = 4;
    public static final int DDCDVCS = 2;
    public static final int DDCFSCAL = 1;
    public static final int DDCBLK = 128;
    public static final int DDCSTSP = 64;
    public static final int DDCIMBED = 128;
    public static final int DDCREPLC = 64;
    public static final int DDCBWOS = 128;
    public static final int DDCLOGRS = 64;
    public static final int DDCSPANS = 32;
    public static final int DDCLSIDS = 16;
    public static final int DDCFRLGS = 8;
    public static final int DDCFEXTC = 4;
    public static final int DDCFA2GB = 2;
    public static final int DDCFPSEG = 1;
    public static final int DDCFKYL1 = 128;
    public static final int DDCFKYC1 = 64;
    public static final int DDCFKYL2 = 32;
    public static final int DDCFKYC2 = 16;
    public static final int DDCFVSP = 8;
    public static final int DDCFSDB = 4;
    public static final int DDCFOVRD = 2;
    public static final int DCDFCAR = 1;
    public static final int DDCFATTR = 128;
    public static final int DDCFLOGR = 64;
    public static final int DDCFRMOD = 32;
    public static final int DDCGSRDU = 16;
    public static final int DDCFKLBL = 8;
    public static final int DDCOVRD = 128;
    public static final int DDCSDB = 64;
    public static final int DDCREUSE = 128;
    public static final int DDCSPEED = 64;
    public static final int DDCEX255 = 32;
    public static final int DDCLOGRP = 16;
    public static final int DDCA2GB = 128;
    public static final int DDCRECLM = 64;
    public static final int DDCVSPUK = 128;
    public static final int DDCVSPUM = 64;

    DataClass(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.DC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    DataClass(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.DC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static DataClass from(VRecord record) {
        return new DataClass(record);
    }

    private int ddcnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String ddcname() {
        if (this.data.length >= 26 + this.ddcnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.ddcnmlen());
        }
        return null;
    }

    public String ddcuser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate ddcdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String ddcdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime ddctime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String ddctimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String ddcdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int ddcspec1() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public boolean ddcfrorg() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 128);
    }

    public boolean ddcflrec() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 64);
    }

    public boolean ddcfrfm() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 32);
    }

    public boolean ddcfklen() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 16);
    }

    public boolean ddcfkoff() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 8);
    }

    public boolean ddcfexp() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 4);
    }

    public boolean ddcfret() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 2);
    }

    public boolean ddcfpsp() {
        return Util.ConvertFlag(this.data, this.ddcspec1(), 1);
    }

    public int ddcspec2() {
        return Util.ConvertUnsignedBinary1(this.data, 205);
    }

    public boolean ddcfssp() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 128);
    }

    public boolean ddcfdir() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 64);
    }

    public boolean ddcfaun() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 32);
    }

    public boolean ddcfavr() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 16);
    }

    public boolean ddcfvol() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 8);
    }

    public boolean ddcfcis() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 4);
    }

    public boolean ddcfcif() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 2);
    }

    public boolean ddcfcaf() {
        return Util.ConvertFlag(this.data, this.ddcspec2(), 1);
    }

    public int ddcspec3() {
        return Util.ConvertUnsignedBinary1(this.data, 206);
    }

    public boolean ddcfxreg() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 128);
    }

    public boolean ddcfxsys() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 64);
    }

    public boolean ddcfimbd() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 32);
    }

    public boolean ddcfrplc() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 16);
    }

    public boolean ddcfcomp() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 8);
    }

    public boolean ddcfmedi() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 4);
    }

    public boolean ddcfrect() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 2);
    }

    public boolean ddcfvea() {
        return Util.ConvertFlag(this.data, this.ddcspec3(), 1);
    }

    public int ddcspec4() {
        return Util.ConvertUnsignedBinary1(this.data, 207);
    }

    public boolean ddcsprlf() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 128);
    }

    public boolean ddcredus() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 64);
    }

    public boolean ddcrabs() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 32);
    }

    public boolean ddcfct() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 16);
    }

    public boolean ddcblmt() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 8);
    }

    public boolean ddccfs() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 4);
    }

    public boolean ddcdvcs() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 2);
    }

    public boolean ddcfscal() {
        return Util.ConvertFlag(this.data, this.ddcspec4(), 1);
    }

    public Recorg ddcrcorg() {
        int value = Util.ConvertUnsignedBinary1(this.data, 208);
        return Recorg.from(value);
    }

    public int ddcrcorgRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public Recfm ddcrecfm() {
        switch (this.ddcrecfmRawValue()) {
            case 0: {
                return Recfm.NULL;
            }
            case 1: {
                return Recfm.U;
            }
            case 2: {
                return Recfm.V;
            }
            case 3: {
                return Recfm.VS;
            }
            case 4: {
                return Recfm.VB;
            }
            case 5: {
                return Recfm.VBS;
            }
            case 6: {
                return Recfm.F;
            }
            case 7: {
                return Recfm.FS;
            }
            case 8: {
                return Recfm.FB;
            }
            case 9: {
                return Recfm.FBS;
            }
        }
        return Recfm.NOT_DEFINED;
    }

    public int ddcrecfmRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 209);
    }

    public int ddcdsflg() {
        return Util.ConvertUnsignedBinary1(this.data, 210);
    }

    public boolean ddcblk() {
        return Util.ConvertFlag(this.data, this.ddcdsflg(), 128);
    }

    public boolean ddcstsp() {
        return Util.ConvertFlag(this.data, this.ddcdsflg(), 64);
    }

    public CarriageControl ddccntl() {
        int value = Util.ConvertUnsignedBinary1(this.data, 211);
        return CarriageControl.from(value);
    }

    public int ddccntlRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 211);
    }

    public int ddcretpd() {
        return Util.ConvertSignedBinary4(this.data, 212);
    }

    public int ddcexpyr() {
        return Util.ConvertSignedBinary2(this.data, 212);
    }

    public int ddcexpdy() {
        return Util.ConvertSignedBinary2(this.data, 214);
    }

    public int ddcvolct() {
        return Util.ConvertSignedBinary2(this.data, 216);
    }

    public Dsntype ddcdsnty() {
        int value = Util.ConvertUnsignedBinary2(this.data, 218);
        return Dsntype.from(value);
    }

    public int ddcdsntyRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 218);
    }

    public int ddcsppri() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    public int ddcspsec() {
        return Util.ConvertSignedBinary4(this.data, 224);
    }

    public int ddcdiblk() {
        return Util.ConvertSignedBinary4(this.data, 228);
    }

    public Avgrec ddcavrec() {
        int value = Util.ConvertUnsignedBinary1(this.data, 232);
        return Avgrec.from(value);
    }

    public int ddcavrecRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 232);
    }

    public int ddcreduc() {
        return Util.ConvertUnsignedBinary1(this.data, 233);
    }

    public RecordBias ddcrbias() {
        int value = Util.ConvertUnsignedBinary1(this.data, 234);
        return RecordBias.from(value);
    }

    public int ddcrbiasRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 234);
    }

    public int ddcdvc() {
        return Util.ConvertUnsignedBinary1(this.data, 235);
    }

    public int ddcaunit() {
        return Util.ConvertSignedBinary4(this.data, 236);
    }

    public int ddclrecl() {
        return Util.ConvertSignedBinary4(this.data, 244);
    }

    public int ddccisz() {
        return Util.ConvertSignedBinary4(this.data, 248);
    }

    public int ddccipct() {
        return Util.ConvertSignedBinary2(this.data, 252);
    }

    public int ddccapct() {
        return Util.ConvertSignedBinary2(this.data, 254);
    }

    public int ddcshrop() {
        return Util.ConvertUnsignedBinary2(this.data, 256);
    }

    public int ddcxreg() {
        return Util.ConvertUnsignedBinary1(this.data, 256);
    }

    public int ddcxsys() {
        return Util.ConvertUnsignedBinary1(this.data, 257);
    }

    public int ddcvindx() {
        return Util.ConvertUnsignedBinary1(this.data, 258);
    }

    public boolean ddcimbed() {
        return Util.ConvertFlag(this.data, this.ddcvindx(), 128);
    }

    public boolean ddcreplc() {
        return Util.ConvertFlag(this.data, this.ddcvindx(), 64);
    }

    public int ddcklen() {
        return Util.ConvertUnsignedBinary1(this.data, 259);
    }

    public int ddckoff() {
        return Util.ConvertSignedBinary2(this.data, 260);
    }

    public int ddccamt() {
        return Util.ConvertUnsignedBinary1(this.data, 262);
    }

    public Compaction ddccomp() {
        int value = Util.ConvertUnsignedBinary1(this.data, 264);
        return Compaction.from(value);
    }

    public int ddccompRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 264);
    }

    public Media ddcmedia() {
        int value = Util.ConvertUnsignedBinary1(this.data, 265);
        return Media.from(value);
    }

    public int ddcmediaRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 265);
    }

    public RecTec ddcrecte() {
        int value = Util.ConvertUnsignedBinary1(this.data, 266);
        return RecTec.from(value);
    }

    public int ddcrecteRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 266);
    }

    public long ddcrls1() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public BwoType ddcbwotp() {
        int value = Util.ConvertUnsignedBinary1(this.data, 268);
        return BwoType.from(value);
    }

    public int ddcbwotpRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 268);
    }

    public LogRc ddclogrc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 269);
        return LogRc.from(value);
    }

    public int ddclogrcRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 269);
    }

    public Span ddcspand() {
        int value = Util.ConvertUnsignedBinary1(this.data, 270);
        return Span.from(value);
    }

    public int ddcspandRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 270);
    }

    public int ddcfrlog() {
        return Util.ConvertUnsignedBinary1(this.data, 271);
    }

    private int ddclogln() {
        return Util.ConvertUnsignedBinary2(this.data, 272);
    }

    public String ddclogid() {
        if (this.data.length >= 274 + this.ddclogln()) {
            return Util.ConvertEbcdic(this.data, 274, this.ddclogln());
        }
        return null;
    }

    public int ddcspeca() {
        return Util.ConvertUnsignedBinary1(this.data, 300);
    }

    public boolean ddcbwos() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 128);
    }

    public boolean ddclogrs() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 64);
    }

    public boolean ddcspans() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 32);
    }

    public boolean ddclsids() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 16);
    }

    public boolean ddcfrlgs() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 8);
    }

    public boolean ddcfextc() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 4);
    }

    public boolean ddcfa2gb() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 2);
    }

    public boolean ddcfpseg() {
        return Util.ConvertFlag(this.data, this.ddcspeca(), 1);
    }

    public int ddcspecb() {
        return Util.ConvertUnsignedBinary1(this.data, 301);
    }

    public boolean ddcfkyl1() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 128);
    }

    public boolean ddcfkyc1() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 64);
    }

    public boolean ddcfkyl2() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 32);
    }

    public boolean ddcfkyc2() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 16);
    }

    public boolean ddcfvsp() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 8);
    }

    public boolean ddcfsdb() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 4);
    }

    public boolean ddcfovrd() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 2);
    }

    public boolean dcdfcar() {
        return Util.ConvertFlag(this.data, this.ddcspecb(), 1);
    }

    public int ddcspecc() {
        return Util.ConvertUnsignedBinary1(this.data, 302);
    }

    public boolean ddcfattr() {
        return Util.ConvertFlag(this.data, this.ddcspecc(), 128);
    }

    public boolean ddcflogr() {
        return Util.ConvertFlag(this.data, this.ddcspecc(), 64);
    }

    public boolean ddcfrmod() {
        return Util.ConvertFlag(this.data, this.ddcspecc(), 32);
    }

    public boolean ddcgsrdu() {
        return Util.ConvertFlag(this.data, this.ddcspecc(), 16);
    }

    public boolean ddcfklbl() {
        return Util.ConvertFlag(this.data, this.ddcspecc(), 8);
    }

    public int ddcspecd() {
        return Util.ConvertUnsignedBinary1(this.data, 303);
    }

    public int ddcsflg() {
        return Util.ConvertUnsignedBinary1(this.data, 304);
    }

    public boolean ddcovrd() {
        return Util.ConvertFlag(this.data, this.ddcsflg(), 128);
    }

    public boolean ddcsdb() {
        return Util.ConvertFlag(this.data, this.ddcsflg(), 64);
    }

    public int ddcvbyt1() {
        return Util.ConvertUnsignedBinary1(this.data, 305);
    }

    public boolean ddcreuse() {
        return Util.ConvertFlag(this.data, this.ddcvbyt1(), 128);
    }

    public boolean ddcspeed() {
        return Util.ConvertFlag(this.data, this.ddcvbyt1(), 64);
    }

    public boolean ddcex255() {
        return Util.ConvertFlag(this.data, this.ddcvbyt1(), 32);
    }

    public boolean ddclogrp() {
        return Util.ConvertFlag(this.data, this.ddcvbyt1(), 16);
    }

    public EAttr ddceattr() {
        int value = Util.ConvertUnsignedBinary1(this.data, 309);
        return EAttr.from(value);
    }

    public int ddceattrRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 309);
    }

    public int ddcct() {
        return Util.ConvertUnsignedBinary1(this.data, 310);
    }

    public int ddcdscf() {
        return Util.ConvertUnsignedBinary1(this.data, 311);
    }

    public int ddcrbyte() {
        return Util.ConvertUnsignedBinary1(this.data, 312);
    }

    public boolean ddca2gb() {
        return Util.ConvertFlag(this.data, this.ddcrbyte(), 128);
    }

    public boolean ddcreclm() {
        return Util.ConvertFlag(this.data, this.ddcrbyte(), 64);
    }

    public long ddcblklm() {
        return Util.ConvertSignedBinary8(this.data, 313);
    }

    public long ddcbszlm() {
        return Util.ConvertUnsignedBinary4(this.data, 317);
    }

    public String ddcpsca() {
        return Util.ConvertEbcdic(this.data, 321, 1);
    }

    public String ddcpseg() {
        return Util.ConvertEbcdic(this.data, 322, 1);
    }

    public int ddcvspu() {
        return Util.ConvertUnsignedBinary1(this.data, 328);
    }

    public boolean ddcvspuk() {
        return Util.ConvertFlag(this.data, this.ddcvspu(), 128);
    }

    public boolean ddcvspum() {
        return Util.ConvertFlag(this.data, this.ddcvspu(), 64);
    }

    public int ddcvspv() {
        return Util.ConvertUnsignedBinary3(this.data, 329);
    }

    public int ddcklbl1() {
        return Util.ConvertUnsignedBinary2(this.data, 332);
    }

    public String ddcklbn1() {
        if (this.data.length >= 334 + this.ddcklbl1()) {
            return Util.ConvertEbcdic(this.data, 334, this.ddcklbl1());
        }
        return null;
    }

    public int ddckycd1() {
        return Util.ConvertUnsignedBinary1(this.data, 398);
    }

    public int ddcklbl2() {
        return Util.ConvertUnsignedBinary2(this.data, 400);
    }

    public String ddcklbn2() {
        if (this.data.length >= 402 + this.ddcklbl2()) {
            return Util.ConvertEbcdic(this.data, 402, this.ddcklbl2());
        }
        return null;
    }

    public int ddckycd2() {
        return Util.ConvertUnsignedBinary1(this.data, 466);
    }

    public int ddcrmode() {
        return Util.ConvertUnsignedBinary1(this.data, 469);
    }

    public int ddcdklbl() {
        return Util.ConvertUnsignedBinary2(this.data, 470);
    }

    public String ddcdklbn() {
        if (this.data.length >= 472 + this.ddcdklbl()) {
            return Util.ConvertEbcdic(this.data, 472, this.ddcdklbl());
        }
        return null;
    }

    public static enum Dsntype {
        NULL(0),
        PDS(1),
        LIBRARY(2),
        HFS(3),
        EXTENDED_R(4),
        EXTENDED_C(5),
        LARGE(6),
        NEXT(7),
        NOT_DEFINED(-16);

        private static Map<Integer, Dsntype> valueMap;
        private final transient int dcdsntype;

        private Dsntype(int dcdsntype) {
            this.dcdsntype = dcdsntype;
        }

        public static Dsntype from(int value) {
            Dsntype result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcdsntype() {
            return this.dcdsntype;
        }

        static {
            valueMap = new HashMap<Integer, Dsntype>();
            for (Dsntype x : Dsntype.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcdsntype, x);
            }
        }
    }

    public static enum Avgrec {
        NULL(0),
        BYTES(1),
        KB(2),
        MB(3),
        NOT_DEFINED(-16);

        private static Map<Integer, Avgrec> valueMap;
        private final transient int dcavgrec;

        private Avgrec(int dcavgrec) {
            this.dcavgrec = dcavgrec;
        }

        public static Avgrec from(int value) {
            Avgrec result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcavgrec() {
            return this.dcavgrec;
        }

        static {
            valueMap = new HashMap<Integer, Avgrec>();
            for (Avgrec x : Avgrec.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcavgrec, x);
            }
        }
    }

    public static enum RecordBias {
        USER(0),
        SYSTEM(1),
        DO(2),
        DW(3),
        SO(4),
        SW(5),
        NOT_DEFINED(-16);

        private static Map<Integer, RecordBias> valueMap;
        private final transient int dcrecordbias;

        private RecordBias(int dcrecordbias) {
            this.dcrecordbias = dcrecordbias;
        }

        public static RecordBias from(int value) {
            RecordBias result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcrecordbias() {
            return this.dcrecordbias;
        }

        static {
            valueMap = new HashMap<Integer, RecordBias>();
            for (RecordBias x : RecordBias.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcrecordbias, x);
            }
        }
    }

    public static enum Compaction {
        NULL(0),
        NONE(1),
        IDRC(2),
        NOT_DEFINED(-16);

        private static Map<Integer, Compaction> valueMap;
        private final transient int dccompact;

        private Compaction(int dccompact) {
            this.dccompact = dccompact;
        }

        public static Compaction from(int value) {
            Compaction result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dccompact() {
            return this.dccompact;
        }

        static {
            valueMap = new HashMap<Integer, Compaction>();
            for (Compaction x : Compaction.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dccompact, x);
            }
        }
    }

    public static enum Media {
        NULL(0),
        MEDIA1(1),
        MEDIA2(2),
        MEDIA3(3),
        MEDIA4(4),
        MEDIA5(5),
        MEDIA6(6),
        MEDIA7(7),
        MEDIA8(8),
        MEDIA9(9),
        MEDIA10(10),
        MEDIA11(11),
        MEDIA12(12),
        MEDIA13(13),
        NOT_DEFINED(-16);

        private static Map<Integer, Media> valueMap;
        private final transient int dcmedia;

        private Media(int dcmedia) {
            this.dcmedia = dcmedia;
        }

        public static Media from(int value) {
            Media result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcmedia() {
            return this.dcmedia;
        }

        static {
            valueMap = new HashMap<Integer, Media>();
            for (Media x : Media.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcmedia, x);
            }
        }
    }

    public static enum RecTec {
        NULL(0),
        TRK18(1),
        TRK36(2),
        TRK128(3),
        TRK256(4),
        TRK384(5),
        EFMT1(6),
        EFMT2(7),
        EEFM2(8),
        EFMT3(9),
        EEFM3(10),
        EFMT4(11),
        EEFM4(12),
        NOT_DEFINED(-16);

        private static Map<Integer, RecTec> valueMap;
        private final transient int dcrectec;

        private RecTec(int dcrectec) {
            this.dcrectec = dcrectec;
        }

        public static RecTec from(int value) {
            RecTec result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcrectec() {
            return this.dcrectec;
        }

        static {
            valueMap = new HashMap<Integer, RecTec>();
            for (RecTec x : RecTec.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcrectec, x);
            }
        }
    }

    public static enum BwoType {
        NULL(0),
        CICS(1),
        NONE(2),
        IMS(3),
        NOT_DEFINED(-16);

        private static Map<Integer, BwoType> valueMap;
        private final transient int dcbwotyp;

        private BwoType(int dcbwotyp) {
            this.dcbwotyp = dcbwotyp;
        }

        public static BwoType from(int value) {
            BwoType result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcbwotyp() {
            return this.dcbwotyp;
        }

        static {
            valueMap = new HashMap<Integer, BwoType>();
            for (BwoType x : BwoType.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcbwotyp, x);
            }
        }
    }

    public static enum LogRc {
        NULL(0),
        NON_RECOVERABLE(1),
        UNDO(2),
        ALL(3),
        NOT_DEFINED(-16);

        private static Map<Integer, LogRc> valueMap;
        private final transient int dclogrc;

        private LogRc(int dclogrc) {
            this.dclogrc = dclogrc;
        }

        public static LogRc from(int value) {
            LogRc result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dclogrc() {
            return this.dclogrc;
        }

        static {
            valueMap = new HashMap<Integer, LogRc>();
            for (LogRc x : LogRc.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dclogrc, x);
            }
        }
    }

    public static enum Span {
        NO(0),
        YES(1),
        NOT_DEFINED(-16);

        private static Map<Integer, Span> valueMap;
        private final transient int dcspan;

        private Span(int dcspan) {
            this.dcspan = dcspan;
        }

        public static Span from(int value) {
            Span result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int dcspan() {
            return this.dcspan;
        }

        static {
            valueMap = new HashMap<Integer, Span>();
            for (Span x : Span.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.dcspan, x);
            }
        }
    }

    static enum Field {
        ddcnmlen(24, 2),
        ddcname(26, 0),
        ddcuser(56, 8),
        ddcdate(64, 10),
        ddctime(76, 8),
        ddcdesc(84, 120),
        ddcspec1(204, 1),
        ddcspec2(205, 1),
        ddcspec3(206, 1),
        ddcspec4(207, 1),
        ddcrcorg(208, 1),
        ddcrecfm(209, 1),
        ddcdsflg(210, 1),
        ddccntl(211, 1),
        ddcretpd(212, 4),
        ddcexpyr(212, 2),
        ddcexpdy(214, 2),
        ddcvolct(216, 2),
        ddcdsnty(218, 2),
        ddcsppri(220, 4),
        ddcspsec(224, 4),
        ddcdiblk(228, 4),
        ddcavrec(232, 1),
        ddcreduc(233, 1),
        ddcrbias(234, 1),
        ddcdvc(235, 1),
        ddcaunit(236, 4),
        ddclrecl(244, 4),
        ddccisz(248, 4),
        ddccipct(252, 2),
        ddccapct(254, 2),
        ddcshrop(256, 2),
        ddcxreg(256, 1),
        ddcxsys(257, 1),
        ddcvindx(258, 1),
        ddcklen(259, 1),
        ddckoff(260, 2),
        ddccamt(262, 1),
        ddccomp(264, 1),
        ddcmedia(265, 1),
        ddcrecte(266, 1),
        ddcrls1(268, 4),
        ddcbwotp(268, 1),
        ddclogrc(269, 1),
        ddcspand(270, 1),
        ddcfrlog(271, 1),
        ddclogln(272, 2),
        ddclogid(274, 0),
        ddcspeca(300, 1),
        ddcspecb(301, 1),
        ddcspecc(302, 1),
        ddcspecd(303, 1),
        ddcsflg(304, 1),
        ddcvbyt1(305, 1),
        ddceattr(309, 1),
        ddcct(310, 1),
        ddcdscf(311, 1),
        ddcrbyte(312, 1),
        ddcblklm(313, 8),
        ddcbszlm(317, 4),
        ddcpsca(321, 1),
        ddcpseg(322, 1),
        ddcvspu(328, 1),
        ddcvspv(329, 3),
        ddcklbl1(332, 2),
        ddcklbn1(334, 0),
        ddckycd1(398, 1),
        ddcklbl2(400, 2),
        ddcklbn2(402, 0),
        ddckycd2(466, 1),
        ddcrmode(469, 1),
        ddcdklbl(470, 2),
        ddcdklbn(472, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

