/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.MigrationLevel;
import com.blackhillsoftware.dcollect.values.Recorg;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.dataset.Dsorg;
import com.blackhillsoftware.smf.dataset.Recfm;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class MigratedDataset
extends DcollectRecord {
    public static final int UMCHIND = 32;
    public static final int UMSDSP = 16;
    public static final int UMESDS = 128;
    public static final int UMKSDS = 64;
    public static final int UMLDS = 32;
    public static final int UMRRDS = 16;
    public static final int UMRACFD = 128;
    public static final int UMGDS = 64;
    public static final int UMREBLK = 32;
    public static final int UMPDSE = 16;
    public static final int UMSMSM = 8;
    public static final int UMCOMPR = 4;
    public static final int UMLFS = 2;
    public static final int UMENCRP = 1;
    public static final int UMEMPTY = 128;
    public static final int UM_CA_RECLAIM_ELIG = 64;
    public static final int UMZFS = 32;
    public static final int UMENCRDP = 16;
    public static final int UM_BSON = 8;
    public static final int UM_JSON = 4;
    public static final int UM_CLD_COMP = 2;
    public static final int UM_CLD_ENCRYPT = 1;
    public static final int UMALLSP_FMB = 128;
    public static final int UMUSESP_FMB = 64;
    public static final int UMRECSP_FMB = 32;
    public static final int UMDSIZE_FMB = 16;
    public static final int UM_FMB = 8;

    MigratedDataset(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.M)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    MigratedDataset(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.M)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static MigratedDataset from(VRecord record) {
        return new MigratedDataset(record);
    }

    public String umdsnam() {
        return Util.ConvertEbcdic(this.data, 24, 44);
    }

    public int umflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public MigrationLevel umlevel() {
        int value = Util.ConvertUnsignedBinary1(this.data, 68, 192);
        return MigrationLevel.from(value);
    }

    public int umlevelRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 68, 192);
    }

    public boolean umchind() {
        return Util.ConvertFlag(this.data, this.umflag1(), 32);
    }

    public boolean umsdsp() {
        return Util.ConvertFlag(this.data, this.umflag1(), 16);
    }

    public String umdevcl() {
        return Util.ConvertEbcdic(this.data, 69, 1);
    }

    public int umdevclRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 69);
    }

    public Dsorg umdsorg() {
        return Dsorg.fromDsorgBytes(this.umdsorgRawValue());
    }

    public int umdsorgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public long umdsize() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public double umdsizeMB() {
        if (this.umdsizeFmb()) {
            return this.umdsize();
        }
        return (double)this.umdsize() / 1024.0;
    }

    public LocalTime umtime() {
        return Util.Binary4hhmmssth(this.data, 76);
    }

    public long umtimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public LocalDate umdate() {
        return Util.Packed4YYYYDDD(this.data, 80);
    }

    public int umdateRawValue() {
        return Util.ConvertPacked4(this.data, 80);
    }

    public LocalDateTime ummdate() {
        return this.umdate() != null ? this.umdate().atTime(this.umtime()) : null;
    }

    private int umdclng() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public String umdatcl() {
        if (this.data.length >= 86 + this.umdclng()) {
            return Util.ConvertEbcdic(this.data, 86, this.umdclng());
        }
        return null;
    }

    private int umsclng() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public String umstgcl() {
        if (this.data.length >= 118 + this.umsclng()) {
            return Util.ConvertEbcdic(this.data, 118, this.umsclng());
        }
        return null;
    }

    private int ummclng() {
        return Util.ConvertUnsignedBinary2(this.data, 148);
    }

    public String ummgtcl() {
        if (this.data.length >= 150 + this.ummclng()) {
            return Util.ConvertEbcdic(this.data, 150, this.ummclng());
        }
        return null;
    }

    public Recfm umrecrd() {
        return Recfm.fromRecfmByte(this.umrecrdRawValue());
    }

    public int umrecrdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 180);
    }

    public Recorg umrecor() {
        int value = this.umrecorRawValue() & 0xF0;
        switch (value) {
            case 128: {
                return Recorg.ESDS;
            }
            case 64: {
                return Recorg.KSDS;
            }
            case 32: {
                return Recorg.LDS;
            }
            case 16: {
                return Recorg.RRDS;
            }
            case 0: {
                return Recorg.NULL;
            }
        }
        return Recorg.NOT_DEFINED;
    }

    public int umrecorRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 181);
    }

    public boolean umesds() {
        return Util.ConvertFlag(this.data, this.umrecorRawValue(), 128);
    }

    public boolean umksds() {
        return Util.ConvertFlag(this.data, this.umrecorRawValue(), 64);
    }

    public boolean umlds() {
        return Util.ConvertFlag(this.data, this.umrecorRawValue(), 32);
    }

    public boolean umrrds() {
        return Util.ConvertFlag(this.data, this.umrecorRawValue(), 16);
    }

    public int umbklng() {
        return Util.ConvertUnsignedBinary2(this.data, 182);
    }

    public int umflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 184);
    }

    public boolean umracfd() {
        return Util.ConvertFlag(this.data, this.umflag2(), 128);
    }

    public boolean umgds() {
        return Util.ConvertFlag(this.data, this.umflag2(), 64);
    }

    public boolean umreblk() {
        return Util.ConvertFlag(this.data, this.umflag2(), 32);
    }

    public boolean umpdse() {
        return Util.ConvertFlag(this.data, this.umflag2(), 16);
    }

    public boolean umsmsm() {
        return Util.ConvertFlag(this.data, this.umflag2(), 8);
    }

    public boolean umcompr() {
        return Util.ConvertFlag(this.data, this.umflag2(), 4);
    }

    public boolean umlfs() {
        return Util.ConvertFlag(this.data, this.umflag2(), 2);
    }

    public boolean umencrp() {
        return Util.ConvertFlag(this.data, this.umflag2(), 1);
    }

    public int umpdsev() {
        return Util.ConvertUnsignedBinary1(this.data, 185);
    }

    public int umnmig() {
        return Util.ConvertSignedBinary2(this.data, 186);
    }

    public int umallsp() {
        return Util.ConvertSignedBinary4(this.data, 188);
    }

    public double umallspMB() {
        if (this.umallspFmb()) {
            return this.umallsp();
        }
        return (double)this.umallsp() / 1024.0;
    }

    public int umusesp() {
        return Util.ConvertSignedBinary4(this.data, 192);
    }

    public double umusespMB() {
        if (this.umusespFmb()) {
            return this.umusesp();
        }
        return (double)this.umusesp() / 1024.0;
    }

    public int umrecsp() {
        return Util.ConvertSignedBinary4(this.data, 196);
    }

    public double umrecspMB() {
        if (this.umrecspFmb()) {
            return this.umrecsp();
        }
        return (double)this.umrecsp() / 1024.0;
    }

    public LocalDate umcredt() {
        return Util.Packed4YYYYDDD(this.data, 200);
    }

    public int umcredtRawValue() {
        return Util.ConvertPacked4(this.data, 200);
    }

    public LocalDate umexpdt() {
        return Util.Packed4YYYYDDD(this.data, 204);
    }

    public int umexpdtRawValue() {
        return Util.ConvertPacked4(this.data, 204);
    }

    public ZonedDateTime umlbkdt() {
        return Util.Binary8xStckTime(this.data, 208);
    }

    public BigInteger umlbkdtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 208);
    }

    public LocalDate umlrfdt() {
        return Util.Packed4YYYYDDD(this.data, 216);
    }

    public int umlrfdtRawValue() {
        return Util.ConvertPacked4(this.data, 216);
    }

    public int umUserDatasize() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    public double umUserDatasizeMB() {
        if (this.umFmb()) {
            return this.umUserDatasize();
        }
        return (double)this.umUserDatasize() / 1024.0;
    }

    public int umCompDatasize() {
        return Util.ConvertSignedBinary4(this.data, 224);
    }

    public double umCompDatasizeMB() {
        if (this.umFmb()) {
            return this.umCompDatasize();
        }
        return (double)this.umCompDatasize() / 1024.0;
    }

    public String umfrvol() {
        return Util.ConvertEbcdic(this.data, 228, 6);
    }

    public long umlrecl() {
        return Util.ConvertUnsignedBinary4(this.data, 234);
    }

    public int umflag3() {
        return Util.ConvertUnsignedBinary1(this.data, 238);
    }

    public boolean umempty() {
        return Util.ConvertFlag(this.data, this.umflag3(), 128);
    }

    public boolean umCaReclaimElig() {
        return Util.ConvertFlag(this.data, this.umflag3(), 64);
    }

    public boolean umzfs() {
        return Util.ConvertFlag(this.data, this.umflag3(), 32);
    }

    public boolean umencrdp() {
        return Util.ConvertFlag(this.data, this.umflag3(), 16);
    }

    public boolean umBson() {
        return Util.ConvertFlag(this.data, this.umflag3(), 8);
    }

    public boolean umJson() {
        return Util.ConvertFlag(this.data, this.umflag3(), 4);
    }

    public boolean umCldComp() {
        return Util.ConvertFlag(this.data, this.umflag3(), 2);
    }

    public boolean umCldEncrypt() {
        return Util.ConvertFlag(this.data, this.umflag3(), 1);
    }

    public int umflag4() {
        return Util.ConvertUnsignedBinary1(this.data, 239);
    }

    public boolean umallspFmb() {
        return Util.ConvertFlag(this.data, this.umflag4(), 128);
    }

    public boolean umusespFmb() {
        return Util.ConvertFlag(this.data, this.umflag4(), 64);
    }

    public boolean umrecspFmb() {
        return Util.ConvertFlag(this.data, this.umflag4(), 32);
    }

    public boolean umdsizeFmb() {
        return Util.ConvertFlag(this.data, this.umflag4(), 16);
    }

    public boolean umFmb() {
        return Util.ConvertFlag(this.data, this.umflag4(), 8);
    }

    private int umCloudNameLength() {
        return Util.ConvertUnsignedBinary2(this.data, 240);
    }

    public String umCloudName() {
        if (this.data.length >= 242 + this.umCloudNameLength()) {
            return Util.ConvertEbcdic(this.data, 242, this.umCloudNameLength());
        }
        return null;
    }

    public String umContainerName() {
        return Util.ConvertEbcdic(this.data, 272, 44);
    }

    public long umObjNumber() {
        return Util.ConvertUnsignedBinary4(this.data, 316);
    }

    public int umCldCompPercent() {
        return Util.ConvertUnsignedBinary1(this.data, 320);
    }

    public int umencrpt() {
        return Util.ConvertUnsignedBinary2(this.data, 352);
    }

    public String umencrpl() {
        return Util.ConvertEbcdic(this.data, 354, 64);
    }

    static enum Field {
        umdsnam(24, 44),
        umflag1(68, 1),
        umlevel(68, 1),
        umdevcl(69, 1),
        umdsorg(70, 2),
        umdsize(72, 4),
        umtime(76, 4),
        umdate(80, 4),
        umdclng(84, 2),
        umdatcl(86, 0),
        umsclng(116, 2),
        umstgcl(118, 0),
        ummclng(148, 2),
        ummgtcl(150, 0),
        umrecrd(180, 1),
        umrecor(181, 1),
        umbklng(182, 2),
        umflag2(184, 1),
        umpdsev(185, 1),
        umnmig(186, 2),
        umallsp(188, 4),
        umusesp(192, 4),
        umrecsp(196, 4),
        umcredt(200, 4),
        umexpdt(204, 4),
        umlbkdt(208, 8),
        umlrfdt(216, 4),
        umUserDatasize(220, 4),
        umCompDatasize(224, 4),
        umfrvol(228, 6),
        umlrecl(234, 4),
        umflag3(238, 1),
        umflag4(239, 1),
        umCloudNameLength(240, 2),
        umCloudName(242, 0),
        umContainerName(272, 44),
        umObjNumber(316, 4),
        umCldCompPercent(320, 1),
        umencrpt(352, 2),
        umencrpl(354, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

