/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.common.KeyManager;
import com.blackhillsoftware.common.Message;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.Smf90Record;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmfRecord
extends SmfData {
    static final int maxTimeOfDay = 9000000;

    static void setupGcLog() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
                List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean bean : gcBeans) {
                    if (!bean.isValid() || bean.getCollectionCount() <= 0L) continue;
                    slf4jLogger.info(String.format("GC: %s - Collections: %d Time: %s", bean.getName(), bean.getCollectionCount(), Duration.ofMillis(bean.getCollectionTime())));
                }
                List<MemoryPoolMXBean> memoryBeans = ManagementFactory.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean bean : memoryBeans) {
                    if (!bean.isValid() || bean.getType() != MemoryType.HEAP || bean.getPeakUsage().getUsed() <= 0L) continue;
                    slf4jLogger.info("Heap : " + bean.getName());
                    slf4jLogger.info(bean.getPeakUsage().toString());
                }
            }
        });
    }

    static void checkPrereqs() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"Prerequisites");
        try {
            double javaversion = Double.parseDouble(System.getProperty("java.specification.version"));
            if (javaversion < 1.8) {
                throw new RuntimeException(String.format("Java version 1.8 or higher is required - version %f detected", javaversion));
            }
        }
        catch (NumberFormatException e) {
            slf4jLogger.error("Unable to parse JVM version property");
        }
    }

    public SmfRecord(byte[] data) {
        super(data);
    }

    public static SmfRecord from(byte[] data) {
        return new SmfRecord(data);
    }

    public SmfRecord(SmfRecord record) {
        super(record.data);
    }

    public SmfRecord(Data record) {
        super(record.data);
    }

    public static int recordLength(byte[] data) {
        return Util.ConvertUnsignedBinary2(data, 0);
    }

    public int recordLength() {
        return SmfRecord.recordLength(this.data);
    }

    public static boolean hasSubtypes(byte[] data) {
        if ((data[4] & 0x40) == 0) {
            return SmfRecord.recordType(data) == 90;
        }
        return true;
    }

    public boolean hasSubtypes() {
        return SmfRecord.hasSubtypes(this.data);
    }

    public static boolean extendedHeader(byte[] data) {
        return (data[4] & 0x20) != 0 && (data[5] & 0xFF) == 126;
    }

    public boolean extendedHeader() {
        return SmfRecord.extendedHeader(this.data);
    }

    public static int recordType(byte[] data) {
        if (!SmfRecord.extendedHeader(data)) {
            return data[5] & 0xFF;
        }
        int offset = 52;
        int value = (data[offset++] & 0xFF) << 8;
        return value ^= data[offset] & 0xFF;
    }

    static int recordTypeNoRdw(byte[] data) {
        return data[1] & 0xFF;
    }

    public int recordType() {
        return SmfRecord.recordType(this.data);
    }

    public static String system(byte[] data) {
        return Util.ConvertEbcdic(data, 14, 4);
    }

    public String system() {
        return SmfRecord.system(this.data);
    }

    public static LocalTime smfTime(byte[] data) {
        return Util.Binary4x100STime(data, 6);
    }

    public LocalTime smfTime() {
        return SmfRecord.smfTime(this.data);
    }

    public static LocalDate smfDate(byte[] data) {
        return Util.SMFDate(data, 10);
    }

    public LocalDate smfDate() {
        return SmfRecord.smfDate(this.data);
    }

    public static LocalDateTime smfDateTime(byte[] data) {
        if (!SmfRecord.extendedHeader(data)) {
            return SmfRecord.smfDate(data).atTime(SmfRecord.smfTime(data));
        }
        SmfRecord r = new SmfRecord(data);
        return r.smfDateTime();
    }

    public LocalDateTime smfDateTime() {
        if (!this.extendedHeader()) {
            return SmfRecord.smfDateTime(this.data);
        }
        return this.smfhdr1Stcke().withZoneSameInstant(this.smfhdr1Tzo()).toLocalDateTime();
    }

    public static String subSystem(byte[] data) {
        if (!SmfRecord.hasSubtypes(data)) {
            return null;
        }
        return Util.ConvertEbcdic(data, 18, 4);
    }

    public String subSystem() {
        return SmfRecord.subSystem(this.data);
    }

    public static int subType(byte[] data) {
        switch (SmfRecord.recordType(data)) {
            case 90: {
                return new Smf90Record(data).productHeader().smf90tid();
            }
        }
        if (!SmfRecord.hasSubtypes(data)) {
            throw new NotAvailableException("Record does not have subtypes");
        }
        if (data.length < 24) {
            return 0;
        }
        return Util.ConvertUnsignedBinary2(data, 22);
    }

    public int subType() {
        return SmfRecord.subType(this.data);
    }

    public static int smfhdr1Len(byte[] data) {
        if (!SmfRecord.extendedHeader(data)) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertUnsignedBinary2(data, 24);
    }

    public int smfhdr1Len() {
        return SmfRecord.smfhdr1Len(this.data);
    }

    public static int smfhdr1Version(byte[] data) {
        if (!SmfRecord.extendedHeader(data)) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertUnsignedBinary1(data, 26);
    }

    public int smfhdr1Version() {
        return SmfRecord.smfhdr1Version(this.data);
    }

    public int smfhdr1Flag() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public boolean smfhdr1Iefu86() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertFlag(this.data, this.smfhdr1Flag(), 128, 1, 0);
    }

    public ZonedDateTime smfhdr1Stcke() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.Binary16StckeTime(this.data, 28);
    }

    public BigInteger smfhdr1StckeRawValue() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertBigInteger(this.data, 28, 16);
    }

    public ZoneOffset smfhdr1Tzo() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.Binary8_STCK_GMT_Offset(this.data, 44);
    }

    public long smfhdr1TzoRawValue() {
        if (!this.extendedHeader()) {
            throw new NotAvailableException("Record does not have an extended header");
        }
        return Util.ConvertSignedBinary8(this.data, 44);
    }

    static boolean sanityCheck(byte[] data, int offset) {
        try {
            long time = Util.ConvertUnsignedBinary4(data, offset + 6);
            if (time > 9000000L) {
                return false;
            }
            int date = Util.ConvertPacked4(data, offset + 10);
            if (date < 0) {
                return false;
            }
            int year = date / 1000 + 1900;
            int day = date % 1000;
            if (date < 0 || year < 1990 || year > LocalDate.now().getYear() + 100 || day == 0 || day > 366) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean sanityCheck() {
        return SmfRecord.sanityCheck(this.data, 0);
    }

    @Override
    public <T> T createSection(byte[] data, int offset, int length, CreateSection<T> builder) {
        return builder.createSection(data, offset, length);
    }

    @Override
    public Triplet getTriplet(int offset) {
        return Triplet.get422Triplet(this.data, offset);
    }

    static {
        int line;
        SmfRecord.setupGcLog();
        Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
        slf4jLogger.info("EasySMF:JE Version: 2.4.2 2026-02-16T06:21:48Z");
        SmfRecord.checkPrereqs();
        List key = KeyManager.getKey((String)"EZSMFKEY");
        if (key == null) {
            key = KeyManager.getKey((String)"EasySMF:JE", (String)"EZSMFKEY", (String)"EASYSMFKEY");
        }
        String license = "";
        String sig = "";
        for (line = 0; line < key.size() && !((String)key.get(line)).startsWith("**License:"); ++line) {
        }
        ++line;
        while (line < key.size() && !((String)key.get(line)).startsWith("**Sig:")) {
            license = license + ((String)key.get(line)).substring(0, Math.min(((String)key.get(line)).length(), 72)).trim();
            ++line;
        }
        ++line;
        while (line < key.size() && !((String)key.get(line)).startsWith("**End")) {
            sig = sig + ((String)key.get(line)).substring(0, Math.min(((String)key.get(line)).length(), 72)).trim();
            ++line;
        }
        if (license.length() == 0 && sig.length() == 0) {
            Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Invalid Key"));
            System.exit(1);
        } else {
            Base64.Decoder decoder = Base64.getMimeDecoder();
            byte[] decodedLicense = decoder.decode(license);
            byte[] decodedSig = decoder.decode(sig);
            String licString = new String(decodedLicense, StandardCharsets.UTF_8);
            try {
                Signature sig2 = Signature.getInstance("SHA1WithRSA");
                byte[] expBytes = decoder.decode("AQAB");
                byte[] modBytes = decoder.decode("+k3UcbZ5knkhX3jzBh95ZNdbHTPIBi/i9tbUdEJbYd2Rx8Nzlzhxn4kMxrZ5fXqG23EVa1H/2wqsTT7zstBgSqyTyznPbJUiH9QnohlOCs9o0IuQWZUWaQ6z+qj7oXSllQegCO0ultm8aL55P4R6LMThZId9Zx/d/m18sg55NP8=");
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, modBytes), new BigInteger(1, expBytes));
                KeyFactory fact = KeyFactory.getInstance("RSA");
                PublicKey pubKey = fact.generatePublic(keySpec);
                sig2.initVerify(pubKey);
                sig2.update(decodedLicense);
                if (!sig2.verify(decodedSig)) {
                    Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key Verification Error"));
                    System.exit(1);
                } else {
                    String[] lines = licString.split("\\r?\\n");
                    if (lines.length > 3 && lines[3].trim().length() > 0 && !lines[3].contains("JE")) {
                        Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key is not for EasySMF:JE"));
                        System.exit(1);
                    }
                    int systems = Integer.parseInt(lines[0]);
                    LocalDate expiry = LocalDate.parse(lines[1], DateTimeFormatter.ISO_LOCAL_DATE);
                    if (LocalDate.now().isAfter(expiry.plusDays(30L))) {
                        Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("EasySMF License has expired", "Expiry: " + expiry.toString()));
                        System.exit(1);
                    } else if (LocalDate.now().isAfter(expiry)) {
                        Message.box(arg_0 -> ((Logger)slf4jLogger).warn(arg_0), Arrays.asList("EasySMF License has expired.", "Operating in grace period.", "Grace period expires: " + expiry.plusDays(30L).toString()));
                    } else if (LocalDate.now().isAfter(expiry.plusDays(-30L))) {
                        Message.box(arg_0 -> ((Logger)slf4jLogger).warn(arg_0), Arrays.asList("EasySMF License expires in less than 30 days.", "Expiry: " + expiry.toString()));
                    }
                    String name = lines.length > 2 ? lines[2] : "";
                    slf4jLogger.info("Licensed to: " + name);
                    if (expiry.getYear() < 9999) {
                        slf4jLogger.info("Expiry: " + expiry.toString());
                    }
                    slf4jLogger.info("z/OS processor complexes: " + Integer.toString(systems));
                }
            }
            catch (Exception e) {
                Message.hilite(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Key Error: " + e.getMessage() + System.lineSeparator() + e.getCause()));
                System.exit(1);
            }
        }
    }
}

