/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.db2.Smf100Record;
import com.blackhillsoftware.smf.db2.Smf101Record;
import com.blackhillsoftware.smf.db2.Smf102Record;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import com.blackhillsoftware.smf.smf92.Smf92Record;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ToStringConfig {
    private static final String secondsSuffix = "Seconds";
    private static final String rawValueSuffix = "RawValue";
    private static Map<Class<?>, Set<String>> excludeMethodsByClass = new HashMap();
    private static Set<String> excludeMethods = new HashSet<String>();

    ToStringConfig() {
    }

    static boolean include(Class<?> clazz, Method method) {
        int modifiers = method.getModifiers();
        if (method.getName().endsWith(rawValueSuffix)) {
            return false;
        }
        if (method.getName().endsWith(secondsSuffix)) {
            return false;
        }
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (method.getAnnotation(Deprecated.class) != null) {
            return false;
        }
        return !ToStringConfig.excludeName(clazz, method.getName());
    }

    private static void addExcludeMethod(Class<?> type, String value) {
        excludeMethodsByClass.computeIfAbsent(type, x -> new HashSet()).add(value);
    }

    static boolean excludeName(Class<?> clazz, String name) {
        if (excludeMethods.contains(name)) {
            return true;
        }
        Set<String> clazzMethods = excludeMethodsByClass.get(clazz);
        return clazzMethods != null && clazzMethods.contains(name);
    }

    static {
        ToStringConfig.addExcludeMethod(Smf30Record.class, "appcCumulativeResourceSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "appcResourceSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "completionSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "ioActivitySections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "operatorSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "performanceSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "processorAccountingSections");
        ToStringConfig.addExcludeMethod(Smf30Record.class, "storageSections");
        ToStringConfig.addExcludeMethod(Smf92Record.class, "identificationSections");
        ToStringConfig.addExcludeMethod(Smf92Record.class, "subsystemSections");
        ToStringConfig.addExcludeMethod(Smf100Record.class, "decompress");
        ToStringConfig.addExcludeMethod(Smf101Record.class, "decompress");
        ToStringConfig.addExcludeMethod(Smf102Record.class, "decompress");
        ToStringConfig.addExcludeMethod(SmfDb2Record.class, "decompress");
        ToStringConfig.addExcludeMethod(Smf110Record.class, "decompress");
        ToStringConfig.addExcludeMethod(Smf110Record.class, "dictionary");
        ToStringConfig.addExcludeMethod(Smf110Record.class, "cicsInstance");
        ToStringConfig.addExcludeMethod(Smf110Record.class, "fieldConnectors");
        ToStringConfig.addExcludeMethod(PerformanceRecord.class, "getDictionary");
        ToStringConfig.addExcludeMethod(PerformanceRecord.class, "getCicsInstanceId");
        ToStringConfig.addExcludeMethod(DictionaryEntry.class, "getFieldId");
        ToStringConfig.addExcludeMethod(ServiceReportClassPeriodDataSection.class, "controlSection");
        excludeMethods.addAll(Arrays.asList("dump", "getClass", "getBytes", "hashCode", "sanityCheck", "toString"));
    }
}

