/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.JzosRecordReader;
import com.blackhillsoftware.smf.RecordReader;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.StreamRecordReader;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.VRecordReaderIterator;
import com.blackhillsoftware.smf.VRecordReaderSpliterator;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Queue;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VRecordReader
extends RecordReader<VRecord>
implements Iterable<VRecord>,
Closeable {
    private Iterator<VRecord> theIterator = null;
    private Spliterator<VRecord> theSpliterator = null;

    VRecordReader() {
    }

    public static VRecordReader fromDD(String dd) throws IOException {
        return JzosRecordReader.fromDD(dd);
    }

    public static VRecordReader fromName(String name) throws IOException, FileNotFoundException {
        try {
            if (name.startsWith("//DD:")) {
                return JzosRecordReader.fromDD(name.substring(5));
            }
            if (name.startsWith("//LOGR:") || name.startsWith("//LOGSTREAM:")) {
                name = name.substring(name.indexOf(":") + 1);
                String lsParms = null;
                int cPos = name.indexOf(",");
                if (cPos != -1) {
                    lsParms = name.substring(cPos + 1);
                    name = name.substring(0, cPos);
                }
                return JzosRecordReader.fromLogstream(name, lsParms, null);
            }
            if (name.startsWith("//") && !name.startsWith("///")) {
                return JzosRecordReader.fromDatasetName(name);
            }
            return VRecordReader.fromStream(new FileInputStream(name));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(VRecord.class);
                slf4jLogger.error("Error trying to open " + name);
                slf4jLogger.error("This error is expected if trying to read from a DDNAME on a non-z/OS system.");
            }
            throw e;
        }
    }

    public static VRecordReader fromStream(InputStream stream) {
        return new StreamRecordReader(stream, SmfRecordReader.RecordFormat.V);
    }

    public static VRecordReader fromStream(InputStream stream, SmfRecordReader.RecordFormat format) {
        if (format == SmfRecordReader.RecordFormat.AUTODETECT) {
            throw new IllegalArgumentException("RecordFormat.AUTODETECT is not supported by VRecordReader - only SmfRecordReader for SMF data");
        }
        return new StreamRecordReader(stream, format);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract VRecord read() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    @Override
    public synchronized Iterator<VRecord> iterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theIterator = new VRecordReaderIterator<VRecord>(this);
        return this.theIterator;
    }

    @Override
    public synchronized Spliterator<VRecord> spliterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theSpliterator = new VRecordReaderSpliterator<VRecord>(this);
        return this.theSpliterator;
    }

    @Override
    synchronized int refill(Queue<VRecord> queue, int max) throws IOException {
        VRecord record;
        int count;
        for (count = 0; count < max && (record = this.read()) != null; ++count) {
            queue.add(record);
        }
        return count;
    }

    public synchronized Stream<VRecord> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

