/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics;

import com.blackhillsoftware.smf.cics.Smf110Record;

public class CicsInstanceId {
    private String prn;
    private int rvn;
    private transient int hashCode;

    public CicsInstanceId(Smf110Record record) {
        switch (record.smfsty()) {
            case 0: {
                this.prn = record.jcProductSection().smfpsprn();
                this.rvn = record.jcProductSection().smfpsrvn();
                break;
            }
            case 1: {
                this.prn = record.mnProductSection().smfmnprn();
                this.rvn = record.mnProductSection().smfmnrvn();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.prn = record.stProductSection().smfstprn();
                this.rvn = record.stProductSection().smfstrvn();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized subtype");
            }
        }
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prn == null ? 0 : this.prn.hashCode());
        result = 31 * result + this.rvn;
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CicsInstanceId other = (CicsInstanceId)obj;
        if (this.prn == null ? other.prn != null : !this.prn.equals(other.prn)) {
            return false;
        }
        return this.rvn == other.rvn;
    }

    public String toString() {
        return String.format("RVN %04X GAPPLID %s", this.rvn, this.prn);
    }

    public int getRvn() {
        return this.rvn;
    }
}

