/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring.fields;

import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.fields.ByteStringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.CountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.MultiCountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.PackedField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TimestampField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TrannumField;
import java.util.Objects;

public abstract class MonitoringField {
    private String owner;
    private String identifier;
    private String name;
    private transient int hashcode = 0;

    MonitoringField(String owner, String identifier) {
        this.owner = owner;
        this.identifier = identifier;
        this.name = owner + ":" + identifier;
    }

    MonitoringField(String owner, String identifier, String name) {
        this.owner = owner;
        this.identifier = identifier;
        this.name = name;
    }

    public static MonitoringField from(DictionaryEntry entry) {
        switch (entry.cmodtype()) {
            case "A": {
                if (entry.cmodleng() > 8) {
                    return MultiCountField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
                }
                return CountField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
            }
            case "C": {
                return ByteStringField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
            }
            case "P": {
                if (entry.cmodname().equals("DFHTASK") && entry.entryId().equals("P031")) {
                    return TrannumField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
                }
                if (entry.cmodname().equals("DFHCICS")) {
                    switch (entry.entryId()) {
                        case "P362": 
                        case "P376": 
                        case "P481": {
                            return TrannumField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
                        }
                    }
                }
                return PackedField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
            }
            case "S": {
                return ClockField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
            }
            case "T": {
                return TimestampField.define(entry.cmodname(), entry.entryId(), entry.cmodhead());
            }
        }
        return null;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.owner == null ? 17 : this.owner.hashCode();
            this.hashcode = this.identifier == null ? this.hashcode : 31 * this.hashcode + this.identifier.hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonitoringField other = (MonitoringField)obj;
        return Objects.equals(this.owner, other.owner) && Objects.equals(this.identifier, other.identifier);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }
}

