/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class DbctlUnsolicitedStatistics
extends StatisticsDataSection {
    public static final int DBUIDE = 28;
    public static final int DBUVERS = 1;

    private DbctlUnsolicitedStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int dbulen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dbuid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int dbudvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long statseno() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public String statdbid() {
        return Util.ConvertEbcdic(this.data, 12, 4);
    }

    public String starsen() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public ZonedDateTime stactime() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger stactimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public ZonedDateTime stadtime() {
        return Util.Binary8xStckTime(this.data, 32);
    }

    public BigInteger stadtimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public int stamithd() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int stamathd() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public long stanomithd() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long stanomathd() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long staelmax() {
        return Util.ConvertUnsignedBinary8(this.data, 52);
    }

    public BigInteger staelmaxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public long stahiwat() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long stapsbsu() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public LocalDateTime stalctim() {
        return Util.Binary8xStckLocalTime(this.data, 68);
    }

    public BigInteger stalctimRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 68);
    }

    public LocalDateTime staldtim() {
        return Util.Binary8xStckLocalTime(this.data, 76);
    }

    public BigInteger staldtimRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public static DbctlUnsolicitedStatistics create(byte[] Data2, int offset, int length) {
        return new DbctlUnsolicitedStatistics(Data2, offset, length);
    }

    static enum Field {
        dbulen(0, 2),
        dbuid(2, 2),
        dbudvers(4, 1),
        statseno(8, 4),
        statdbid(12, 4),
        starsen(16, 8),
        stactime(24, 8),
        stadtime(32, 8),
        stamithd(40, 2),
        stamathd(42, 2),
        stanomithd(44, 4),
        stanomathd(48, 4),
        staelmax(52, 8),
        stahiwat(60, 4),
        stapsbsu(64, 4),
        stalctim(68, 8),
        staldtim(76, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

