/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public class DispatcherTcbPoolStatistics
extends SmfData {
    public static final int DSGPLEN = 160;

    protected DispatcherTcbPoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int dsgtcbpn() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public long dsgmxtcb() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long dsgcnuat() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long dsgpnuat() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long dsgcnuus() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long dsgpnuus() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long dsgntcbl() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration dsgtotwl() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double dsgtotwlSeconds() {
        return Util.ToSeconds(this.dsgtotwl());
    }

    public long dsgtotwlRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public Duration dsgcurwt() {
        return Util.Binary8StckInterval(this.data, 48);
    }

    public double dsgcurwtSeconds() {
        return Util.ToSeconds(this.dsgcurwt());
    }

    public long dsgcurwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    @Deprecated
    public Duration dsgtotmt() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    @Deprecated
    public double dsgtotmtSeconds() {
        return Util.ToSeconds(this.dsgtotmt());
    }

    @Deprecated
    public long dsgtotmtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public long dsgtotnw() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    @Deprecated
    public long dsgtotmw() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long dsgcurnw() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long dsgpeanw() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long dsgmmwts() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public Duration dsgmmwtm() {
        return Util.Binary8StckInterval(this.data, 96);
    }

    public double dsgmmwtmSeconds() {
        return Util.ToSeconds(this.dsgmmwtm());
    }

    public long dsgmmwtmRawValue() {
        return Util.ConvertSignedBinary8(this.data, 96);
    }

    public long dsgcmmws() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long dsgpmmws() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public Duration dsgcmmwt() {
        return Util.Binary8StckInterval(this.data, 120);
    }

    public double dsgcmmwtSeconds() {
        return Util.ToSeconds(this.dsgcmmwt());
    }

    public long dsgcmmwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 120);
    }

    public ZonedDateTime dsggtcbl() {
        return Util.Binary8xStckTime(this.data, 128);
    }

    public BigInteger dsggtcblRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public LocalDateTime dsgltcbl() {
        return Util.Binary8xStckLocalTime(this.data, 136);
    }

    public BigInteger dsgltcblRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public static DispatcherTcbPoolStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherTcbPoolStatistics(Data2, offset, length);
    }

    static enum Field {
        dsgtcbpn(0, 2),
        dsgmxtcb(4, 4),
        dsgcnuat(8, 4),
        dsgpnuat(12, 4),
        dsgcnuus(16, 4),
        dsgpnuus(20, 4),
        dsgntcbl(32, 4),
        dsgtotwl(40, 8),
        dsgcurwt(48, 8),
        dsgtotnw(64, 4),
        dsgcurnw(72, 4),
        dsgpeanw(76, 4),
        dsgmmwts(92, 4),
        dsgmmwtm(96, 8),
        dsgcmmws(112, 4),
        dsgpmmws(116, 4),
        dsgcmmwt(120, 8),
        dsggtcbl(128, 8),
        dsgltcbl(136, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

