/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class EnqueuePoolStatistics
extends SmfData {
    public static final int NQGBLEN = 104;

    private EnqueuePoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String nqgpool() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long nqgtnqsi() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long nqgtnqsw() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public Duration nqgtnqwt() {
        return Util.Binary8StckInterval(this.data, 16);
    }

    public double nqgtnqwtSeconds() {
        return Util.ToSeconds(this.nqgtnqwt());
    }

    public long nqgtnqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 16);
    }

    public long nqgcnqsw() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public Duration nqgcnqwt() {
        return Util.Binary8StckInterval(this.data, 28);
    }

    public double nqgcnqwtSeconds() {
        return Util.ToSeconds(this.nqgcnqwt());
    }

    public long nqgcnqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 28);
    }

    public long nqggnqsw() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration nqggnqwt() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double nqggnqwtSeconds() {
        return Util.ToSeconds(this.nqggnqwt());
    }

    public long nqggnqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public long nqgsnqsw() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public Duration nqgsnqwt() {
        return Util.Binary8StckInterval(this.data, 52);
    }

    public double nqgsnqwtSeconds() {
        return Util.ToSeconds(this.nqgsnqwt());
    }

    public long nqgsnqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 52);
    }

    public long nqgtnqsr() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public Duration nqgtnqrt() {
        return Util.Binary8StckInterval(this.data, 64);
    }

    public double nqgtnqrtSeconds() {
        return Util.ToSeconds(this.nqgtnqrt());
    }

    public long nqgtnqrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 64);
    }

    public long nqgcnqsr() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public Duration nqgcnqrt() {
        return Util.Binary8StckInterval(this.data, 76);
    }

    public double nqgcnqrtSeconds() {
        return Util.ToSeconds(this.nqgcnqrt());
    }

    public long nqgcnqrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 76);
    }

    public long nqgtirjb() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long nqgtirjr() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long nqgtwrjr() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long nqgtwpop() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long nqgtwpto() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public static EnqueuePoolStatistics create(byte[] Data2, int offset, int length) {
        return new EnqueuePoolStatistics(Data2, offset, length);
    }

    static enum Field {
        nqgpool(0, 8),
        nqgtnqsi(8, 4),
        nqgtnqsw(12, 4),
        nqgtnqwt(16, 8),
        nqgcnqsw(24, 4),
        nqgcnqwt(28, 8),
        nqggnqsw(36, 4),
        nqggnqwt(40, 8),
        nqgsnqsw(48, 4),
        nqgsnqwt(52, 8),
        nqgtnqsr(60, 4),
        nqgtnqrt(64, 8),
        nqgcnqsr(72, 4),
        nqgcnqrt(76, 8),
        nqgtirjb(84, 4),
        nqgtirjr(88, 4),
        nqgtwrjr(92, 4),
        nqgtwpop(96, 4),
        nqgtwpto(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

