/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.A17Dsrls;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class FileControlStatistics
extends StatisticsDataSection {
    public static final int A17IDR = 67;
    public static final int A17VERS = 1;
    public static final String A17DTRMT = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(217).array(), 3, 1);
    public static final String A17DTASS = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(226).array(), 3, 1);
    public static final String A17DTPRS = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(227).array(), 3, 1);
    public static final String A17DTCFL = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(211).array(), 3, 1);
    public static final String A17DTCFC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(210).array(), 3, 1);
    public static final String A17DTAIX = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(231).array(), 3, 1);
    public static final String A17DTTC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(195).array(), 3, 1);
    public static final String A17DTTS = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(226).array(), 3, 1);
    public static final String A17DTTP = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(215).array(), 3, 1);
    public static final String A17DTTU = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(228).array(), 3, 1);
    public static final String A17DTTL = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(211).array(), 3, 1);
    public static final String A17DTTK = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(210).array(), 3, 1);
    public static final int A17CLEN = 376;

    private FileControlStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a17len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a17id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a17dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a17fnam() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String a17floc() {
        return Util.ConvertEbcdic(this.data, 16, 1);
    }

    public String a17dt() {
        return Util.ConvertEbcdic(this.data, 17, 1);
    }

    public A17Dsrls a17dsrls() {
        int value = Util.ConvertUnsignedBinary1(this.data, 18);
        return A17Dsrls.from(value);
    }

    public int a17dsrlsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public String a17dsnam() {
        return Util.ConvertEbcdic(this.data, 32, 44);
    }

    public long a17dsrd() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long a17dsgu() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long a17dsbr() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long a17dswra() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long a17dswru() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long a17dsdel() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long a17dsxcp() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long a17dsixp() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long a17dstsw() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public int a17dshsw() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public String a17dttyp() {
        return Util.ConvertEbcdic(this.data, 120, 1);
    }

    public long a17dtrds() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long a17dtrnf() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long a17dtavr() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long a17dtads() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long a17dtarj() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long a17dtatf() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public long a17dtrws() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long a17dtdls() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long a17dtshi() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long a17dtsiz() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long a17dtalt() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long a17dtust() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long a17dtale() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long a17dtuse() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long a17dtali() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long a17dtusi() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long a17dtald() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long a17dtusd() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long a17dtrrs() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public int a17dsdnb() {
        return Util.ConvertUnsignedBinary2(this.data, 200);
    }

    public int a17dsinb() {
        return Util.ConvertUnsignedBinary2(this.data, 202);
    }

    public int a17pool() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public int a17strno() {
        return Util.ConvertUnsignedBinary2(this.data, 206);
    }

    public String a17rname() {
        return Util.ConvertEbcdic(this.data, 208, 8);
    }

    public String a17rsys() {
        return Util.ConvertEbcdic(this.data, 216, 4);
    }

    public String a17dstyp() {
        return Util.ConvertEbcdic(this.data, 220, 1);
    }

    public String a17bdsnm() {
        return Util.ConvertEbcdic(this.data, 224, 44);
    }

    public int a17dsasc() {
        return Util.ConvertUnsignedBinary2(this.data, 268);
    }

    public int a17dsasw() {
        return Util.ConvertUnsignedBinary2(this.data, 270);
    }

    public LocalDateTime a17lopnt() {
        return Util.Binary8xStckLocalTime(this.data, 272);
    }

    public BigInteger a17lopntRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 272);
    }

    public LocalDateTime a17lclst() {
        return Util.Binary8xStckLocalTime(this.data, 280);
    }

    public BigInteger a17lclstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 280);
    }

    public ZonedDateTime a17gopnt() {
        return Util.Binary8xStckTime(this.data, 288);
    }

    public BigInteger a17gopntRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public ZonedDateTime a17gclst() {
        return Util.Binary8xStckTime(this.data, 296);
    }

    public BigInteger a17gclstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public long a17dsbru() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public long a17rlswt() {
        return Util.ConvertUnsignedBinary4(this.data, 308);
    }

    public long a17dtcon() {
        return Util.ConvertUnsignedBinary4(this.data, 312);
    }

    public String a17dtcfp() {
        return Util.ConvertEbcdic(this.data, 316, 8);
    }

    public long a17dtlds() {
        return Util.ConvertUnsignedBinary4(this.data, 324);
    }

    public long a17fcxcc() {
        return Util.ConvertUnsignedBinary4(this.data, 328);
    }

    public String a17FileDefineSource() {
        return Util.ConvertEbcdic(this.data, 332, 8);
    }

    public LocalDateTime a17FileChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 340);
    }

    public BigInteger a17FileChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 340);
    }

    public String a17FileChangeUserid() {
        return Util.ConvertEbcdic(this.data, 348, 8);
    }

    public CIAgent a17FileChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 356);
        return CIAgent.from(value);
    }

    public int a17FileChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 356);
    }

    public CIAgent a17FileInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 358);
        return CIAgent.from(value);
    }

    public int a17FileInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 358);
    }

    public LocalDateTime a17FileInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 360);
    }

    public BigInteger a17FileInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public String a17FileInstallUserid() {
        return Util.ConvertEbcdic(this.data, 368, 8);
    }

    public static FileControlStatistics create(byte[] Data2, int offset, int length) {
        return new FileControlStatistics(Data2, offset, length);
    }

    static enum Field {
        a17len(0, 2),
        a17id(2, 2),
        a17dvers(4, 1),
        a17fnam(8, 8),
        a17floc(16, 1),
        a17dt(17, 1),
        a17dsrls(18, 1),
        a17dsnam(32, 44),
        a17dsrd(76, 4),
        a17dsgu(80, 4),
        a17dsbr(84, 4),
        a17dswra(88, 4),
        a17dswru(92, 4),
        a17dsdel(96, 4),
        a17dsxcp(104, 4),
        a17dsixp(108, 4),
        a17dstsw(112, 4),
        a17dshsw(116, 2),
        a17dttyp(120, 1),
        a17dtrds(124, 4),
        a17dtrnf(128, 4),
        a17dtavr(132, 4),
        a17dtads(136, 4),
        a17dtarj(140, 4),
        a17dtatf(144, 4),
        a17dtrws(148, 4),
        a17dtdls(152, 4),
        a17dtshi(156, 4),
        a17dtsiz(160, 4),
        a17dtalt(164, 4),
        a17dtust(168, 4),
        a17dtale(172, 4),
        a17dtuse(176, 4),
        a17dtali(180, 4),
        a17dtusi(184, 4),
        a17dtald(188, 4),
        a17dtusd(192, 4),
        a17dtrrs(196, 4),
        a17dsdnb(200, 2),
        a17dsinb(202, 2),
        a17pool(204, 1),
        a17strno(206, 2),
        a17rname(208, 8),
        a17rsys(216, 4),
        a17dstyp(220, 1),
        a17bdsnm(224, 44),
        a17dsasc(268, 2),
        a17dsasw(270, 2),
        a17lopnt(272, 8),
        a17lclst(280, 8),
        a17gopnt(288, 8),
        a17gclst(296, 8),
        a17dsbru(304, 4),
        a17rlswt(308, 4),
        a17dtcon(312, 4),
        a17dtcfp(316, 8),
        a17dtlds(324, 4),
        a17fcxcc(328, 4),
        a17FileDefineSource(332, 8),
        a17FileChangeTime(340, 8),
        a17FileChangeUserid(348, 8),
        a17FileChangeAgent(356, 2),
        a17FileInstallAgent(358, 2),
        a17FileInstallTime(360, 8),
        a17FileInstallUserid(368, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

