/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.A14Accm;
import com.blackhillsoftware.smf.cics.statistics.values.A14Eflgs;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class IscIrcSystemStatistics
extends StatisticsDataSection {
    public static final int A14IDR = 52;
    public static final int A14IDT = 53;
    public static final int A14VERS = 1;
    public static final int A14CLEN = 268;

    private IscIrcSystemStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a14len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a14id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a14dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a14cntn() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public int a14esall() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int a14ebid() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int a14estam() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public int a14e2hwm() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int a14ebhwm() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long a14es1() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long a14es2() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long a14esbid() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a14estas() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a14estaq() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a14estaf() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long a14estao() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long a14estfc() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long a14estic() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long a14esttd() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long a14estts() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long a14estdl() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long a14esttc() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public int a14e1hwm() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int a14eqpct() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public long a14ealrj() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public Duration a14emxqt() {
        int seconds = Util.ConvertSignedBinary2(this.data, 84);
        if (seconds >= 0) {
            return Duration.ofSeconds(seconds);
        }
        return null;
    }

    public double a14emxqtSeconds() {
        return this.a14emxqtRawValue();
    }

    public int a14emxqtRawValue() {
        return Util.ConvertSignedBinary2(this.data, 84);
    }

    public int a14ealim() {
        return Util.ConvertSignedBinary2(this.data, 86);
    }

    public long a14ezqrj() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public int a14ezqpu() {
        return Util.ConvertUnsignedBinary2(this.data, 92);
    }

    public int a14ezqpc() {
        return Util.ConvertUnsignedBinary2(this.data, 94);
    }

    public int a14emqpc() {
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int a14eall() {
        return Util.ConvertSignedBinary4(this.data, 100);
    }

    public ZonedDateTime a14gact() {
        return Util.Binary8xStckTime(this.data, 104);
    }

    public BigInteger a14gactRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public LocalDateTime a14aict() {
        return Util.Binary8xStckLocalTime(this.data, 112);
    }

    public BigInteger a14aictRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public ZonedDateTime a14gadt() {
        return Util.Binary8xStckTime(this.data, 120);
    }

    public BigInteger a14gadtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public LocalDateTime a14aidt() {
        return Util.Binary8xStckLocalTime(this.data, 128);
    }

    public BigInteger a14aidtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long a14eahwm() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public String a14esid() {
        return Util.ConvertEbcdic(this.data, 140, 8);
    }

    public A14Accm a14accm() {
        int value = Util.ConvertUnsignedBinary1(this.data, 148);
        return A14Accm.from(value);
    }

    public int a14accmRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    public A14Eflgs a14eflgs() {
        int value = Util.ConvertUnsignedBinary1(this.data, 149);
        return A14Eflgs.from(value);
    }

    public int a14eflgsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 149);
    }

    public int a14esecn() {
        return Util.ConvertUnsignedBinary2(this.data, 150);
    }

    public int a14eprmn() {
        return Util.ConvertUnsignedBinary2(this.data, 152);
    }

    public int a14e1ry() {
        return Util.ConvertUnsignedBinary2(this.data, 154);
    }

    public int a14e2ry() {
        return Util.ConvertUnsignedBinary2(this.data, 156);
    }

    public long a14estpc() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long a14estpcChannel() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long a14estpcChannelSent() {
        return Util.ConvertUnsignedBinary8(this.data, 168);
    }

    public BigInteger a14estpcChannelSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public long a14estpcChannelRcvd() {
        return Util.ConvertUnsignedBinary8(this.data, 176);
    }

    public BigInteger a14estpcChannelRcvdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public long a14esttcChannel() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long a14esttcChannelSent() {
        return Util.ConvertUnsignedBinary8(this.data, 188);
    }

    public BigInteger a14esttcChannelSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 188);
    }

    public long a14esttcChannelRcvd() {
        return Util.ConvertUnsignedBinary8(this.data, 196);
    }

    public BigInteger a14esttcChannelRcvdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public long a14esticChannel() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long a14esticChannelSent() {
        return Util.ConvertUnsignedBinary8(this.data, 208);
    }

    public BigInteger a14esticChannelSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 208);
    }

    public long a14esticChannelRcvd() {
        return Util.ConvertUnsignedBinary8(this.data, 216);
    }

    public BigInteger a14esticChannelRcvdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public String a14DefineSource() {
        return Util.ConvertEbcdic(this.data, 224, 8);
    }

    public LocalDateTime a14ChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 232);
    }

    public BigInteger a14ChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 232);
    }

    public String a14ChangeUserid() {
        return Util.ConvertEbcdic(this.data, 240, 8);
    }

    public CIAgent a14ChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 248);
        return CIAgent.from(value);
    }

    public int a14ChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 248);
    }

    public CIAgent a14InstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 250);
        return CIAgent.from(value);
    }

    public int a14InstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 250);
    }

    public LocalDateTime a14InstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 252);
    }

    public BigInteger a14InstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 252);
    }

    public String a14InstallUserid() {
        return Util.ConvertEbcdic(this.data, 260, 8);
    }

    public static IscIrcSystemStatistics create(byte[] Data2, int offset, int length) {
        return new IscIrcSystemStatistics(Data2, offset, length);
    }

    static enum Field {
        a14len(0, 2),
        a14id(2, 2),
        a14dvers(4, 1),
        a14cntn(8, 4),
        a14esall(14, 2),
        a14ebid(16, 2),
        a14estam(18, 2),
        a14e2hwm(20, 2),
        a14ebhwm(22, 2),
        a14es1(24, 4),
        a14es2(28, 4),
        a14esbid(32, 4),
        a14estas(36, 4),
        a14estaq(40, 4),
        a14estaf(44, 4),
        a14estao(48, 4),
        a14estfc(52, 4),
        a14estic(56, 4),
        a14esttd(60, 4),
        a14estts(64, 4),
        a14estdl(68, 4),
        a14esttc(72, 4),
        a14e1hwm(76, 2),
        a14eqpct(78, 2),
        a14ealrj(80, 4),
        a14emxqt(84, 2),
        a14ealim(86, 2),
        a14ezqrj(88, 4),
        a14ezqpu(92, 2),
        a14ezqpc(94, 2),
        a14emqpc(96, 2),
        a14eall(100, 4),
        a14gact(104, 8),
        a14aict(112, 8),
        a14gadt(120, 8),
        a14aidt(128, 8),
        a14eahwm(136, 4),
        a14esid(140, 8),
        a14accm(148, 1),
        a14eflgs(149, 1),
        a14esecn(150, 2),
        a14eprmn(152, 2),
        a14e1ry(154, 2),
        a14e2ry(156, 2),
        a14estpc(160, 4),
        a14estpcChannel(164, 4),
        a14estpcChannelSent(168, 8),
        a14estpcChannelRcvd(176, 8),
        a14esttcChannel(184, 4),
        a14esttcChannelSent(188, 8),
        a14esttcChannelRcvd(196, 8),
        a14esticChannel(204, 4),
        a14esticChannelSent(208, 8),
        a14esticChannelRcvd(216, 8),
        a14DefineSource(224, 8),
        a14ChangeTime(232, 8),
        a14ChangeUserid(240, 8),
        a14ChangeAgent(248, 2),
        a14InstallAgent(250, 2),
        a14InstallTime(252, 8),
        a14InstallUserid(260, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

