/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.LgdDsaType;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class LoaderGlobalDsaStatistics
extends SmfData {
    public static final int LDGDSALEN = 48;
    public static final int LDGMAXDSA = 6;

    private LoaderGlobalDsaStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long ldgstgniu() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long ldgprogniu() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long ldgrecniu() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long ldgdpscr() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public Duration ldgdpsct() {
        return Util.Binary8StckInterval(this.data, 16);
    }

    public double ldgdpsctSeconds() {
        return Util.ToSeconds(this.ldgdpsct());
    }

    public long ldgdpsctRawValue() {
        return Util.ConvertSignedBinary8(this.data, 16);
    }

    public LgdDsaType lgdDsaType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 24);
        return LgdDsaType.from(value);
    }

    public int lgdDsaTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public static LoaderGlobalDsaStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderGlobalDsaStatistics(Data2, offset, length);
    }

    static enum Field {
        ldgstgniu(0, 4),
        ldgprogniu(4, 4),
        ldgrecniu(8, 4),
        ldgdpscr(12, 4),
        ldgdpsct(16, 8),
        lgdDsaType(24, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

