/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LoaderPublicLibraryStatistics
extends StatisticsDataSection {
    public static final int LDBDS_LENGTH = 104;
    public static final int LDBIDR = 31;
    public static final int LDB_VERS = 1;
    public static final int LDB_CRITICAL_NO = 1;
    public static final int LDB_CRITICAL_YES = 2;
    public static final int LDB_LIBRARY_ENABLED = 1;
    public static final int LDB_LIBRARY_DISABLED = 2;

    private LoaderPublicLibraryStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ldbdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ldbdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ldbdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ldbLibraryName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long ldbLibrarySearchPos() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long ldbLibraryRanking() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public int ldbLibraryCritical() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public int ldbLibraryEnableStatus() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public long ldbLibraryProgLoads() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public String ldbLibraryDefineSource() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public LocalDateTime ldbLibraryChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 56);
    }

    public BigInteger ldbLibraryChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public String ldbLibraryChangeUserid() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public CIAgent ldbLibraryChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 72);
        return CIAgent.from(value);
    }

    public int ldbLibraryChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public CIAgent ldbLibraryInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 74);
        return CIAgent.from(value);
    }

    public int ldbLibraryInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public LocalDateTime ldbLibraryInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 76);
    }

    public BigInteger ldbLibraryInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public String ldbLibraryInstallUserid() {
        return Util.ConvertEbcdic(this.data, 84, 8);
    }

    public int ldbLibraryNumdsnames() {
        return Util.ConvertSignedBinary4(this.data, 100);
    }

    public List<String> datasetNames() {
        int datastart = 104;
        int count = this.ldbLibraryNumdsnames();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(Util.ConvertEbcdic(this.data, datastart + i * 44, 44));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean ldbCriticalYes() {
        return Util.ConvertEquateValue(this.data, this.ldbLibraryCritical(), 2);
    }

    public boolean ldbLibraryEnabled() {
        return Util.ConvertEquateValue(this.data, this.ldbLibraryEnableStatus(), 1);
    }

    public List<String> ldbDsnames() {
        int datastart = 104;
        int count = this.ldbLibraryNumdsnames();
        int length = 44;
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(Util.ConvertEbcdic(this.data, datastart + i * length, length));
        }
        return Collections.unmodifiableList(result);
    }

    public static LoaderPublicLibraryStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderPublicLibraryStatistics(Data2, offset, length);
    }

    static enum Field {
        ldbdsLen(0, 2),
        ldbdsId(2, 2),
        ldbdsVers(4, 1),
        ldbLibraryName(8, 8),
        ldbLibrarySearchPos(16, 4),
        ldbLibraryRanking(20, 4),
        ldbLibraryCritical(24, 1),
        ldbLibraryEnableStatus(25, 1),
        ldbLibraryProgLoads(28, 4),
        ldbLibraryDefineSource(48, 8),
        ldbLibraryChangeTime(56, 8),
        ldbLibraryChangeUserid(64, 8),
        ldbLibraryChangeAgent(72, 2),
        ldbLibraryInstallAgent(74, 2),
        ldbLibraryInstallTime(76, 8),
        ldbLibraryInstallUserid(84, 8),
        ldbLibraryNumdsnames(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

