/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class LogManagerLogstreamStatistics
extends StatisticsDataSection {
    public static final int LGSDSLEN = 124;
    public static final int LGSIDR = 94;
    public static final int LGSVERS = 1;
    public static final int LGSSLYES = 1;
    public static final int LGSSLNO = 2;
    public static final int LGSDOYES = 1;
    public static final int LGSDONO = 2;
    public static final int LGSADYES = 1;
    public static final int LGSADNO = 2;

    private LogManagerLogstreamStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int lgslen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int lgsid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int lgsdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String lgsstrnam() {
        return Util.ConvertEbcdic(this.data, 8, 26);
    }

    public long lgswrites() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long lgsbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger lgsbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long lgscufwtrs() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long lgspkfwtrs() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long lgstfcwait() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long lgsbufwait() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long lgsbrwstrt() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long lgsbrwread() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long lgsdeletes() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long lgsrtyerrs() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long lgsbufapp() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public int lgssyslg() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public int lgsdonly() {
        return Util.ConvertUnsignedBinary1(this.data, 85);
    }

    public String lgsstruc() {
        return Util.ConvertEbcdic(this.data, 88, 16);
    }

    public long lgsmaxbl() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long lgsretpd() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public int lgsautod() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public long lgsqueries() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public boolean lgsslyes() {
        return Util.ConvertEquateValue(this.data, this.lgssyslg(), 1);
    }

    public boolean lgsdoyes() {
        return Util.ConvertEquateValue(this.data, this.lgsdonly(), 1);
    }

    public boolean lgsadyes() {
        return Util.ConvertEquateValue(this.data, this.lgsautod(), 1);
    }

    public static LogManagerLogstreamStatistics create(byte[] Data2, int offset, int length) {
        return new LogManagerLogstreamStatistics(Data2, offset, length);
    }

    static enum Field {
        lgslen(0, 2),
        lgsid(2, 2),
        lgsdvers(4, 1),
        lgsstrnam(8, 26),
        lgswrites(36, 4),
        lgsbytes(40, 8),
        lgscufwtrs(48, 4),
        lgspkfwtrs(52, 4),
        lgstfcwait(56, 4),
        lgsbufwait(60, 4),
        lgsbrwstrt(64, 4),
        lgsbrwread(68, 4),
        lgsdeletes(72, 4),
        lgsrtyerrs(76, 4),
        lgsbufapp(80, 4),
        lgssyslg(84, 1),
        lgsdonly(85, 1),
        lgsstruc(88, 16),
        lgsmaxbl(104, 4),
        lgsretpd(108, 4),
        lgsautod(112, 1),
        lgsqueries(116, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

