/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.MqrMonstatus;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class MqMonitorStatistics
extends StatisticsDataSection {
    public static final int MQRidr = 148;
    public static final int MQRvers = 1;

    private MqMonitorStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mqrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mqrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mqrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String mqrName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String mqrQname() {
        return Util.ConvertEbcdic(this.data, 16, 48);
    }

    public String mqrTranid() {
        return Util.ConvertEbcdic(this.data, 64, 4);
    }

    public int mqrTasknum() {
        return Util.ConvertPacked4(this.data, 68);
    }

    public String mqrMonuserid() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public String mqrUserid() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public MqrMonstatus mqrMonstatus() {
        int value = Util.ConvertUnsignedBinary1(this.data, 88);
        return MqrMonstatus.from(value);
    }

    public int mqrMonstatusRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 88);
    }

    public long mqrTopen() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long mqrTclose() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long mqrTget() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long mqrTgetwait() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long mqrTput() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long mqrTput1() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long mqrTinq() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long mqrTinql() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long mqrTset() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long mqrTCommUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    @Deprecated
    public long mqrTcommuow() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long mqrTBackUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    @Deprecated
    public long mqrTbackuow() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long mqrTOther() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    @Deprecated
    public long mqrTother() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public ZonedDateTime mqrStartTimeGmt() {
        return Util.Binary8xStckTime(this.data, 156);
    }

    public BigInteger mqrStartTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 156);
    }

    public LocalDateTime mqrStartTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 164);
    }

    public BigInteger mqrStartTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public ZonedDateTime mqrStopTimeGmt() {
        return Util.Binary8xStckTime(this.data, 172);
    }

    public BigInteger mqrStopTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 172);
    }

    public LocalDateTime mqrStopTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 180);
    }

    public BigInteger mqrStopTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 180);
    }

    public String mqrMqmonDefineSource() {
        return Util.ConvertEbcdic(this.data, 188, 8);
    }

    public LocalDateTime mqrMqmonChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 196);
    }

    public BigInteger mqrMqmonChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public String mqrMqmonChangeUserid() {
        return Util.ConvertEbcdic(this.data, 204, 8);
    }

    public CIAgent mqrMqmonChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 212);
        return CIAgent.from(value);
    }

    public int mqrMqmonChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 212);
    }

    public CIAgent mqrMqmonInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 214);
        return CIAgent.from(value);
    }

    public int mqrMqmonInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 214);
    }

    public LocalDateTime mqrMqmonInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 216);
    }

    public BigInteger mqrMqmonInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public String mqrMqmonInstallUserid() {
        return Util.ConvertEbcdic(this.data, 224, 8);
    }

    public static MqMonitorStatistics create(byte[] Data2, int offset, int length) {
        return new MqMonitorStatistics(Data2, offset, length);
    }

    static enum Field {
        mqrlen(0, 2),
        mqrid(2, 2),
        mqrdvers(4, 1),
        mqrName(8, 8),
        mqrQname(16, 48),
        mqrTranid(64, 4),
        mqrTasknum(68, 4),
        mqrMonuserid(72, 8),
        mqrUserid(80, 8),
        mqrMonstatus(88, 1),
        mqrTopen(92, 4),
        mqrTclose(96, 4),
        mqrTget(100, 4),
        mqrTgetwait(104, 4),
        mqrTput(108, 4),
        mqrTput1(112, 4),
        mqrTinq(116, 4),
        mqrTinql(120, 4),
        mqrTset(124, 4),
        mqrTCommUOW(128, 4),
        mqrTBackUOW(132, 4),
        mqrTOther(136, 4),
        mqrStartTimeGmt(156, 8),
        mqrStartTimeLocal(164, 8),
        mqrStopTimeGmt(172, 8),
        mqrStopTimeLocal(180, 8),
        mqrMqmonDefineSource(188, 8),
        mqrMqmonChangeTime(196, 8),
        mqrMqmonChangeUserid(204, 8),
        mqrMqmonChangeAgent(212, 2),
        mqrMqmonInstallAgent(214, 2),
        mqrMqmonInstallTime(216, 8),
        mqrMqmonInstallUserid(224, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

