/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class NcListStructureStatistics
extends StatisticsDataSection {
    public static final int S4IDE = 124;
    public static final int S4VERS = 1;
    public static final int S4CLEN = 120;

    private NcListStructureStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s4len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int s4id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int s4dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String s4name() {
        return Util.ConvertEbcdic(this.data, 8, 16);
    }

    public String s4pref() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String s4pool() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String s4cnname() {
        return Util.ConvertEbcdic(this.data, 24, 16);
    }

    public String s4cnpref() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String s4cnsysn() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public long s4size() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long s4sizemx() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long s4entrct() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long s4entrhi() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long s4entrlo() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long s4entrmx() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long s4crect() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long s4getct() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long s4setct() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long s4delct() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long s4keqct() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long s4kgect() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long s4asyct() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long s4rsp1ct() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long s4rsp2ct() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long s4rsp3ct() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long s4rsp4ct() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long s4rsp5ct() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long s4rsp6ct() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long s4rsp7ct() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public static NcListStructureStatistics create(byte[] Data2, int offset, int length) {
        return new NcListStructureStatistics(Data2, offset, length);
    }

    static enum Field {
        s4len(0, 2),
        s4id(2, 2),
        s4dvers(4, 1),
        s4name(8, 16),
        s4pref(8, 8),
        s4pool(16, 8),
        s4cnname(24, 16),
        s4cnpref(24, 8),
        s4cnsysn(32, 8),
        s4size(40, 4),
        s4sizemx(44, 4),
        s4entrct(48, 4),
        s4entrhi(52, 4),
        s4entrlo(56, 4),
        s4entrmx(60, 4),
        s4crect(64, 4),
        s4getct(68, 4),
        s4setct(72, 4),
        s4delct(76, 4),
        s4keqct(80, 4),
        s4kgect(84, 4),
        s4asyct(88, 4),
        s4rsp1ct(92, 4),
        s4rsp2ct(96, 4),
        s4rsp3ct(100, 4),
        s4rsp4ct(104, 4),
        s4rsp5ct(108, 4),
        s4rsp6ct(112, 4),
        s4rsp7ct(116, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

