/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.DataLoc;
import com.blackhillsoftware.smf.cics.statistics.values.ExecKey;
import com.blackhillsoftware.smf.cics.statistics.values.PgdProgramApi;
import com.blackhillsoftware.smf.cics.statistics.values.PgdProgramConcurrency;
import com.blackhillsoftware.smf.cics.statistics.values.PgdProgramExecutionSet;
import com.blackhillsoftware.smf.cics.statistics.values.PgdProgramRuntimeEnv;
import com.blackhillsoftware.smf.cics.statistics.values.PgdProgramType;
import com.blackhillsoftware.smf.cics.statistics.values.ProgramLanguage;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class PublicProgramdefStatistics
extends StatisticsDataSection {
    public static final int PGDDS_LENGTH = 136;
    public static final int PGD_IDR = 120;
    public static final int PGD_VERS = 1;
    public static final int PGD_REMOTE_NO = 1;
    public static final int PGD_REMOTE_YES = 2;
    public static final int PGD_DYNAMIC_NO = 1;
    public static final int PGD_DYNAMIC_YES = 2;
    public static final int PGD_JVM_NO = 1;
    public static final int PGD_JVM_YES = 2;
    public static final int PGD_ENTRYPOINT_NO = 1;
    public static final int PGD_ENTRYPOINT_YES = 2;

    private PublicProgramdefStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int pgddsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int pgddsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int pgddsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String pgdProgramName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public PgdProgramType pgdProgramType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return PgdProgramType.from(value);
    }

    public int pgdProgramTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public ExecKey pgdProgramExecKey() {
        int value = Util.ConvertUnsignedBinary1(this.data, 17);
        return ExecKey.from(value);
    }

    public int pgdProgramExecKeyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public DataLoc pgdProgramDataLoc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 18);
        return DataLoc.from(value);
    }

    public int pgdProgramDataLocRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public PgdProgramExecutionSet pgdProgramExecutionSet() {
        int value = Util.ConvertUnsignedBinary1(this.data, 19);
        return PgdProgramExecutionSet.from(value);
    }

    public int pgdProgramExecutionSetRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public ProgramLanguage pgdProgramLangDeduced() {
        int value = Util.ConvertUnsignedBinary1(this.data, 24);
        return ProgramLanguage.deduced(value);
    }

    public int pgdProgramLangDeducedRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public ProgramLanguage pgdProgramLanguage() {
        int value = Util.ConvertUnsignedBinary1(this.data, 25);
        return ProgramLanguage.value(value);
    }

    public int pgdProgramLanguageRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public PgdProgramRuntimeEnv pgdProgramRuntimeEnv() {
        int value = Util.ConvertUnsignedBinary1(this.data, 26);
        return PgdProgramRuntimeEnv.from(value);
    }

    public int pgdProgramRuntimeEnvRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 26);
    }

    public PgdProgramConcurrency pgdProgramConcurrency() {
        int value = Util.ConvertUnsignedBinary1(this.data, 32);
        return PgdProgramConcurrency.from(value);
    }

    public int pgdProgramConcurrencyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public PgdProgramApi pgdProgramApi() {
        int value = Util.ConvertUnsignedBinary1(this.data, 33);
        return PgdProgramApi.from(value);
    }

    public int pgdProgramApiRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 33);
    }

    public int pgdProgramRemote() {
        return Util.ConvertUnsignedBinary1(this.data, 37);
    }

    public int pgdProgramDynamic() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public int pgdProgramJvm() {
        return Util.ConvertUnsignedBinary1(this.data, 39);
    }

    public int pgdProgramEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public String pgdProgramRemoteName() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String pgdProgramTranId() {
        return Util.ConvertEbcdic(this.data, 52, 4);
    }

    public String pgdProgramRemoteSysid() {
        return Util.ConvertEbcdic(this.data, 56, 4);
    }

    public String pgdProgramJvmserver() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public String pgdProgramDefineSource() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public LocalDateTime pgdProgramChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 96);
    }

    public BigInteger pgdProgramChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public String pgdProgramChangeUserid() {
        return Util.ConvertEbcdic(this.data, 104, 8);
    }

    public CIAgent pgdProgramChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 112);
        return CIAgent.from(value);
    }

    public int pgdProgramChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public CIAgent pgdProgramInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 114);
        return CIAgent.from(value);
    }

    public int pgdProgramInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public LocalDateTime pgdProgramInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 116);
    }

    public BigInteger pgdProgramInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 116);
    }

    public String pgdProgramInstallUserid() {
        return Util.ConvertEbcdic(this.data, 124, 8);
    }

    public boolean pgdRemoteYes() {
        return Util.ConvertEquateValue(this.data, this.pgdProgramRemote(), 2);
    }

    public boolean pgdDynamicYes() {
        return Util.ConvertEquateValue(this.data, this.pgdProgramDynamic(), 2);
    }

    public boolean pgdJvmYes() {
        return Util.ConvertEquateValue(this.data, this.pgdProgramJvm(), 2);
    }

    public boolean pgdEntrypointYes() {
        return Util.ConvertEquateValue(this.data, this.pgdProgramEntrypoint(), 2);
    }

    public static PublicProgramdefStatistics create(byte[] Data2, int offset, int length) {
        return new PublicProgramdefStatistics(Data2, offset, length);
    }

    static enum Field {
        pgddsLen(0, 2),
        pgddsId(2, 2),
        pgddsVers(4, 1),
        pgdProgramName(8, 8),
        pgdProgramType(16, 1),
        pgdProgramExecKey(17, 1),
        pgdProgramDataLoc(18, 1),
        pgdProgramExecutionSet(19, 1),
        pgdProgramLangDeduced(24, 1),
        pgdProgramLanguage(25, 1),
        pgdProgramRuntimeEnv(26, 1),
        pgdProgramConcurrency(32, 1),
        pgdProgramApi(33, 1),
        pgdProgramRemote(37, 1),
        pgdProgramDynamic(38, 1),
        pgdProgramJvm(39, 1),
        pgdProgramEntrypoint(40, 1),
        pgdProgramRemoteName(44, 8),
        pgdProgramTranId(52, 4),
        pgdProgramRemoteSysid(56, 4),
        pgdProgramJvmserver(72, 8),
        pgdProgramDefineSource(88, 8),
        pgdProgramChangeTime(96, 8),
        pgdProgramChangeUserid(104, 8),
        pgdProgramChangeAgent(112, 2),
        pgdProgramInstallAgent(114, 2),
        pgdProgramInstallTime(116, 8),
        pgdProgramInstallUserid(124, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

