/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.IirRqmodelInterfaceType;
import com.blackhillsoftware.smf.cics.statistics.values.IirRqmodelType;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class RequestmodelStatistics
extends SmfData {
    public static final int IIRIDR = 111;
    public static final int IIR_VERS = 1;

    private RequestmodelStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int iirdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int iirdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int iirdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String iirRequestmodelName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String iirCorbaserverName() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public String iirTransactionId() {
        return Util.ConvertEbcdic(this.data, 20, 4);
    }

    public String iirRqmodelModule() {
        return Util.ConvertEbcdic(this.data, 28, 255);
    }

    public String iirRqmodelInterface() {
        return Util.ConvertEbcdic(this.data, 283, 255);
    }

    public String iirRqmodelOperation() {
        return Util.ConvertEbcdic(this.data, 538, 255);
    }

    public String iirRqmodelBeanName() {
        return Util.ConvertEbcdic(this.data, 796, 240);
    }

    public IirRqmodelType iirRqmodelType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 1052);
        return IirRqmodelType.from(value);
    }

    public int iirRqmodelTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 1052);
    }

    public IirRqmodelInterfaceType iirRqmodelInterfaceType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 1053);
        return IirRqmodelInterfaceType.from(value);
    }

    public int iirRqmodelInterfaceTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 1053);
    }

    public String iirDefineSource() {
        return Util.ConvertEbcdic(this.data, 1060, 8);
    }

    public LocalDateTime iirChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 1068);
    }

    public BigInteger iirChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1068);
    }

    public String iirChangeUserid() {
        return Util.ConvertEbcdic(this.data, 1076, 8);
    }

    public CIAgent iirChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1084);
        return CIAgent.from(value);
    }

    public int iirChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1084);
    }

    public CIAgent iirInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1086);
        return CIAgent.from(value);
    }

    public int iirInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1086);
    }

    public LocalDateTime iirInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 1088);
    }

    public BigInteger iirInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1088);
    }

    public String iirInstallUserid() {
        return Util.ConvertEbcdic(this.data, 1096, 8);
    }

    public static RequestmodelStatistics create(byte[] Data2, int offset, int length) {
        return new RequestmodelStatistics(Data2, offset, length);
    }

    static enum Field {
        iirdsLen(0, 2),
        iirdsId(2, 2),
        iirdsVers(4, 1),
        iirRequestmodelName(8, 8),
        iirCorbaserverName(16, 4),
        iirTransactionId(20, 4),
        iirRqmodelModule(28, 255),
        iirRqmodelInterface(283, 255),
        iirRqmodelOperation(538, 255),
        iirRqmodelBeanName(796, 240),
        iirRqmodelType(1052, 1),
        iirRqmodelInterfaceType(1053, 1),
        iirDefineSource(1060, 8),
        iirChangeTime(1068, 8),
        iirChangeUserid(1076, 8),
        iirChangeAgent(1084, 2),
        iirInstallAgent(1086, 2),
        iirInstallTime(1088, 8),
        iirInstallUserid(1096, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

