/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class ResLifeBundleStatistics
extends StatisticsDataSection {
    public static final int RLRDS_LENGTH = 612;
    public static final int RLRIDR = 100;
    public static final int RLR_VERS = 1;

    private ResLifeBundleStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int rlrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int rlrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int rlrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String rlrBundleName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String rlrBundleDirectory() {
        return Util.ConvertEbcdic(this.data, 24, 255);
    }

    public String rlrBundleBasescope() {
        return Util.ConvertEbcdic(this.data, 280, 255);
    }

    public String rlrBundleDefineSource() {
        return Util.ConvertEbcdic(this.data, 568, 8);
    }

    public LocalDateTime rlrBundleChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 576);
    }

    public BigInteger rlrBundleChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 576);
    }

    public String rlrBundleChangeUserid() {
        return Util.ConvertEbcdic(this.data, 584, 8);
    }

    public CIAgent rlrBundleChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 592);
        return CIAgent.from(value);
    }

    public int rlrBundleChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 592);
    }

    public CIAgent rlrBundleInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 594);
        return CIAgent.from(value);
    }

    public int rlrBundleInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 594);
    }

    public LocalDateTime rlrBundleInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 596);
    }

    public BigInteger rlrBundleInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 596);
    }

    public String rlrBundleInstallUserid() {
        return Util.ConvertEbcdic(this.data, 604, 8);
    }

    public static ResLifeBundleStatistics create(byte[] Data2, int offset, int length) {
        return new ResLifeBundleStatistics(Data2, offset, length);
    }

    static enum Field {
        rlrdsLen(0, 2),
        rlrdsId(2, 2),
        rlrdsVers(4, 1),
        rlrBundleName(8, 8),
        rlrBundleDirectory(24, 255),
        rlrBundleBasescope(280, 255),
        rlrBundleDefineSource(568, 8),
        rlrBundleChangeTime(576, 8),
        rlrBundleChangeUserid(584, 8),
        rlrBundleChangeAgent(592, 2),
        rlrBundleInstallAgent(594, 2),
        rlrBundleInstallTime(596, 8),
        rlrBundleInstallUserid(604, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

