/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class SystemDumpcodeStatistics
extends StatisticsDataSection {
    public static final int SDRIDE = 88;
    public static final int SDRVERS = 1;
    public static final int SDRCLEN = 32;

    private SystemDumpcodeStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int sdrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sdrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sdrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String sdrcode() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long sdrstkn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long sdrssupr() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long sdrttkn() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long sdrtsupr() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public static SystemDumpcodeStatistics create(byte[] Data2, int offset, int length) {
        return new SystemDumpcodeStatistics(Data2, offset, length);
    }

    static enum Field {
        sdrlen(0, 2),
        sdrid(2, 2),
        sdrdvers(4, 1),
        sdrcode(8, 8),
        sdrstkn(16, 4),
        sdrssupr(20, 4),
        sdrttkn(24, 4),
        sdrtsupr(28, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

