/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.TableManagerTableStatistics;
import com.blackhillsoftware.smf.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TableManagerGlobalStatistics
extends StatisticsDataSection {
    public static final int A16IDE = 63;
    public static final int A16VERS = 2;
    public static final int A16NTAB = 17;
    public static final int A16CLEN = 8;

    private TableManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a16len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a16id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a16dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public List<TableManagerTableStatistics> tableStatistics() {
        int datastart = 8;
        int count = 17;
        ArrayList<TableManagerTableStatistics> result = new ArrayList<TableManagerTableStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(TableManagerTableStatistics.create(this.data, datastart + i * 8, 8));
        }
        return Collections.unmodifiableList(result);
    }

    public static TableManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new TableManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        a16len(0, 2),
        a16id(2, 2),
        a16dvers(4, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

