/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class TlsCipherStatistics
extends StatisticsDataSection {
    public static final int SOCIDR = 151;

    private TlsCipherStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int socdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int socdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int socdsVers() {
        return Util.ConvertSignedBinary1(this.data, 4);
    }

    public String socCipher() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public long socTimesCicstlsInbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long socTimesCicstlsOutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long socTimesAttlsInbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long socTimesAttlsOutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public static TlsCipherStatistics create(byte[] Data2, int offset, int length) {
        return new TlsCipherStatistics(Data2, offset, length);
    }

    static enum Field {
        socdsLen(0, 2),
        socdsId(2, 2),
        socdsVers(4, 1),
        socCipher(8, 4),
        socTimesCicstlsInbUsed(12, 4),
        socTimesCicstlsOutbUsed(16, 4),
        socTimesAttlsInbUsed(20, 4),
        socTimesAttlsOutbUsed(24, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

