/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.Xmriactn;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.LocalDateTime;

public final class TransactionManagerTransactionStatistics
extends StatisticsDataSection {
    public static final int XMRIDE = 11;
    public static final int XMRVERS = 1;
    public static final String XMRDYNY = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(232).array(), 3, 1);
    public static final String XMRDYNN = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(213).array(), 3, 1);
    public static final String XMRIWTY = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(232).array(), 3, 1);
    public static final String XMRIWTN = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(213).array(), 3, 1);
    public static final int XMR_ENTRYPOINT_NO = 1;
    public static final int XMR_ENTRYPOINT_YES = 2;

    private TransactionManagerTransactionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int xmrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int xmrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int xmrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String xmrti() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public String xmrpn() {
        return Util.ConvertEbcdic(this.data, 12, 8);
    }

    public String xmrtcl() {
        return Util.ConvertEbcdic(this.data, 20, 8);
    }

    public String xmrrnam() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public String xmrrsys() {
        return Util.ConvertEbcdic(this.data, 36, 4);
    }

    public int xmrprty() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public String xmrdyn() {
        return Util.ConvertEbcdic(this.data, 42, 1);
    }

    public boolean xmrdyny() {
        return XMRDYNY.equals(this.xmrdyn());
    }

    public long xmrac() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long xmrrc() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long xmrdlc() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long xmrdrc() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long xmrrsc() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long xmrsvc() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public Duration xmritov() {
        return Util.Binary4Minutes(this.data, 68);
    }

    public double xmritovSeconds() {
        return Util.ToSeconds(this.xmritov());
    }

    public long xmritovRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public String xmriwtop() {
        return Util.ConvertEbcdic(this.data, 72, 1);
    }

    public boolean xmriwty() {
        return XMRIWTY.equals(this.xmriwtop());
    }

    public Xmriactn xmriactn() {
        int value = Util.ConvertUnsignedBinary1(this.data, 73);
        return Xmriactn.from(value);
    }

    public int xmriactnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 73);
    }

    public int xmrTranEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 74);
    }

    public boolean xmrEntrypointYes() {
        return Util.ConvertEquateValue(this.data, this.xmrTranEntrypoint(), 2);
    }

    public long xmriwait() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long xmrfatxn() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long xmrfait() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long xmrfanw() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long xmrfaop() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long xmrfaot() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long xmramism() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long xmraendc() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long xmrPurgedTrnclsThreshold() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public String xmrTranDefineSource() {
        return Util.ConvertEbcdic(this.data, 120, 8);
    }

    public LocalDateTime xmrTranChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 128);
    }

    public BigInteger xmrTranChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public String xmrTranChangeUserid() {
        return Util.ConvertEbcdic(this.data, 136, 8);
    }

    public CIAgent xmrTranChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 144);
        return CIAgent.from(value);
    }

    public int xmrTranChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public CIAgent xmrTranInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 146);
        return CIAgent.from(value);
    }

    public int xmrTranInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 146);
    }

    public LocalDateTime xmrTranInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 148);
    }

    public BigInteger xmrTranInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 148);
    }

    public String xmrTranInstallUserid() {
        return Util.ConvertEbcdic(this.data, 156, 8);
    }

    public static TransactionManagerTransactionStatistics create(byte[] Data2, int offset, int length) {
        return new TransactionManagerTransactionStatistics(Data2, offset, length);
    }

    static enum Field {
        xmrlen(0, 2),
        xmrid(2, 2),
        xmrdvers(4, 1),
        xmrti(8, 4),
        xmrpn(12, 8),
        xmrtcl(20, 8),
        xmrrnam(28, 8),
        xmrrsys(36, 4),
        xmrprty(40, 2),
        xmrdyn(42, 1),
        xmrac(44, 4),
        xmrrc(48, 4),
        xmrdlc(52, 4),
        xmrdrc(56, 4),
        xmrrsc(60, 4),
        xmrsvc(64, 4),
        xmritov(68, 4),
        xmriwtop(72, 1),
        xmriactn(73, 1),
        xmrTranEntrypoint(74, 1),
        xmriwait(76, 4),
        xmrfatxn(80, 4),
        xmrfait(84, 4),
        xmrfanw(88, 4),
        xmrfaop(92, 4),
        xmrfaot(96, 4),
        xmramism(100, 4),
        xmraendc(104, 4),
        xmrPurgedTrnclsThreshold(108, 4),
        xmrTranDefineSource(120, 8),
        xmrTranChangeTime(128, 8),
        xmrTranChangeUserid(136, 8),
        xmrTranChangeAgent(144, 2),
        xmrTranInstallAgent(146, 2),
        xmrTranInstallTime(148, 8),
        xmrTranInstallUserid(156, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

