/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.TqrFtype;
import com.blackhillsoftware.smf.cics.statistics.values.TqrQtype;
import com.blackhillsoftware.smf.cics.statistics.values.TqrRtype;
import com.blackhillsoftware.smf.cics.statistics.values.TqrWait;
import com.blackhillsoftware.smf.cics.statistics.values.TqrWaitAction;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class TransientDataQueueStatistics
extends StatisticsDataSection {
    public static final int TQRIDE = 42;
    public static final int TQRVERS = 1;
    public static final int TQRIOTYP = 72;
    public static final int TQRCLEN = 192;

    private TransientDataQueueStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int tqrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int tqrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int tqrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String tqrqid() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public TqrQtype tqrqtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 12);
        return TqrQtype.from(value);
    }

    public int tqrqtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public long tqrwrite() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long tqrread() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long tqrdelet() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int tqrtrigl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public TqrRtype tqrrtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 30);
        return TqrRtype.from(value);
    }

    public int tqrrtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 30);
    }

    public TqrFtype tqrftype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 31);
        return TqrFtype.from(value);
    }

    public int tqrftypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 31);
    }

    public String tqrfname() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public TqrWait tqrwait() {
        int value = Util.ConvertUnsignedBinary1(this.data, 36);
        return TqrWait.from(value);
    }

    public int tqrwaitRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    public TqrWaitAction tqrwaita() {
        int value = Util.ConvertUnsignedBinary1(this.data, 37);
        return TqrWaitAction.from(value);
    }

    public int tqrwaitaRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 37);
    }

    public String tqratran() {
        return Util.ConvertEbcdic(this.data, 40, 4);
    }

    public long tqrtrign() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long tqrccius() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long tqrpcius() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long tqrcnitm() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public String tqrrsys() {
        return Util.ConvertEbcdic(this.data, 60, 4);
    }

    public String tqrrqid() {
        return Util.ConvertEbcdic(this.data, 64, 4);
    }

    public String tqriqid() {
        return Util.ConvertEbcdic(this.data, 68, 4);
    }

    public String tqrddnm() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String tqrdsnnm() {
        return Util.ConvertEbcdic(this.data, 84, 44);
    }

    public String tqrpdsmn() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    public String tqrDefineSource() {
        return Util.ConvertEbcdic(this.data, 136, 8);
    }

    public LocalDateTime tqrChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 144);
    }

    public BigInteger tqrChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public String tqrChangeUserid() {
        return Util.ConvertEbcdic(this.data, 152, 8);
    }

    public CIAgent tqrChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 160);
        return CIAgent.from(value);
    }

    public int tqrChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 160);
    }

    public CIAgent tqrInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 162);
        return CIAgent.from(value);
    }

    public int tqrInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 162);
    }

    public LocalDateTime tqrInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 164);
    }

    public BigInteger tqrInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public String tqrInstallUserid() {
        return Util.ConvertEbcdic(this.data, 172, 8);
    }

    public long tqrpnitm() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public static TransientDataQueueStatistics create(byte[] Data2, int offset, int length) {
        return new TransientDataQueueStatistics(Data2, offset, length);
    }

    static enum Field {
        tqrlen(0, 2),
        tqrid(2, 2),
        tqrdvers(4, 1),
        tqrqid(8, 4),
        tqrqtype(12, 1),
        tqrwrite(16, 4),
        tqrread(20, 4),
        tqrdelet(24, 4),
        tqrtrigl(28, 2),
        tqrrtype(30, 1),
        tqrftype(31, 1),
        tqrfname(32, 4),
        tqrwait(36, 1),
        tqrwaita(37, 1),
        tqratran(40, 4),
        tqrtrign(44, 4),
        tqrccius(48, 4),
        tqrpcius(52, 4),
        tqrcnitm(56, 4),
        tqrrsys(60, 4),
        tqrrqid(64, 4),
        tqriqid(68, 4),
        tqrddnm(76, 8),
        tqrdsnnm(84, 44),
        tqrpdsmn(128, 8),
        tqrDefineSource(136, 8),
        tqrChangeTime(144, 8),
        tqrChangeUserid(152, 8),
        tqrChangeAgent(160, 2),
        tqrInstallAgent(162, 2),
        tqrInstallTime(164, 8),
        tqrInstallUserid(172, 8),
        tqrpnitm(188, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

