/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.IpFamily;
import com.blackhillsoftware.smf.cics.statistics.values.WbrUrimapAuthenticate;
import com.blackhillsoftware.smf.cics.statistics.values.WbrUrimapRedirectType;
import com.blackhillsoftware.smf.cics.statistics.values.WbrUrimapScheme;
import com.blackhillsoftware.smf.cics.statistics.values.WbrUrimapUsage;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;

public final class WebUrimapResourceStatistics
extends StatisticsDataSection {
    public static final int WBRDS_LENGTH = 1188;
    public static final int WBRIDR = 104;
    public static final int WBR_VERS = 1;
    public static final int WBR_ANALYZER_NO = 1;
    public static final int WBR_ANALYZER_YES = 2;
    public static final int WBR_ENTRYPOINT_NO = 1;
    public static final int WBR_ENTRYPOINT_YES = 2;

    private WebUrimapResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int wbrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int wbrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int wbrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String wbrUrimapName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public WbrUrimapUsage wbrUrimapUsage() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return WbrUrimapUsage.from(value);
    }

    public int wbrUrimapUsageRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public WbrUrimapScheme wbrUrimapScheme() {
        int value = Util.ConvertUnsignedBinary1(this.data, 17);
        return WbrUrimapScheme.from(value);
    }

    public int wbrUrimapSchemeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public int wbrUrimapAnalyzerUse() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public WbrUrimapRedirectType wbrUrimapRedirectType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 19);
        return WbrUrimapRedirectType.from(value);
    }

    public int wbrUrimapRedirectTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public WbrUrimapAuthenticate wbrUrimapAuthenticate() {
        int value = Util.ConvertUnsignedBinary1(this.data, 20);
        return WbrUrimapAuthenticate.from(value);
    }

    public int wbrUrimapAuthenticateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    public int wbrUrimapEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 23);
    }

    public String wbrUrimapHostname() {
        return Util.ConvertEbcdic(this.data, 24, 116);
    }

    public long wbrUrimapPort() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public String wbrUrimapPath() {
        return Util.ConvertEbcdic(this.data, 144, 255);
    }

    public String wbrUrimapTemplatename() {
        return Util.ConvertEbcdic(this.data, 400, 48);
    }

    public String wbrUrimapHfsfile() {
        return Util.ConvertEbcdic(this.data, 448, 255);
    }

    public String wbrUrimapLocation() {
        return Util.ConvertEbcdic(this.data, 704, 255);
    }

    public String wbrUrimapTransId() {
        return Util.ConvertEbcdic(this.data, 964, 4);
    }

    public String wbrUrimapTcpipservice() {
        return Util.ConvertEbcdic(this.data, 968, 8);
    }

    public String wbrUrimapConverter() {
        return Util.ConvertEbcdic(this.data, 976, 8);
    }

    public String wbrUrimapProgramName() {
        return Util.ConvertEbcdic(this.data, 984, 8);
    }

    public String wbrUrimapWebservice() {
        return Util.ConvertEbcdic(this.data, 992, 32);
    }

    public String wbrUrimapPipeline() {
        return Util.ConvertEbcdic(this.data, 1024, 8);
    }

    public String wbrUrimapAtomservice() {
        return Util.ConvertEbcdic(this.data, 1032, 8);
    }

    public long wbrUrimapReferenceCount() {
        return Util.ConvertUnsignedBinary4(this.data, 1040);
    }

    public long wbrUrimapMatchDisabled() {
        return Util.ConvertUnsignedBinary4(this.data, 1044);
    }

    public long wbrUrimapMatchRedirect() {
        return Util.ConvertUnsignedBinary4(this.data, 1048);
    }

    public Duration wbrUrimapSocketclose() {
        throw new NotAvailableException("Units for this field are undefined - please contact Black Hill Software");
    }

    public double wbrUrimapSocketcloseSeconds() {
        return Util.ToSeconds(this.wbrUrimapSocketclose());
    }

    public long wbrUrimapSocketcloseRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1056);
    }

    public long wbrUrimapSockpoolsize() {
        return Util.ConvertUnsignedBinary4(this.data, 1060);
    }

    public long wbrUrimapSockpoolsizePeak() {
        return Util.ConvertUnsignedBinary4(this.data, 1064);
    }

    public long wbrUrimapSocketsReclaimed() {
        return Util.ConvertUnsignedBinary4(this.data, 1068);
    }

    public long wbrUrimapSocketsTimedout() {
        return Util.ConvertUnsignedBinary4(this.data, 1072);
    }

    public String wbrUrimapIpAddress() {
        return Util.ConvertEbcdic(this.data, 1088, 39);
    }

    public InetAddress wbrUrimapIpAddressAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 1088, 39);
    }

    public IpFamily wbrUrimapIpFamily() {
        int value = Util.ConvertUnsignedBinary1(this.data, 1127);
        return IpFamily.from(value);
    }

    public int wbrUrimapIpFamilyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 1127);
    }

    public String wbrUrimapDefineSource() {
        return Util.ConvertEbcdic(this.data, 1144, 8);
    }

    public LocalDateTime wbrUrimapChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 1152);
    }

    public BigInteger wbrUrimapChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1152);
    }

    public String wbrUrimapChangeUserid() {
        return Util.ConvertEbcdic(this.data, 1160, 8);
    }

    public CIAgent wbrUrimapChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1168);
        return CIAgent.from(value);
    }

    public int wbrUrimapChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1168);
    }

    public CIAgent wbrUrimapInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1170);
        return CIAgent.from(value);
    }

    public int wbrUrimapInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1170);
    }

    public LocalDateTime wbrUrimapInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 1172);
    }

    public BigInteger wbrUrimapInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1172);
    }

    public String wbrUrimapInstallUserid() {
        return Util.ConvertEbcdic(this.data, 1180, 8);
    }

    public boolean wbrAnalyzerYes() {
        return Util.ConvertEquateValue(this.data, this.wbrUrimapAnalyzerUse(), 2);
    }

    public boolean wbrEntrypointYes() {
        return Util.ConvertEquateValue(this.data, this.wbrUrimapEntrypoint(), 2);
    }

    public static WebUrimapResourceStatistics create(byte[] Data2, int offset, int length) {
        return new WebUrimapResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        wbrdsLen(0, 2),
        wbrdsId(2, 2),
        wbrdsVers(4, 1),
        wbrUrimapName(8, 8),
        wbrUrimapUsage(16, 1),
        wbrUrimapScheme(17, 1),
        wbrUrimapAnalyzerUse(18, 1),
        wbrUrimapRedirectType(19, 1),
        wbrUrimapAuthenticate(20, 1),
        wbrUrimapEntrypoint(23, 1),
        wbrUrimapHostname(24, 116),
        wbrUrimapPort(140, 4),
        wbrUrimapPath(144, 255),
        wbrUrimapTemplatename(400, 48),
        wbrUrimapHfsfile(448, 255),
        wbrUrimapLocation(704, 255),
        wbrUrimapTransId(964, 4),
        wbrUrimapTcpipservice(968, 8),
        wbrUrimapConverter(976, 8),
        wbrUrimapProgramName(984, 8),
        wbrUrimapWebservice(992, 32),
        wbrUrimapPipeline(1024, 8),
        wbrUrimapAtomservice(1032, 8),
        wbrUrimapReferenceCount(1040, 4),
        wbrUrimapMatchDisabled(1044, 4),
        wbrUrimapMatchRedirect(1048, 4),
        wbrUrimapSocketclose(1056, 4),
        wbrUrimapSockpoolsize(1060, 4),
        wbrUrimapSockpoolsizePeak(1064, 4),
        wbrUrimapSocketsReclaimed(1068, 4),
        wbrUrimapSocketsTimedout(1072, 4),
        wbrUrimapIpAddress(1088, 39),
        wbrUrimapIpFamily(1127, 1),
        wbrUrimapDefineSource(1144, 8),
        wbrUrimapChangeTime(1152, 8),
        wbrUrimapChangeUserid(1160, 8),
        wbrUrimapChangeAgent(1168, 2),
        wbrUrimapInstallAgent(1170, 2),
        wbrUrimapInstallTime(1172, 8),
        wbrUrimapInstallUserid(1180, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

