/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class XmlTransformStatistics
extends StatisticsDataSection {
    public static final int MLRDS_LENGTH = 628;
    public static final int MLRIDR = 113;
    public static final int MLR_VERS = 1;
    public static final int MLR_VALIDATION_NO = 1;
    public static final int MLR_VALIDATION_YES = 2;

    private XmlTransformStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mlrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mlrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mlrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String mlrXmltransformName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public int mlrMsgValidation() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public String mlrXsdbindFile() {
        return Util.ConvertEbcdic(this.data, 56, 255);
    }

    public String mlrXmlschemaFile() {
        return Util.ConvertEbcdic(this.data, 312, 255);
    }

    public long mlrXmltrnfmUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 568);
    }

    public String mlrXmltrnfmDefineSource() {
        return Util.ConvertEbcdic(this.data, 584, 8);
    }

    public LocalDateTime mlrXmltrnfmChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 592);
    }

    public BigInteger mlrXmltrnfmChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 592);
    }

    public String mlrXmltrnfmChangeUserid() {
        return Util.ConvertEbcdic(this.data, 600, 8);
    }

    public CIAgent mlrXmltrnfmChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 608);
        return CIAgent.from(value);
    }

    public int mlrXmltrnfmChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 608);
    }

    public CIAgent mlrXmltrnfmInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 610);
        return CIAgent.from(value);
    }

    public int mlrXmltrnfmInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 610);
    }

    public LocalDateTime mlrXmltrnfmInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 612);
    }

    public BigInteger mlrXmltrnfmInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 612);
    }

    public String mlrXmltrnfmInstallUserid() {
        return Util.ConvertEbcdic(this.data, 620, 8);
    }

    public boolean mlrValidationYes() {
        return Util.ConvertEquateValue(this.data, this.mlrMsgValidation(), 2);
    }

    public static XmlTransformStatistics create(byte[] Data2, int offset, int length) {
        return new XmlTransformStatistics(Data2, offset, length);
    }

    static enum Field {
        mlrdsLen(0, 2),
        mlrdsId(2, 2),
        mlrdsVers(4, 1),
        mlrXmltransformName(8, 32),
        mlrMsgValidation(48, 1),
        mlrXsdbindFile(56, 255),
        mlrXmlschemaFile(312, 255),
        mlrXmltrnfmUseCount(568, 4),
        mlrXmltrnfmDefineSource(584, 8),
        mlrXmltrnfmChangeTime(592, 8),
        mlrXmltrnfmChangeUserid(600, 8),
        mlrXmltrnfmChangeAgent(608, 2),
        mlrXmltrnfmInstallAgent(610, 2),
        mlrXmltrnfmInstallTime(612, 8),
        mlrXmltrnfmInstallUserid(620, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

