/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class XqServerStorageStatistics
extends StatisticsDataSection {
    public static final int S3IDE = 123;
    public static final int S3VERS = 1;
    public static final int S3CLEN = 104;

    private XqServerStorageStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s3len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int s3id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int s3dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String s3anynam() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long s3anysiz() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long s3anyptr() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long s3anymx() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long s3anyus() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long s3anyfr() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long s3anylo() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long s3anyrqg() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long s3anyrqf() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long s3anyrqs() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long s3anyrqc() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public String s3lownam() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public long s3lowsiz() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long s3lowptr() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long s3lowmx() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long s3lowus() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long s3lowfr() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long s3lowlo() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long s3lowrqg() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long s3lowrqf() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long s3lowrqs() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long s3lowrqc() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public static XqServerStorageStatistics create(byte[] Data2, int offset, int length) {
        return new XqServerStorageStatistics(Data2, offset, length);
    }

    static enum Field {
        s3len(0, 2),
        s3id(2, 2),
        s3dvers(4, 1),
        s3anynam(8, 8),
        s3anysiz(16, 4),
        s3anyptr(20, 4),
        s3anymx(24, 4),
        s3anyus(28, 4),
        s3anyfr(32, 4),
        s3anylo(36, 4),
        s3anyrqg(40, 4),
        s3anyrqf(44, 4),
        s3anyrqs(48, 4),
        s3anyrqc(52, 4),
        s3lownam(56, 8),
        s3lowsiz(64, 4),
        s3lowptr(68, 4),
        s3lowmx(72, 4),
        s3lowus(76, 4),
        s3lowfr(80, 4),
        s3lowlo(84, 4),
        s3lowrqg(88, 4),
        s3lowrqf(92, 4),
        s3lowrqs(96, 4),
        s3lowrqc(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

