/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.cics420;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class DispatcherTcbPoolStatistics
extends com.blackhillsoftware.smf.cics.statistics.DispatcherTcbPoolStatistics {
    public static final int DSGPLEN = 144;

    private DispatcherTcbPoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    @Override
    public int dsgtcbpn() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    @Override
    public long dsgmxtcb() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    @Override
    public long dsgcnuat() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    @Override
    public long dsgpnuat() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    @Override
    public long dsgcnuus() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    @Override
    public long dsgpnuus() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    @Override
    public long dsgntcbl() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    @Override
    public Duration dsgtotwl() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    @Override
    public double dsgtotwlSeconds() {
        return Util.ToSeconds(this.dsgtotwl());
    }

    @Override
    public long dsgtotwlRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    @Override
    public Duration dsgcurwt() {
        return Util.Binary8StckInterval(this.data, 48);
    }

    @Override
    public double dsgcurwtSeconds() {
        return Util.ToSeconds(this.dsgcurwt());
    }

    @Override
    public long dsgcurwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    @Override
    public Duration dsgtotmt() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    @Override
    public double dsgtotmtSeconds() {
        return Util.ToSeconds(this.dsgtotmt());
    }

    @Override
    public long dsgtotmtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    @Override
    public long dsgtotnw() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    @Override
    public long dsgtotmw() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    @Override
    public long dsgcurnw() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    @Override
    public long dsgpeanw() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    @Override
    public long dsgmmwts() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    @Override
    public Duration dsgmmwtm() {
        return Util.Binary8StckInterval(this.data, 96);
    }

    @Override
    public double dsgmmwtmSeconds() {
        return Util.ToSeconds(this.dsgmmwtm());
    }

    @Override
    public long dsgmmwtmRawValue() {
        return Util.ConvertSignedBinary8(this.data, 96);
    }

    @Override
    public long dsgcmmws() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    @Override
    public long dsgpmmws() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    @Override
    public Duration dsgcmmwt() {
        return Util.Binary8StckInterval(this.data, 120);
    }

    @Override
    public double dsgcmmwtSeconds() {
        return Util.ToSeconds(this.dsgcmmwt());
    }

    @Override
    public long dsgcmmwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 120);
    }

    public static DispatcherTcbPoolStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherTcbPoolStatistics(Data2, offset, length);
    }

    @Override
    public ZonedDateTime dsggtcbl() {
        throw new NotAvailableException("Not available in CICS 4.2");
    }

    @Override
    public BigInteger dsggtcblRawValue() {
        throw new NotAvailableException("Not available in CICS 4.2");
    }

    @Override
    public LocalDateTime dsgltcbl() {
        throw new NotAvailableException("Not available in CICS 4.2");
    }

    @Override
    public BigInteger dsgltcblRawValue() {
        throw new NotAvailableException("Not available in CICS 4.2");
    }

    static enum Field {
        dsgtcbpn(0, 2),
        dsgmxtcb(4, 4),
        dsgcnuat(8, 4),
        dsgpnuat(12, 4),
        dsgcnuus(16, 4),
        dsgpnuus(20, 4),
        dsgntcbl(32, 4),
        dsgtotwl(40, 8),
        dsgcurwt(48, 8),
        dsgtotmt(56, 8),
        dsgtotnw(64, 4),
        dsgtotmw(68, 4),
        dsgcurnw(72, 4),
        dsgpeanw(76, 4),
        dsgmmwts(92, 4),
        dsgmmwtm(96, 8),
        dsgcmmws(112, 4),
        dsgpmmws(116, 4),
        dsgcmmwt(120, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

