/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.cics510;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.values.DsgTcbMode;
import com.blackhillsoftware.smf.cics.statistics.values.DsgTcbPool;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class DispatcherTcbModeStatistics
extends com.blackhillsoftware.smf.cics.statistics.DispatcherTcbModeStatistics {
    public static final int DSGMDLEN = 136;

    private DispatcherTcbModeStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    @Override
    public String dsgtcbnm() {
        return Util.ConvertEbcdic(this.data, 0, 2);
    }

    @Override
    public DsgTcbMode dsgtcbmd() {
        int value = Util.ConvertUnsignedBinary1(this.data, 2);
        return DsgTcbMode.from(value);
    }

    @Override
    public int dsgtcbmdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    @Override
    public DsgTcbPool dsgtcbmp() {
        int value = Util.ConvertUnsignedBinary2(this.data, 4);
        return DsgTcbPool.from(value);
    }

    @Override
    public int dsgtcbmpRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    @Override
    public long dsgntcba() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    @Override
    public long dsgtcbaf() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    @Override
    public long dsgtcbca() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    @Override
    public long dsgtcbpa() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    @Override
    public long dsgtcbcu() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    @Override
    public long dsgtcbpu() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    @Override
    public long dsgtcbal() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    @Override
    public long dsgtcbdu() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    @Override
    public long dsgtcbds() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    @Override
    public long dsgtcbdx() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    @Override
    public long dsgtcbdo() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    @Override
    public long dsgtcbst() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    @Override
    public long dsgtcbmm() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    @Override
    public long dsgsysw() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    @Override
    public long dsgtmcdq() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public long dsgtmpdq() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public double dsgtmadq() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public Duration dsgtwt() {
        return Util.Binary8StckInterval(this.data, 88);
    }

    @Override
    public double dsgtwtSeconds() {
        return Util.ToSeconds(this.dsgtwt());
    }

    @Override
    public long dsgtwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 88);
    }

    @Override
    public Duration dsgtdt() {
        return Util.Binary8StckInterval(this.data, 96);
    }

    @Override
    public double dsgtdtSeconds() {
        return Util.ToSeconds(this.dsgtdt());
    }

    @Override
    public long dsgtdtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 96);
    }

    @Override
    public Duration dsgtct() {
        return Util.Binary8StckInterval(this.data, 104);
    }

    @Override
    public double dsgtctSeconds() {
        return Util.ToSeconds(this.dsgtct());
    }

    @Override
    public long dsgtctRawValue() {
        return Util.ConvertSignedBinary8(this.data, 104);
    }

    @Override
    public Duration dsgact() {
        return Util.Binary8StckInterval(this.data, 112);
    }

    @Override
    public double dsgactSeconds() {
        return Util.ToSeconds(this.dsgact());
    }

    @Override
    public long dsgactRawValue() {
        return Util.ConvertSignedBinary8(this.data, 112);
    }

    public static DispatcherTcbModeStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherTcbModeStatistics(Data2, offset, length);
    }

    static enum Field {
        dsgtcbnm(0, 2),
        dsgtcbmd(2, 1),
        dsgtcbmp(4, 2),
        dsgntcba(8, 4),
        dsgtcbaf(12, 4),
        dsgtcbca(16, 4),
        dsgtcbpa(20, 4),
        dsgtcbcu(28, 4),
        dsgtcbpu(32, 4),
        dsgtcbal(44, 4),
        dsgtcbdu(52, 4),
        dsgtcbds(56, 4),
        dsgtcbdx(60, 4),
        dsgtcbdo(64, 4),
        dsgtcbst(72, 4),
        dsgtcbmm(76, 4),
        dsgsysw(80, 4),
        dsgtwt(88, 8),
        dsgtdt(96, 8),
        dsgtct(104, 8),
        dsgact(112, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

