/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.cics530;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.values.TmrAcMth;
import com.blackhillsoftware.smf.cics.statistics.values.TmrNatur;
import com.blackhillsoftware.smf.cics.statistics.values.TmrSesst;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.LocalDateTime;

public final class MonitoringTransactionStatistics
extends com.blackhillsoftware.smf.cics.statistics.MonitoringTransactionStatistics {
    public static final int MNTIDE = 84;
    public static final int MNTVERS = 1;
    public static final int TMRTRFL1_NONE = 128;
    public static final int TMRTRFL1_TERM = 64;
    public static final int TMRTRFL1_SURR = 32;
    public static final int TMRTRFL1_DEST = 16;
    public static final int TMRTRFL1_BRDG = 8;
    public static final int TMRTRFL2_SYSTEM = 128;
    public static final int TMRTRFL2_MIRROR = 64;
    public static final int TMRTRFL2_DPL = 32;
    public static final int TMRTRFL2_ONC_RPC = 16;
    public static final int TMRTRFL2_WEB = 8;
    public static final int TMRTRFL2_BRIDGE = 4;
    public static final int TMRTFFL2_RUN_TRAN = 1;
    public static final int TMRTRFL3_RPT = 128;
    public static final int TMRTRFL3_NTFY_COMP = 64;
    public static final int TMRTRFL3_NTFY = 32;
    public static final int TMRTRFL4_LOC_BELOW = 128;
    public static final int TMRTRFL4_CICS_KEY = 64;
    public static final int TMRTRFL4_ISOLATE_NO = 32;
    public static final int TMRTRFL4_DYNAMIC = 16;
    public static final int TMRTRFL8_WAIT_NO = 128;
    public static final int TMRTRFL8_COMMIT = 64;
    public static final int TMRTRFL8_INDOUBT_ACT = 32;
    public static final int TMRTRFL8_UOW_SHUNT = 16;
    public static final int TMRTRFL8_UOW_UNSHUNT = 8;
    public static final int TMRTRFL8_INDBT_FAIL = 4;
    public static final int TMRTRFL8_RO_FAILURE = 2;
    public static final String TMRRTYPE_CONVERSE = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(195).array(), 3, 1);
    public static final String TMRRTYPE_DELIVER = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(196).array(), 3, 1);
    public static final String TMRRTYPE_FREQUENCY = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(198).array(), 3, 1);
    public static final String TMRRTYPE_SYNCPOINT = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(226).array(), 3, 1);
    public static final String TMRRTYPE_TERMINATE = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(227).array(), 3, 1);

    private MonitoringTransactionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    @Override
    public int mntlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    @Override
    public int mntid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    @Override
    public int mntdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    @Override
    public String tmrtrid() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    @Override
    public String tmrteid() {
        return Util.ConvertEbcdic(this.data, 12, 4);
    }

    @Override
    public String tmrusid() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    @Override
    public String tmrtrty() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    @Override
    public LocalDateTime tmrattt() {
        return Util.Binary8xStckLocalTime(this.data, 28);
    }

    @Override
    public BigInteger tmratttRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    @Override
    public LocalDateTime tmrdett() {
        return Util.Binary8xStckLocalTime(this.data, 36);
    }

    @Override
    public BigInteger tmrdettRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 36);
    }

    @Override
    public long tmrtrsn() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    @Override
    public long tmrtpri() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    @Override
    public String tmrtclsn() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    @Override
    public String tmrlunm() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    @Override
    public String tmrpgnm() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    @Override
    public String tmrnetpx() {
        return Util.ConvertEbcdic(this.data, 76, 20);
    }

    @Override
    public long tmrnetsx() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    @Override
    public BigInteger tmrnetsxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    @Override
    public String tmrrsys() {
        return Util.ConvertEbcdic(this.data, 104, 4);
    }

    @Override
    public long tmrprcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    @Override
    public String tmrrmuow() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    @Override
    public String tmrsrvcl() {
        return Util.ConvertEbcdic(this.data, 120, 8);
    }

    @Override
    public String tmrrptcl() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    @Override
    public String tmrfcty() {
        return Util.ConvertEbcdic(this.data, 136, 4);
    }

    @Override
    public int tmrtrfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 140);
    }

    @Override
    public boolean tmrtrfl1None() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 128);
    }

    @Override
    public boolean tmrtrfl1Term() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 64);
    }

    @Override
    public boolean tmrtrfl1Surr() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 32);
    }

    @Override
    public boolean tmrtrfl1Dest() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 16);
    }

    @Override
    public boolean tmrtrfl1Brdg() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 8);
    }

    @Override
    public int tmrtrfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 141);
    }

    @Override
    public boolean tmrtrfl2System() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 128);
    }

    @Override
    public boolean tmrtrfl2Mirror() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 64);
    }

    @Override
    public boolean tmrtrfl2Dpl() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 32);
    }

    @Override
    public boolean tmrtrfl2OncRpc() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 16);
    }

    @Override
    public boolean tmrtrfl2Web() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 8);
    }

    @Override
    public boolean tmrtrfl2Bridge() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 4);
    }

    @Override
    public boolean tmrtffl2RunTran() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 1);
    }

    @Override
    public int tmrtrfl3() {
        return Util.ConvertUnsignedBinary1(this.data, 142);
    }

    @Override
    public boolean tmrtrfl3Rpt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 128);
    }

    @Override
    public boolean tmrtrfl3NtfyComp() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 64);
    }

    @Override
    public boolean tmrtrfl3Ntfy() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 32);
    }

    @Override
    public int tmrtrfl4() {
        return Util.ConvertUnsignedBinary1(this.data, 143);
    }

    @Override
    public boolean tmrtrfl4LocBelow() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 128);
    }

    @Override
    public boolean tmrtrfl4CicsKey() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 64);
    }

    @Override
    public boolean tmrtrfl4IsolateNo() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 32);
    }

    @Override
    public boolean tmrtrfl4Dynamic() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 16);
    }

    @Override
    public int tmrtrfl5() {
        return Util.ConvertUnsignedBinary1(this.data, 144);
    }

    @Override
    public int tmrtrfl6() {
        return Util.ConvertUnsignedBinary1(this.data, 145);
    }

    @Override
    public int tmrtrfl7() {
        return Util.ConvertUnsignedBinary1(this.data, 146);
    }

    @Override
    public int tmrtrfl8() {
        return Util.ConvertUnsignedBinary1(this.data, 147);
    }

    @Override
    public boolean tmrtrfl8WaitNo() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 128);
    }

    @Override
    public boolean tmrtrfl8Commit() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 64);
    }

    @Override
    public boolean tmrtrfl8IndoubtAct() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 32);
    }

    @Override
    public boolean tmrtrfl8UowShunt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 16);
    }

    @Override
    public boolean tmrtrfl8UowUnshunt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 8);
    }

    @Override
    public boolean tmrtrfl8IndbtFail() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 4);
    }

    @Override
    public boolean tmrtrfl8RoFailure() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 2);
    }

    @Override
    public TmrNatur tmrnatur() {
        int value = Util.ConvertUnsignedBinary1(this.data, 148);
        return TmrNatur.from(value);
    }

    @Override
    public int tmrnaturRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    @Override
    public TmrSesst tmrsesst() {
        int value = Util.ConvertUnsignedBinary1(this.data, 149);
        return TmrSesst.from(value);
    }

    @Override
    public int tmrsesstRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 149);
    }

    @Override
    public TmrAcMth tmracmth() {
        int value = Util.ConvertUnsignedBinary1(this.data, 150);
        return TmrAcMth.from(value);
    }

    @Override
    public int tmracmthRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 150);
    }

    @Override
    public int tmrdvtcd() {
        return Util.ConvertUnsignedBinary1(this.data, 151);
    }

    @Override
    public String tmrtecnm() {
        return Util.ConvertEbcdic(this.data, 152, 4);
    }

    @Override
    public String tmrbtrid() {
        return Util.ConvertEbcdic(this.data, 156, 4);
    }

    @Override
    public String tmrurid() {
        return Util.ConvertEbcdic(this.data, 160, 16);
    }

    @Override
    public String tmrpname() {
        return Util.ConvertEbcdic(this.data, 176, 36);
    }

    @Override
    public String tmrptype() {
        return Util.ConvertEbcdic(this.data, 212, 8);
    }

    @Override
    public String tmrprcid() {
        return Util.ConvertEbcdic(this.data, 220, 52);
    }

    @Override
    public String tmractid() {
        return Util.ConvertEbcdic(this.data, 272, 52);
    }

    @Override
    public String tmractnm() {
        return Util.ConvertEbcdic(this.data, 324, 16);
    }

    @Override
    public String tmrcipad() {
        return Util.ConvertEbcdic(this.data, 340, 40);
    }

    @Override
    public InetAddress tmrcipadAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 340, 40);
    }

    @Override
    public byte[] tmrtgpid() {
        if (this.data.length >= 408) {
            byte[] result = new byte[28];
            System.arraycopy(this.data, 380, result, 0, 28);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(380) + " Data length: " + Integer.toString(28));
    }

    @Override
    public String tmrnetid() {
        return Util.ConvertEbcdic(this.data, 408, 8);
    }

    @Override
    public String tmrrlunm() {
        return Util.ConvertEbcdic(this.data, 416, 8);
    }

    @Override
    public String tmrtcpsv() {
        return Util.ConvertEbcdic(this.data, 424, 8);
    }

    @Override
    public long tmrportn() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    @Override
    public byte[] tmrotsid() {
        if (this.data.length >= 564) {
            byte[] result = new byte[128];
            System.arraycopy(this.data, 436, result, 0, 128);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(436) + " Data length: " + Integer.toString(128));
    }

    @Override
    public long tmrcipor() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    @Override
    public String tmriscnm() {
        return Util.ConvertEbcdic(this.data, 568, 8);
    }

    @Override
    public String tmronwid() {
        return Util.ConvertEbcdic(this.data, 576, 8);
    }

    @Override
    public String tmroapid() {
        return Util.ConvertEbcdic(this.data, 584, 8);
    }

    @Override
    public LocalDateTime tmroattt() {
        return Util.Binary8xStckLocalTime(this.data, 592);
    }

    @Override
    public BigInteger tmroatttRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 592);
    }

    @Override
    public String tmrotrsn() {
        return Util.ConvertEbcdic(this.data, 600, 4);
    }

    @Override
    public String tmrotrid() {
        return Util.ConvertEbcdic(this.data, 604, 4);
    }

    @Override
    public String tmrousid() {
        return Util.ConvertEbcdic(this.data, 608, 8);
    }

    @Override
    public byte[] tmrousrc() {
        if (this.data.length >= 680) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 616, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(616) + " Data length: " + Integer.toString(64));
    }

    @Override
    public String tmrotcps() {
        return Util.ConvertEbcdic(this.data, 680, 8);
    }

    @Override
    public long tmroprtn() {
        return Util.ConvertUnsignedBinary4(this.data, 688);
    }

    @Override
    public String tmrocipa() {
        return Util.ConvertEbcdic(this.data, 692, 40);
    }

    @Override
    public InetAddress tmrocipaAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 692, 40);
    }

    @Override
    public long tmrocpno() {
        return Util.ConvertUnsignedBinary4(this.data, 732);
    }

    @Override
    public long tmrotrfg() {
        return Util.ConvertUnsignedBinary8(this.data, 736);
    }

    @Override
    public BigInteger tmrotrfgAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 736);
    }

    @Override
    public String tmrofcty() {
        return Util.ConvertEbcdic(this.data, 744, 8);
    }

    @Override
    public String tmrurimn() {
        return Util.ConvertEbcdic(this.data, 752, 8);
    }

    @Override
    public String tmrpipln() {
        return Util.ConvertEbcdic(this.data, 760, 8);
    }

    @Override
    public String tmratmsn() {
        return Util.ConvertEbcdic(this.data, 768, 8);
    }

    @Override
    public String tmrwsvcn() {
        return Util.ConvertEbcdic(this.data, 776, 32);
    }

    @Override
    public String tmrwsopn() {
        return Util.ConvertEbcdic(this.data, 808, 64);
    }

    @Override
    public String tmrwpbmn() {
        return Util.ConvertEbcdic(this.data, 872, 8);
    }

    @Override
    public String tmrphnwd() {
        return Util.ConvertEbcdic(this.data, 880, 8);
    }

    @Override
    public String tmrphapl() {
        return Util.ConvertEbcdic(this.data, 888, 8);
    }

    @Override
    public LocalDateTime tmrphatt() {
        return Util.Binary8xStckLocalTime(this.data, 896);
    }

    @Override
    public BigInteger tmrphattRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 896);
    }

    @Override
    public String tmrphtsn() {
        return Util.ConvertEbcdic(this.data, 904, 4);
    }

    @Override
    public String tmrphtid() {
        return Util.ConvertEbcdic(this.data, 908, 4);
    }

    @Override
    public long tmrphcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 912);
    }

    @Override
    public String tmradpid() {
        return Util.ConvertEbcdic(this.data, 916, 64);
    }

    @Override
    public byte[] tmradpd1() {
        if (this.data.length >= 1044) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 980, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(980) + " Data length: " + Integer.toString(64));
    }

    @Override
    public byte[] tmradpd2() {
        if (this.data.length >= 1108) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 1044, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1044) + " Data length: " + Integer.toString(64));
    }

    @Override
    public byte[] tmradpd3() {
        if (this.data.length >= 1172) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 1108, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1108) + " Data length: " + Integer.toString(64));
    }

    @Override
    public long tmrsocph() {
        return Util.ConvertUnsignedBinary4(this.data, 1172);
    }

    @Override
    public String tmrcectp() {
        return Util.ConvertEbcdic(this.data, 1176, 4);
    }

    @Override
    public String tmrcecid() {
        return Util.ConvertEbcdic(this.data, 1180, 16);
    }

    @Override
    public long tmrmtsks() {
        return Util.ConvertUnsignedBinary4(this.data, 1196);
    }

    @Override
    public long tmrctsks() {
        return Util.ConvertUnsignedBinary4(this.data, 1200);
    }

    @Override
    public String tmrappln() {
        return Util.ConvertEbcdic(this.data, 1204, 64);
    }

    @Override
    public String tmrplatn() {
        return Util.ConvertEbcdic(this.data, 1268, 64);
    }

    @Override
    public long tmrmajvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1332);
    }

    @Override
    public long tmrminvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1336);
    }

    @Override
    public long tmrmicvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1340);
    }

    @Override
    public String tmropern() {
        return Util.ConvertEbcdic(this.data, 1344, 64);
    }

    @Override
    public long tmrerror() {
        return Util.ConvertUnsignedBinary4(this.data, 1408);
    }

    @Override
    public String tmrabcdo() {
        return Util.ConvertEbcdic(this.data, 1412, 4);
    }

    @Override
    public String tmrabcdc() {
        return Util.ConvertEbcdic(this.data, 1416, 4);
    }

    @Override
    public String tmrtype() {
        return Util.ConvertEbcdic(this.data, 1420, 4);
    }

    @Override
    public long tmrpinmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1424);
    }

    @Override
    public long tmrtci1c() {
        return Util.ConvertUnsignedBinary4(this.data, 1428);
    }

    @Override
    public long tmrpoumc() {
        return Util.ConvertUnsignedBinary4(this.data, 1432);
    }

    @Override
    public long tmrtco1c() {
        return Util.ConvertUnsignedBinary4(this.data, 1436);
    }

    @Override
    public long tmrsinmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1440);
    }

    @Override
    public long tmrtci2c() {
        return Util.ConvertUnsignedBinary4(this.data, 1444);
    }

    @Override
    public long tmrsoumc() {
        return Util.ConvertUnsignedBinary4(this.data, 1448);
    }

    @Override
    public long tmrtco2c() {
        return Util.ConvertUnsignedBinary4(this.data, 1452);
    }

    @Override
    public long tmr62imc() {
        return Util.ConvertUnsignedBinary4(this.data, 1456);
    }

    @Override
    public long tmr62ich() {
        return Util.ConvertUnsignedBinary4(this.data, 1460);
    }

    @Override
    public long tmr62omc() {
        return Util.ConvertUnsignedBinary4(this.data, 1464);
    }

    @Override
    public long tmr62och() {
        return Util.ConvertUnsignedBinary4(this.data, 1468);
    }

    @Override
    public long tmrtac() {
        return Util.ConvertUnsignedBinary4(this.data, 1472);
    }

    @Override
    public long tmrscugb() {
        return Util.ConvertUnsignedBinary4(this.data, 1476);
    }

    @Override
    public long tmrscuga() {
        return Util.ConvertUnsignedBinary4(this.data, 1480);
    }

    @Override
    public long tmrsccgb() {
        return Util.ConvertUnsignedBinary4(this.data, 1484);
    }

    @Override
    public long tmrsccga() {
        return Util.ConvertUnsignedBinary4(this.data, 1488);
    }

    @Override
    public long tmrushwb() {
        return Util.ConvertUnsignedBinary4(this.data, 1492);
    }

    @Override
    public long tmrushwa() {
        return Util.ConvertUnsignedBinary4(this.data, 1496);
    }

    @Override
    public long tmrchwmb() {
        return Util.ConvertUnsignedBinary4(this.data, 1500);
    }

    @Override
    public long tmrchwma() {
        return Util.ConvertUnsignedBinary4(this.data, 1504);
    }

    @Override
    public long tmrutsob() {
        return Util.ConvertUnsignedBinary8(this.data, 1508);
    }

    @Override
    public BigInteger tmrutsobAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1508);
    }

    @Override
    public long tmrutsoa() {
        return Util.ConvertUnsignedBinary8(this.data, 1516);
    }

    @Override
    public BigInteger tmrutsoaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1516);
    }

    @Override
    public long tmrcoccb() {
        return Util.ConvertUnsignedBinary8(this.data, 1524);
    }

    @Override
    public BigInteger tmrcoccbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1524);
    }

    @Override
    public long tmrcocca() {
        return Util.ConvertUnsignedBinary8(this.data, 1532);
    }

    @Override
    public BigInteger tmrcoccaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1532);
    }

    @Override
    public long tmrsc24s() {
        return Util.ConvertUnsignedBinary4(this.data, 1540);
    }

    @Override
    public long tmrsc24g() {
        return Util.ConvertUnsignedBinary4(this.data, 1544);
    }

    @Override
    public long tmrsc24f() {
        return Util.ConvertUnsignedBinary4(this.data, 1548);
    }

    @Override
    public long tmrsc31s() {
        return Util.ConvertUnsignedBinary4(this.data, 1552);
    }

    @Override
    public long tmrsc31g() {
        return Util.ConvertUnsignedBinary4(this.data, 1556);
    }

    @Override
    public long tmrsc31f() {
        return Util.ConvertUnsignedBinary4(this.data, 1560);
    }

    @Override
    public long tmrsccgg() {
        return Util.ConvertUnsignedBinary4(this.data, 1564);
    }

    @Override
    public long tmrchwmg() {
        return Util.ConvertUnsignedBinary4(this.data, 1568);
    }

    @Override
    public long tmrscugg() {
        return Util.ConvertUnsignedBinary4(this.data, 1572);
    }

    @Override
    public long tmruhwmg() {
        return Util.ConvertUnsignedBinary4(this.data, 1576);
    }

    @Override
    public long tmrsc64s() {
        return Util.ConvertUnsignedBinary4(this.data, 1580);
    }

    @Override
    public long tmrsc64g() {
        return Util.ConvertUnsignedBinary4(this.data, 1584);
    }

    @Override
    public long tmrsc64f() {
        return Util.ConvertUnsignedBinary4(this.data, 1588);
    }

    @Override
    public long tmrpcuse() {
        return Util.ConvertUnsignedBinary4(this.data, 1592);
    }

    @Override
    public long tmrpc31a() {
        return Util.ConvertUnsignedBinary4(this.data, 1596);
    }

    @Override
    public long tmrpcusb() {
        return Util.ConvertUnsignedBinary4(this.data, 1600);
    }

    @Override
    public long tmrpccah() {
        return Util.ConvertUnsignedBinary4(this.data, 1604);
    }

    @Override
    public long tmrpccbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1608);
    }

    @Override
    public long tmrpcrah() {
        return Util.ConvertUnsignedBinary4(this.data, 1612);
    }

    @Override
    public long tmrpcrbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1616);
    }

    @Override
    public long tmrpcsah() {
        return Util.ConvertUnsignedBinary4(this.data, 1620);
    }

    @Override
    public long tmrpcsbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1624);
    }

    @Override
    public long tmrfcgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1628);
    }

    @Override
    public long tmrfcpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1632);
    }

    @Override
    public long tmrfcbc() {
        return Util.ConvertUnsignedBinary4(this.data, 1636);
    }

    @Override
    public long tmrfcac() {
        return Util.ConvertUnsignedBinary4(this.data, 1640);
    }

    @Override
    public long tmrfcdc() {
        return Util.ConvertUnsignedBinary4(this.data, 1644);
    }

    @Override
    public long tmrfctc() {
        return Util.ConvertUnsignedBinary4(this.data, 1648);
    }

    @Override
    public long tmrfcamc() {
        return Util.ConvertUnsignedBinary4(this.data, 1652);
    }

    @Override
    public long tmrtdgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1656);
    }

    @Override
    public long tmrtdpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1660);
    }

    @Override
    public long tmrtdrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1664);
    }

    @Override
    public long tmrtdtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1668);
    }

    @Override
    public long tmrtsgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1672);
    }

    @Override
    public long tmrtspac() {
        return Util.ConvertUnsignedBinary4(this.data, 1676);
    }

    @Override
    public long tmrtspmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1680);
    }

    @Override
    public long tmrtsgsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1684);
    }

    @Override
    public long tmrtspsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1688);
    }

    @Override
    public long tmrtstc() {
        return Util.ConvertUnsignedBinary4(this.data, 1692);
    }

    @Override
    public long tmrbmmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1696);
    }

    @Override
    public long tmrbmic() {
        return Util.ConvertUnsignedBinary4(this.data, 1700);
    }

    @Override
    public long tmrbmoc() {
        return Util.ConvertUnsignedBinary4(this.data, 1704);
    }

    @Override
    public long tmrbmtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1708);
    }

    @Override
    public long tmrpclic() {
        return Util.ConvertUnsignedBinary4(this.data, 1712);
    }

    @Override
    public long tmrpcxc() {
        return Util.ConvertUnsignedBinary4(this.data, 1716);
    }

    @Override
    public long tmrpcloc() {
        return Util.ConvertUnsignedBinary4(this.data, 1720);
    }

    @Override
    public long tmrpcluc() {
        return Util.ConvertUnsignedBinary4(this.data, 1724);
    }

    @Override
    public long tmrpcdpl() {
        return Util.ConvertUnsignedBinary4(this.data, 1728);
    }

    @Override
    public long tmrpcdll() {
        return Util.ConvertUnsignedBinary4(this.data, 1732);
    }

    @Override
    public long tmrpcdrl() {
        return Util.ConvertUnsignedBinary4(this.data, 1736);
    }

    @Override
    public long tmrpclcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1740);
    }

    @Override
    public long tmrpcxcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1744);
    }

    @Override
    public long tmrpcdcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1748);
    }

    @Override
    public long tmrpcrcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1752);
    }

    @Override
    public long tmrpcrcl() {
        return Util.ConvertUnsignedBinary4(this.data, 1756);
    }

    @Override
    public long tmrjnlct() {
        return Util.ConvertUnsignedBinary4(this.data, 1760);
    }

    @Override
    public long tmrlgwct() {
        return Util.ConvertUnsignedBinary4(this.data, 1764);
    }

    @Override
    public long tmricc() {
        return Util.ConvertUnsignedBinary4(this.data, 1768);
    }

    @Override
    public long tmrictc() {
        return Util.ConvertUnsignedBinary4(this.data, 1772);
    }

    @Override
    public long tmricscc() {
        return Util.ConvertUnsignedBinary4(this.data, 1776);
    }

    @Override
    public long tmricscd() {
        return Util.ConvertUnsignedBinary4(this.data, 1780);
    }

    @Override
    public long tmricsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1784);
    }

    @Override
    public long tmricsrd() {
        return Util.ConvertUnsignedBinary4(this.data, 1788);
    }

    @Override
    public long tmrsppc() {
        return Util.ConvertUnsignedBinary4(this.data, 1792);
    }

    @Override
    public long tmrcfact() {
        return Util.ConvertUnsignedBinary4(this.data, 1796);
    }

    @Override
    public long tmrszact() {
        return Util.ConvertUnsignedBinary4(this.data, 1800);
    }

    @Override
    public long tmrszrct() {
        return Util.ConvertUnsignedBinary4(this.data, 1804);
    }

    @Override
    public long tmrszsct() {
        return Util.ConvertUnsignedBinary4(this.data, 1808);
    }

    @Override
    public long tmrsztct() {
        return Util.ConvertUnsignedBinary4(this.data, 1812);
    }

    @Override
    public long tmrszcot() {
        return Util.ConvertUnsignedBinary4(this.data, 1816);
    }

    @Override
    public long tmrszcin() {
        return Util.ConvertUnsignedBinary4(this.data, 1820);
    }

    @Override
    public long tmrszato() {
        return Util.ConvertUnsignedBinary4(this.data, 1824);
    }

    @Override
    public long tmrszrto() {
        return Util.ConvertUnsignedBinary4(this.data, 1828);
    }

    @Override
    public long tmrsztot() {
        return Util.ConvertUnsignedBinary4(this.data, 1832);
    }

    @Override
    public long tmrbarsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1836);
    }

    @Override
    public long tmrbarac() {
        return Util.ConvertUnsignedBinary4(this.data, 1840);
    }

    @Override
    public long tmrbalkc() {
        return Util.ConvertUnsignedBinary4(this.data, 1844);
    }

    @Override
    public long tmrbadpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1848);
    }

    @Override
    public long tmrbadac() {
        return Util.ConvertUnsignedBinary4(this.data, 1852);
    }

    @Override
    public long tmrbtpac() {
        return Util.ConvertUnsignedBinary4(this.data, 1856);
    }

    @Override
    public long tmrbspac() {
        return Util.ConvertUnsignedBinary4(this.data, 1860);
    }

    @Override
    public long tmrbrpac() {
        return Util.ConvertUnsignedBinary4(this.data, 1864);
    }

    @Override
    public long tmrbdcpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1868);
    }

    @Override
    public long tmrbaapc() {
        return Util.ConvertUnsignedBinary4(this.data, 1872);
    }

    @Override
    public long tmrbatpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1876);
    }

    @Override
    public long tmrbapdc() {
        return Util.ConvertUnsignedBinary4(this.data, 1880);
    }

    @Override
    public long tmrbaadc() {
        return Util.ConvertUnsignedBinary4(this.data, 1884);
    }

    @Override
    public long tmrbatcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1888);
    }

    @Override
    public long tmrbarec() {
        return Util.ConvertUnsignedBinary4(this.data, 1892);
    }

    @Override
    public long tmrbadic() {
        return Util.ConvertUnsignedBinary4(this.data, 1896);
    }

    @Override
    public long tmrbatac() {
        return Util.ConvertUnsignedBinary4(this.data, 1900);
    }

    @Override
    public long tmrbatec() {
        return Util.ConvertUnsignedBinary4(this.data, 1904);
    }

    @Override
    public long tmrwbrct() {
        return Util.ConvertUnsignedBinary4(this.data, 1908);
    }

    @Override
    public long tmrwbcin() {
        return Util.ConvertUnsignedBinary4(this.data, 1912);
    }

    @Override
    public long tmrwbsct() {
        return Util.ConvertUnsignedBinary4(this.data, 1916);
    }

    @Override
    public long tmrwbcot() {
        return Util.ConvertUnsignedBinary4(this.data, 1920);
    }

    @Override
    public long tmrwbtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1924);
    }

    @Override
    public long tmrwbrpr() {
        return Util.ConvertUnsignedBinary4(this.data, 1928);
    }

    @Override
    public long tmrwbrpw() {
        return Util.ConvertUnsignedBinary4(this.data, 1932);
    }

    @Override
    public long tmrwberc() {
        return Util.ConvertUnsignedBinary4(this.data, 1936);
    }

    @Override
    public long tmrwbbrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1940);
    }

    @Override
    public long tmrwbrrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1944);
    }

    @Override
    public long tmrwbwrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1948);
    }

    @Override
    public long tmrdhcrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1952);
    }

    @Override
    public long tmrdhinc() {
        return Util.ConvertUnsignedBinary4(this.data, 1956);
    }

    @Override
    public long tmrdhstc() {
        return Util.ConvertUnsignedBinary4(this.data, 1960);
    }

    @Override
    public long tmrdhrtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1964);
    }

    @Override
    public long tmrdhdlc() {
        return Util.ConvertUnsignedBinary4(this.data, 1968);
    }

    @Override
    public long tmrdhtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1972);
    }

    @Override
    public long tmrdhtdl() {
        return Util.ConvertUnsignedBinary4(this.data, 1976);
    }

    @Override
    public long tmrsoben() {
        return Util.ConvertUnsignedBinary4(this.data, 1980);
    }

    @Override
    public long tmrsobde() {
        return Util.ConvertUnsignedBinary4(this.data, 1984);
    }

    @Override
    public long tmrsoerc() {
        return Util.ConvertUnsignedBinary4(this.data, 1988);
    }

    @Override
    public long tmrsocns() {
        return Util.ConvertUnsignedBinary4(this.data, 1992);
    }

    public long tmrsocps() {
        return Util.ConvertUnsignedBinary4(this.data, 1996);
    }

    @Override
    public long tmrsonhw() {
        return Util.ConvertUnsignedBinary4(this.data, 2000);
    }

    public long tmrsophw() {
        return Util.ConvertUnsignedBinary4(this.data, 2004);
    }

    @Override
    public long tmrsorct() {
        return Util.ConvertUnsignedBinary4(this.data, 2008);
    }

    @Override
    public long tmrsocin() {
        return Util.ConvertUnsignedBinary4(this.data, 2012);
    }

    @Override
    public long tmrsosct() {
        return Util.ConvertUnsignedBinary4(this.data, 2016);
    }

    @Override
    public long tmrsocot() {
        return Util.ConvertUnsignedBinary4(this.data, 2020);
    }

    @Override
    public long tmrsotc() {
        return Util.ConvertUnsignedBinary4(this.data, 2024);
    }

    @Override
    public long tmrsoimc() {
        return Util.ConvertUnsignedBinary4(this.data, 2028);
    }

    @Override
    public long tmrsoi1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2032);
    }

    @Override
    public long tmrsoomc() {
        return Util.ConvertUnsignedBinary4(this.data, 2036);
    }

    @Override
    public long tmrsoo1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2040);
    }

    @Override
    public long tmrimsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2044);
    }

    @Override
    public long tmrdb2rc() {
        return Util.ConvertUnsignedBinary4(this.data, 2048);
    }

    @Override
    public long tmrwmqrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2052);
    }

    @Override
    public long tmrtcbac() {
        return Util.ConvertUnsignedBinary4(this.data, 2056);
    }

    @Override
    public long tmrdsthw() {
        return Util.ConvertUnsignedBinary4(this.data, 2060);
    }

    @Override
    public long tmrwbroc() {
        return Util.ConvertUnsignedBinary4(this.data, 2064);
    }

    @Override
    public long tmrwbwoc() {
        return Util.ConvertUnsignedBinary4(this.data, 2068);
    }

    @Override
    public long tmrwbirc() {
        return Util.ConvertUnsignedBinary4(this.data, 2072);
    }

    @Override
    public long tmrwbi1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2076);
    }

    @Override
    public long tmrwbosc() {
        return Util.ConvertUnsignedBinary4(this.data, 2080);
    }

    @Override
    public long tmrwbo1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2084);
    }

    @Override
    public long tmrwbprc() {
        return Util.ConvertUnsignedBinary4(this.data, 2088);
    }

    @Override
    public long tmrwbboc() {
        return Util.ConvertUnsignedBinary4(this.data, 2092);
    }

    @Override
    public long tmrwbiwc() {
        return Util.ConvertUnsignedBinary4(this.data, 2096);
    }

    @Override
    public long tmrwbrdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2100);
    }

    @Override
    public long tmrwbwdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2104);
    }

    @Override
    public long tmrpgctc() {
        return Util.ConvertUnsignedBinary4(this.data, 2108);
    }

    @Override
    public long tmrpgbcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2112);
    }

    @Override
    public long tmrpggcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2116);
    }

    @Override
    public long tmrpgpcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2120);
    }

    @Override
    public long tmrpgmcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2124);
    }

    @Override
    public long tmrpggcl() {
        return Util.ConvertUnsignedBinary4(this.data, 2128);
    }

    @Override
    public long tmrpgpcl() {
        return Util.ConvertUnsignedBinary4(this.data, 2132);
    }

    @Override
    public long tmrpgccc() {
        return Util.ConvertUnsignedBinary4(this.data, 2136);
    }

    @Override
    public long tmrpgcsh() {
        return Util.ConvertUnsignedBinary4(this.data, 2140);
    }

    @Override
    public long tmrisact() {
        return Util.ConvertUnsignedBinary4(this.data, 2144);
    }

    @Override
    public long tmreictc() {
        return Util.ConvertUnsignedBinary4(this.data, 2148);
    }

    @Override
    public long tmrecsge() {
        return Util.ConvertUnsignedBinary4(this.data, 2152);
    }

    @Override
    public long tmrecfoc() {
        return Util.ConvertUnsignedBinary4(this.data, 2156);
    }

    @Override
    public long tmrecevc() {
        return Util.ConvertUnsignedBinary4(this.data, 2160);
    }

    @Override
    public long tmrecsec() {
        return Util.ConvertUnsignedBinary4(this.data, 2164);
    }

    @Override
    public long tmrtiatc() {
        return Util.ConvertUnsignedBinary4(this.data, 2168);
    }

    @Override
    public long tmrtitc() {
        return Util.ConvertUnsignedBinary4(this.data, 2172);
    }

    @Override
    public long tmrbfdgc() {
        return Util.ConvertUnsignedBinary4(this.data, 2176);
    }

    @Override
    public long tmrbftc() {
        return Util.ConvertUnsignedBinary4(this.data, 2180);
    }

    @Override
    public long tmrmltdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2184);
    }

    @Override
    public long tmrmlxtc() {
        return Util.ConvertUnsignedBinary4(this.data, 2188);
    }

    @Override
    public long tmrwscbc() {
        return Util.ConvertUnsignedBinary4(this.data, 2192);
    }

    @Override
    public long tmrwscgc() {
        return Util.ConvertUnsignedBinary4(this.data, 2196);
    }

    @Override
    public long tmrwsepc() {
        return Util.ConvertUnsignedBinary4(this.data, 2200);
    }

    @Override
    public long tmrwsatc() {
        return Util.ConvertUnsignedBinary4(this.data, 2204);
    }

    @Override
    public long tmrwsfcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2208);
    }

    @Override
    public long tmrwsftc() {
        return Util.ConvertUnsignedBinary4(this.data, 2212);
    }

    @Override
    public long tmrwssfc() {
        return Util.ConvertUnsignedBinary4(this.data, 2216);
    }

    @Override
    public long tmrwsqbl() {
        return Util.ConvertUnsignedBinary4(this.data, 2220);
    }

    @Override
    public long tmrwsrbl() {
        return Util.ConvertUnsignedBinary4(this.data, 2224);
    }

    @Override
    public long tmrjsrql() {
        return Util.ConvertUnsignedBinary4(this.data, 2228);
    }

    @Override
    public long tmrjsrpl() {
        return Util.ConvertUnsignedBinary4(this.data, 2232);
    }

    @Override
    public long tmrmpptx() {
        return Util.ConvertUnsignedBinary4(this.data, 2236);
    }

    @Override
    public long tmrncget() {
        return Util.ConvertUnsignedBinary4(this.data, 2240);
    }

    @Override
    public Duration tmrdist() {
        return Util.Binary8StckInterval(this.data, 2244);
    }

    @Override
    public double tmrdistSeconds() {
        return Util.ToSeconds(this.tmrdist());
    }

    @Override
    public long tmrdistRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2244);
    }

    @Override
    public int tmrdistCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2253);
    }

    @Override
    public Duration tmrcput() {
        return Util.Binary8StckInterval(this.data, 2256);
    }

    @Override
    public double tmrcputSeconds() {
        return Util.ToSeconds(this.tmrcput());
    }

    @Override
    public long tmrcputRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2256);
    }

    @Override
    public int tmrcputCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2265);
    }

    @Override
    public Duration tmroncpt() {
        return Util.Binary8StckInterval(this.data, 2268);
    }

    @Override
    public double tmroncptSeconds() {
        return Util.ToSeconds(this.tmroncpt());
    }

    @Override
    public long tmroncptRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2268);
    }

    @Override
    public int tmroncptCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2277);
    }

    @Override
    public Duration tmrofcpt() {
        return Util.Binary8StckInterval(this.data, 2280);
    }

    @Override
    public double tmrofcptSeconds() {
        return Util.ToSeconds(this.tmrofcpt());
    }

    @Override
    public long tmrofcptRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2280);
    }

    @Override
    public int tmrofcptCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2289);
    }

    @Override
    public Duration tmrsust() {
        return Util.Binary8StckInterval(this.data, 2292);
    }

    @Override
    public double tmrsustSeconds() {
        return Util.ToSeconds(this.tmrsust());
    }

    @Override
    public long tmrsustRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2292);
    }

    @Override
    public int tmrsustCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2301);
    }

    @Override
    public Duration tmrdwt() {
        return Util.Binary8StckInterval(this.data, 2304);
    }

    @Override
    public double tmrdwtSeconds() {
        return Util.ToSeconds(this.tmrdwt());
    }

    @Override
    public long tmrdwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2304);
    }

    @Override
    public int tmrdwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2313);
    }

    @Override
    public Duration tmrqrdsp() {
        return Util.Binary8StckInterval(this.data, 2316);
    }

    @Override
    public double tmrqrdspSeconds() {
        return Util.ToSeconds(this.tmrqrdsp());
    }

    @Override
    public long tmrqrdspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2316);
    }

    @Override
    public int tmrqrdspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2325);
    }

    @Override
    public Duration tmrqrcpu() {
        return Util.Binary8StckInterval(this.data, 2328);
    }

    @Override
    public double tmrqrcpuSeconds() {
        return Util.ToSeconds(this.tmrqrcpu());
    }

    @Override
    public long tmrqrcpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2328);
    }

    @Override
    public int tmrqrcpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2337);
    }

    @Override
    public Duration tmrmsdsp() {
        return Util.Binary8StckInterval(this.data, 2340);
    }

    @Override
    public double tmrmsdspSeconds() {
        return Util.ToSeconds(this.tmrmsdsp());
    }

    @Override
    public long tmrmsdspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2340);
    }

    @Override
    public int tmrmsdspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2349);
    }

    @Override
    public Duration tmrmscpu() {
        return Util.Binary8StckInterval(this.data, 2352);
    }

    @Override
    public double tmrmscpuSeconds() {
        return Util.ToSeconds(this.tmrmscpu());
    }

    @Override
    public long tmrmscpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2352);
    }

    @Override
    public int tmrmscpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2361);
    }

    @Override
    public Duration tmrrodsp() {
        return Util.Binary8StckInterval(this.data, 2364);
    }

    @Override
    public double tmrrodspSeconds() {
        return Util.ToSeconds(this.tmrrodsp());
    }

    @Override
    public long tmrrodspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2364);
    }

    @Override
    public int tmrrodspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2373);
    }

    @Override
    public Duration tmrrocpu() {
        return Util.Binary8StckInterval(this.data, 2376);
    }

    @Override
    public double tmrrocpuSeconds() {
        return Util.ToSeconds(this.tmrrocpu());
    }

    @Override
    public long tmrrocpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2376);
    }

    @Override
    public int tmrrocpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2385);
    }

    @Override
    public Duration tmrky8ds() {
        return Util.Binary8StckInterval(this.data, 2388);
    }

    @Override
    public double tmrky8dsSeconds() {
        return Util.ToSeconds(this.tmrky8ds());
    }

    @Override
    public long tmrky8dsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2388);
    }

    @Override
    public int tmrky8dsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2397);
    }

    @Override
    public Duration tmrky8cp() {
        return Util.Binary8StckInterval(this.data, 2400);
    }

    @Override
    public double tmrky8cpSeconds() {
        return Util.ToSeconds(this.tmrky8cp());
    }

    @Override
    public long tmrky8cpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2400);
    }

    @Override
    public int tmrky8cpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2409);
    }

    @Override
    public Duration tmrky9ds() {
        return Util.Binary8StckInterval(this.data, 2412);
    }

    @Override
    public double tmrky9dsSeconds() {
        return Util.ToSeconds(this.tmrky9ds());
    }

    @Override
    public long tmrky9dsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2412);
    }

    @Override
    public int tmrky9dsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2421);
    }

    @Override
    public Duration tmrky9cp() {
        return Util.Binary8StckInterval(this.data, 2424);
    }

    @Override
    public double tmrky9cpSeconds() {
        return Util.ToSeconds(this.tmrky9cp());
    }

    @Override
    public long tmrky9cpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2424);
    }

    @Override
    public int tmrky9cpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2433);
    }

    @Override
    public Duration tmrl8cpu() {
        return Util.Binary8StckInterval(this.data, 2436);
    }

    @Override
    public double tmrl8cpuSeconds() {
        return Util.ToSeconds(this.tmrl8cpu());
    }

    @Override
    public long tmrl8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2436);
    }

    @Override
    public int tmrl8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2445);
    }

    @Override
    public Duration tmrl9cpu() {
        return Util.Binary8StckInterval(this.data, 2448);
    }

    @Override
    public double tmrl9cpuSeconds() {
        return Util.ToSeconds(this.tmrl9cpu());
    }

    @Override
    public long tmrl9cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2448);
    }

    @Override
    public int tmrl9cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2457);
    }

    @Override
    public Duration tmrs8cpu() {
        return Util.Binary8StckInterval(this.data, 2460);
    }

    @Override
    public double tmrs8cpuSeconds() {
        return Util.ToSeconds(this.tmrs8cpu());
    }

    @Override
    public long tmrs8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2460);
    }

    @Override
    public int tmrs8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2469);
    }

    @Override
    public Duration tmrx8cpu() {
        return Util.Binary8StckInterval(this.data, 2472);
    }

    @Override
    public double tmrx8cpuSeconds() {
        return Util.ToSeconds(this.tmrx8cpu());
    }

    @Override
    public long tmrx8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2472);
    }

    @Override
    public int tmrx8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2481);
    }

    @Override
    public Duration tmrx9cpu() {
        return Util.Binary8StckInterval(this.data, 2484);
    }

    @Override
    public double tmrx9cpuSeconds() {
        return Util.ToSeconds(this.tmrx9cpu());
    }

    @Override
    public long tmrx9cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2484);
    }

    @Override
    public int tmrx9cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2493);
    }

    @Override
    public Duration tmrt8cpu() {
        return Util.Binary8StckInterval(this.data, 2496);
    }

    @Override
    public double tmrt8cpuSeconds() {
        return Util.ToSeconds(this.tmrt8cpu());
    }

    @Override
    public long tmrt8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2496);
    }

    @Override
    public int tmrt8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2505);
    }

    @Override
    public Duration tmrqrdly() {
        return Util.Binary8StckInterval(this.data, 2508);
    }

    @Override
    public double tmrqrdlySeconds() {
        return Util.ToSeconds(this.tmrqrdly());
    }

    @Override
    public long tmrqrdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2508);
    }

    @Override
    public int tmrqrdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2517);
    }

    @Override
    public Duration tmrotdly() {
        return Util.Binary8StckInterval(this.data, 2520);
    }

    @Override
    public double tmrotdlySeconds() {
        return Util.ToSeconds(this.tmrotdly());
    }

    @Override
    public long tmrotdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2520);
    }

    @Override
    public int tmrotdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2529);
    }

    @Override
    public Duration tmrxtdly() {
        return Util.Binary8StckInterval(this.data, 2532);
    }

    @Override
    public double tmrxtdlySeconds() {
        return Util.ToSeconds(this.tmrxtdly());
    }

    @Override
    public long tmrxtdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2532);
    }

    @Override
    public int tmrxtdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2541);
    }

    @Override
    public Duration tmrstdly() {
        return Util.Binary8StckInterval(this.data, 2544);
    }

    @Override
    public double tmrstdlySeconds() {
        return Util.ToSeconds(this.tmrstdly());
    }

    @Override
    public long tmrstdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2544);
    }

    @Override
    public int tmrstdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2553);
    }

    @Override
    public Duration tmrttdly() {
        return Util.Binary8StckInterval(this.data, 2556);
    }

    @Override
    public double tmrttdlySeconds() {
        return Util.ToSeconds(this.tmrttdly());
    }

    @Override
    public long tmrttdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2556);
    }

    @Override
    public int tmrttdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2565);
    }

    @Override
    public Duration tmrdsmwt() {
        return Util.Binary8StckInterval(this.data, 2568);
    }

    @Override
    public double tmrdsmwtSeconds() {
        return Util.ToSeconds(this.tmrdsmwt());
    }

    @Override
    public long tmrdsmwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2568);
    }

    @Override
    public int tmrdsmwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2577);
    }

    @Override
    public Duration tmrcmdly() {
        return Util.Binary8StckInterval(this.data, 2580);
    }

    @Override
    public double tmrcmdlySeconds() {
        return Util.ToSeconds(this.tmrcmdly());
    }

    @Override
    public long tmrcmdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2580);
    }

    @Override
    public int tmrcmdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2589);
    }

    @Override
    public Duration tmrexwt() {
        return Util.Binary8StckInterval(this.data, 2592);
    }

    @Override
    public double tmrexwtSeconds() {
        return Util.ToSeconds(this.tmrexwt());
    }

    @Override
    public long tmrexwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2592);
    }

    @Override
    public int tmrexwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2601);
    }

    @Override
    public Duration tmrtcwt() {
        return Util.Binary8StckInterval(this.data, 2604);
    }

    @Override
    public double tmrtcwtSeconds() {
        return Util.ToSeconds(this.tmrtcwt());
    }

    @Override
    public long tmrtcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2604);
    }

    @Override
    public int tmrtcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2613);
    }

    @Override
    public Duration tmrfcwt() {
        return Util.Binary8StckInterval(this.data, 2616);
    }

    @Override
    public double tmrfcwtSeconds() {
        return Util.ToSeconds(this.tmrfcwt());
    }

    @Override
    public long tmrfcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2616);
    }

    @Override
    public int tmrfcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2625);
    }

    @Override
    public Duration tmrfcxwt() {
        return Util.Binary8StckInterval(this.data, 2628);
    }

    @Override
    public double tmrfcxwtSeconds() {
        return Util.ToSeconds(this.tmrfcxwt());
    }

    @Override
    public long tmrfcxwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2628);
    }

    @Override
    public int tmrfcxwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2637);
    }

    @Override
    public Duration tmrfcswt() {
        return Util.Binary8StckInterval(this.data, 2640);
    }

    @Override
    public double tmrfcswtSeconds() {
        return Util.ToSeconds(this.tmrfcswt());
    }

    @Override
    public long tmrfcswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2640);
    }

    @Override
    public int tmrfcswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2649);
    }

    @Override
    public Duration tmrjcwt() {
        return Util.Binary8StckInterval(this.data, 2652);
    }

    @Override
    public double tmrjcwtSeconds() {
        return Util.ToSeconds(this.tmrjcwt());
    }

    @Override
    public long tmrjcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2652);
    }

    @Override
    public int tmrjcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2661);
    }

    @Override
    public Duration tmrtswt() {
        return Util.Binary8StckInterval(this.data, 2664);
    }

    @Override
    public double tmrtswtSeconds() {
        return Util.ToSeconds(this.tmrtswt());
    }

    @Override
    public long tmrtswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2664);
    }

    @Override
    public int tmrtswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2673);
    }

    @Override
    public Duration tmrirwt() {
        return Util.Binary8StckInterval(this.data, 2676);
    }

    @Override
    public double tmrirwtSeconds() {
        return Util.ToSeconds(this.tmrirwt());
    }

    @Override
    public long tmrirwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2676);
    }

    @Override
    public int tmrirwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2685);
    }

    @Override
    public Duration tmrtdwt() {
        return Util.Binary8StckInterval(this.data, 2688);
    }

    @Override
    public double tmrtdwtSeconds() {
        return Util.ToSeconds(this.tmrtdwt());
    }

    @Override
    public long tmrtdwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2688);
    }

    @Override
    public int tmrtdwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2697);
    }

    @Override
    public Duration tmrpclt() {
        return Util.Binary8StckInterval(this.data, 2700);
    }

    @Override
    public double tmrpcltSeconds() {
        return Util.ToSeconds(this.tmrpclt());
    }

    @Override
    public long tmrpcltRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2700);
    }

    @Override
    public int tmrpcltCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2709);
    }

    @Override
    public Duration tmrfddly() {
        return Util.Binary8StckInterval(this.data, 2712);
    }

    @Override
    public double tmrfddlySeconds() {
        return Util.ToSeconds(this.tmrfddly());
    }

    @Override
    public long tmrfddlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2712);
    }

    @Override
    public int tmrfddlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2721);
    }

    @Override
    public Duration tmrfdtcl() {
        return Util.Binary8StckInterval(this.data, 2724);
    }

    @Override
    public double tmrfdtclSeconds() {
        return Util.ToSeconds(this.tmrfdtcl());
    }

    @Override
    public long tmrfdtclRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2724);
    }

    @Override
    public int tmrfdtclCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2733);
    }

    @Override
    public Duration tmrfdmxt() {
        return Util.Binary8StckInterval(this.data, 2736);
    }

    @Override
    public double tmrfdmxtSeconds() {
        return Util.ToSeconds(this.tmrfdmxt());
    }

    @Override
    public long tmrfdmxtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2736);
    }

    @Override
    public int tmrfdmxtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2745);
    }

    @Override
    public Duration tmrnqdly() {
        return Util.Binary8StckInterval(this.data, 2748);
    }

    @Override
    public double tmrnqdlySeconds() {
        return Util.ToSeconds(this.tmrnqdly());
    }

    @Override
    public long tmrnqdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2748);
    }

    @Override
    public int tmrnqdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2757);
    }

    @Override
    public Duration tmrgqdly() {
        return Util.Binary8StckInterval(this.data, 2760);
    }

    @Override
    public double tmrgqdlySeconds() {
        return Util.ToSeconds(this.tmrgqdly());
    }

    @Override
    public long tmrgqdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2760);
    }

    @Override
    public int tmrgqdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2769);
    }

    @Override
    public Duration tmr61wt() {
        return Util.Binary8StckInterval(this.data, 2772);
    }

    @Override
    public double tmr61wtSeconds() {
        return Util.ToSeconds(this.tmr61wt());
    }

    @Override
    public long tmr61wtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2772);
    }

    @Override
    public int tmr61wtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2781);
    }

    @Override
    public Duration tmr62wt() {
        return Util.Binary8StckInterval(this.data, 2784);
    }

    @Override
    public double tmr62wtSeconds() {
        return Util.ToSeconds(this.tmr62wt());
    }

    @Override
    public long tmr62wtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2784);
    }

    @Override
    public int tmr62wtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2793);
    }

    @Override
    public Duration tmrszwt() {
        return Util.Binary8StckInterval(this.data, 2796);
    }

    @Override
    public double tmrszwtSeconds() {
        return Util.ToSeconds(this.tmrszwt());
    }

    @Override
    public long tmrszwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2796);
    }

    @Override
    public int tmrszwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2805);
    }

    @Override
    public Duration tmrrmit() {
        return Util.Binary8StckInterval(this.data, 2808);
    }

    @Override
    public double tmrrmitSeconds() {
        return Util.ToSeconds(this.tmrrmit());
    }

    @Override
    public long tmrrmitRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2808);
    }

    @Override
    public int tmrrmitCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2817);
    }

    @Override
    public Duration tmrrmis() {
        return Util.Binary8StckInterval(this.data, 2820);
    }

    @Override
    public double tmrrmisSeconds() {
        return Util.ToSeconds(this.tmrrmis());
    }

    @Override
    public long tmrrmisRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2820);
    }

    @Override
    public int tmrrmisCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2829);
    }

    @Override
    public Duration tmrsynct() {
        return Util.Binary8StckInterval(this.data, 2832);
    }

    @Override
    public double tmrsynctSeconds() {
        return Util.ToSeconds(this.tmrsynct());
    }

    @Override
    public long tmrsynctRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2832);
    }

    @Override
    public int tmrsynctCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2841);
    }

    @Override
    public Duration tmrrlswt() {
        return Util.Binary8StckInterval(this.data, 2844);
    }

    @Override
    public double tmrrlswtSeconds() {
        return Util.ToSeconds(this.tmrrlswt());
    }

    @Override
    public long tmrrlswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2844);
    }

    @Override
    public int tmrrlswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2853);
    }

    @Override
    public Duration tmrrlscp() {
        return Util.Binary8StckInterval(this.data, 2856);
    }

    @Override
    public double tmrrlscpSeconds() {
        return Util.ToSeconds(this.tmrrlscp());
    }

    @Override
    public long tmrrlscpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2856);
    }

    @Override
    public int tmrrlscpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2865);
    }

    @Override
    public Duration tmrlmdly() {
        return Util.Binary8StckInterval(this.data, 2868);
    }

    @Override
    public double tmrlmdlySeconds() {
        return Util.ToSeconds(this.tmrlmdly());
    }

    @Override
    public long tmrlmdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2868);
    }

    @Override
    public int tmrlmdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2877);
    }

    @Override
    public Duration tmrwtxwt() {
        return Util.Binary8StckInterval(this.data, 2880);
    }

    @Override
    public double tmrwtxwtSeconds() {
        return Util.ToSeconds(this.tmrwtxwt());
    }

    @Override
    public long tmrwtxwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2880);
    }

    @Override
    public int tmrwtxwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2889);
    }

    @Override
    public Duration tmrwcewt() {
        return Util.Binary8StckInterval(this.data, 2892);
    }

    @Override
    public double tmrwcewtSeconds() {
        return Util.ToSeconds(this.tmrwcewt());
    }

    @Override
    public long tmrwcewtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2892);
    }

    @Override
    public int tmrwcewtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2901);
    }

    @Override
    public Duration tmricdly() {
        return Util.Binary8StckInterval(this.data, 2904);
    }

    @Override
    public double tmricdlySeconds() {
        return Util.ToSeconds(this.tmricdly());
    }

    @Override
    public long tmricdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2904);
    }

    @Override
    public int tmricdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2913);
    }

    @Override
    public Duration tmrgvpwt() {
        return Util.Binary8StckInterval(this.data, 2916);
    }

    @Override
    public double tmrgvpwtSeconds() {
        return Util.ToSeconds(this.tmrgvpwt());
    }

    @Override
    public long tmrgvpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2916);
    }

    @Override
    public int tmrgvpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2925);
    }

    @Override
    public Duration tmrtshwt() {
        return Util.Binary8StckInterval(this.data, 2928);
    }

    @Override
    public double tmrtshwtSeconds() {
        return Util.ToSeconds(this.tmrtshwt());
    }

    @Override
    public long tmrtshwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2928);
    }

    @Override
    public int tmrtshwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2937);
    }

    @Override
    public Duration tmrcdtwt() {
        return Util.Binary8StckInterval(this.data, 2940);
    }

    @Override
    public double tmrcdtwtSeconds() {
        return Util.ToSeconds(this.tmrcdtwt());
    }

    @Override
    public long tmrcdtwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2940);
    }

    @Override
    public int tmrcdtwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2949);
    }

    @Override
    public Duration tmrsywtt() {
        return Util.Binary8StckInterval(this.data, 2952);
    }

    @Override
    public double tmrsywttSeconds() {
        return Util.ToSeconds(this.tmrsywtt());
    }

    @Override
    public long tmrsywttRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2952);
    }

    @Override
    public int tmrsywttCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2961);
    }

    @Override
    public Duration tmrrrswt() {
        return Util.Binary8StckInterval(this.data, 2964);
    }

    @Override
    public double tmrrrswtSeconds() {
        return Util.ToSeconds(this.tmrrrswt());
    }

    @Override
    public long tmrrrswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2964);
    }

    @Override
    public int tmrrrswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2973);
    }

    @Override
    public Duration tmrrtrwt() {
        return Util.Binary8StckInterval(this.data, 2976);
    }

    @Override
    public double tmrrtrwtSeconds() {
        return Util.ToSeconds(this.tmrrtrwt());
    }

    @Override
    public long tmrrtrwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2976);
    }

    @Override
    public int tmrrtrwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2985);
    }

    @Override
    public Duration tmrsydly() {
        return Util.Binary8StckInterval(this.data, 2988);
    }

    @Override
    public double tmrsydlySeconds() {
        return Util.ToSeconds(this.tmrsydly());
    }

    @Override
    public long tmrsydlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2988);
    }

    @Override
    public int tmrsydlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2997);
    }

    @Override
    public Duration tmrsowt() {
        return Util.Binary8StckInterval(this.data, 3000);
    }

    @Override
    public double tmrsowtSeconds() {
        return Util.ToSeconds(this.tmrsowt());
    }

    @Override
    public long tmrsowtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3000);
    }

    @Override
    public int tmrsowtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3009);
    }

    @Override
    public Duration tmrimswt() {
        return Util.Binary8StckInterval(this.data, 3012);
    }

    @Override
    public double tmrimswtSeconds() {
        return Util.ToSeconds(this.tmrimswt());
    }

    @Override
    public long tmrimswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3012);
    }

    @Override
    public int tmrimswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3021);
    }

    @Override
    public Duration tmrrdqwt() {
        return Util.Binary8StckInterval(this.data, 3024);
    }

    @Override
    public double tmrrdqwtSeconds() {
        return Util.ToSeconds(this.tmrrdqwt());
    }

    @Override
    public long tmrrdqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3024);
    }

    @Override
    public int tmrrdqwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3033);
    }

    @Override
    public Duration tmrconwt() {
        return Util.Binary8StckInterval(this.data, 3036);
    }

    @Override
    public double tmrconwtSeconds() {
        return Util.ToSeconds(this.tmrconwt());
    }

    @Override
    public long tmrconwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3036);
    }

    @Override
    public int tmrconwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3045);
    }

    @Override
    public Duration tmrmqgwt() {
        return Util.Binary8StckInterval(this.data, 3048);
    }

    @Override
    public double tmrmqgwtSeconds() {
        return Util.ToSeconds(this.tmrmqgwt());
    }

    @Override
    public long tmrmqgwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3048);
    }

    @Override
    public int tmrmqgwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3057);
    }

    @Override
    public Duration tmrjvmt() {
        return Util.Binary8StckInterval(this.data, 3060);
    }

    @Override
    public double tmrjvmtSeconds() {
        return Util.ToSeconds(this.tmrjvmt());
    }

    @Override
    public long tmrjvmtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3060);
    }

    @Override
    public int tmrjvmtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3069);
    }

    @Override
    public Duration tmrjvms() {
        return Util.Binary8StckInterval(this.data, 3072);
    }

    @Override
    public double tmrjvmsSeconds() {
        return Util.ToSeconds(this.tmrjvms());
    }

    @Override
    public long tmrjvmsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3072);
    }

    @Override
    public int tmrjvmsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3081);
    }

    @Override
    public Duration tmrsoowt() {
        return Util.Binary8StckInterval(this.data, 3084);
    }

    @Override
    public double tmrsoowtSeconds() {
        return Util.ToSeconds(this.tmrsoowt());
    }

    @Override
    public long tmrsoowtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3084);
    }

    @Override
    public int tmrsoowtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3093);
    }

    @Override
    public Duration tmrrqrwt() {
        return Util.Binary8StckInterval(this.data, 3096);
    }

    @Override
    public double tmrrqrwtSeconds() {
        return Util.ToSeconds(this.tmrrqrwt());
    }

    @Override
    public long tmrrqrwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3096);
    }

    @Override
    public int tmrrqrwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3105);
    }

    @Override
    public Duration tmrrqpwt() {
        return Util.Binary8StckInterval(this.data, 3108);
    }

    @Override
    public double tmrrqpwtSeconds() {
        return Util.ToSeconds(this.tmrrqpwt());
    }

    @Override
    public long tmrrqpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3108);
    }

    @Override
    public int tmrrqpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3117);
    }

    @Override
    public Duration tmroidwt() {
        return Util.Binary8StckInterval(this.data, 3120);
    }

    @Override
    public double tmroidwtSeconds() {
        return Util.ToSeconds(this.tmroidwt());
    }

    @Override
    public long tmroidwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3120);
    }

    @Override
    public int tmroidwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3129);
    }

    @Override
    public Duration tmrjvmit() {
        return Util.Binary8StckInterval(this.data, 3132);
    }

    @Override
    public double tmrjvmitSeconds() {
        return Util.ToSeconds(this.tmrjvmit());
    }

    @Override
    public long tmrjvmitRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3132);
    }

    @Override
    public int tmrjvmitCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3141);
    }

    @Override
    public Duration tmrjvmrt() {
        return Util.Binary8StckInterval(this.data, 3144);
    }

    @Override
    public double tmrjvmrtSeconds() {
        return Util.ToSeconds(this.tmrjvmrt());
    }

    @Override
    public long tmrjvmrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3144);
    }

    @Override
    public int tmrjvmrtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3153);
    }

    @Override
    public Duration tmrptpwt() {
        return Util.Binary8StckInterval(this.data, 3156);
    }

    @Override
    public double tmrptpwtSeconds() {
        return Util.ToSeconds(this.tmrptpwt());
    }

    @Override
    public long tmrptpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3156);
    }

    @Override
    public int tmrptpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3165);
    }

    @Override
    public Duration tmrdscwt() {
        return Util.Binary8StckInterval(this.data, 3168);
    }

    @Override
    public double tmrdscwtSeconds() {
        return Util.ToSeconds(this.tmrdscwt());
    }

    @Override
    public long tmrdscwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3168);
    }

    @Override
    public int tmrdscwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3177);
    }

    @Override
    public Duration tmriswt() {
        return Util.Binary8StckInterval(this.data, 3180);
    }

    @Override
    public double tmriswtSeconds() {
        return Util.ToSeconds(this.tmriswt());
    }

    @Override
    public long tmriswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3180);
    }

    @Override
    public int tmriswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3189);
    }

    @Override
    public Duration tmrjstwt() {
        return Util.Binary8StckInterval(this.data, 3192);
    }

    @Override
    public double tmrjstwtSeconds() {
        return Util.ToSeconds(this.tmrjstwt());
    }

    @Override
    public long tmrjstwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3192);
    }

    @Override
    public int tmrjstwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3201);
    }

    @Override
    public Duration tmrmqast() {
        return Util.Binary8StckInterval(this.data, 3204);
    }

    @Override
    public double tmrmqastSeconds() {
        return Util.ToSeconds(this.tmrmqast());
    }

    @Override
    public long tmrmqastRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3204);
    }

    @Override
    public int tmrmqastCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3213);
    }

    @Override
    public Duration tmrtdilw() {
        return Util.Binary8StckInterval(this.data, 3216);
    }

    @Override
    public double tmrtdilwSeconds() {
        return Util.ToSeconds(this.tmrtdilw());
    }

    @Override
    public long tmrtdilwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3216);
    }

    @Override
    public int tmrtdilwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3225);
    }

    @Override
    public Duration tmrtdelw() {
        return Util.Binary8StckInterval(this.data, 3228);
    }

    @Override
    public double tmrtdelwSeconds() {
        return Util.ToSeconds(this.tmrtdelw());
    }

    @Override
    public long tmrtdelwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3228);
    }

    @Override
    public int tmrtdelwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3237);
    }

    @Override
    public Duration tmrrodly() {
        return Util.Binary8StckInterval(this.data, 3240);
    }

    @Override
    public double tmrrodlySeconds() {
        return Util.ToSeconds(this.tmrrodly());
    }

    @Override
    public long tmrrodlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3240);
    }

    @Override
    public int tmrrodlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3249);
    }

    @Override
    public Duration tmrsodly() {
        return Util.Binary8StckInterval(this.data, 3252);
    }

    @Override
    public double tmrsodlySeconds() {
        return Util.ToSeconds(this.tmrsodly());
    }

    @Override
    public long tmrsodlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3252);
    }

    @Override
    public int tmrsodlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3261);
    }

    @Override
    public Duration tmrisawt() {
        return Util.Binary8StckInterval(this.data, 3264);
    }

    @Override
    public double tmrisawtSeconds() {
        return Util.ToSeconds(this.tmrisawt());
    }

    @Override
    public long tmrisawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3264);
    }

    @Override
    public int tmrisawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3273);
    }

    @Override
    public Duration tmrtcawt() {
        return Util.Binary8StckInterval(this.data, 3276);
    }

    @Override
    public double tmrtcawtSeconds() {
        return Util.ToSeconds(this.tmrtcawt());
    }

    @Override
    public long tmrtcawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3276);
    }

    @Override
    public int tmrtcawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3285);
    }

    @Override
    public Duration tmrdsawt() {
        return Util.Binary8StckInterval(this.data, 3288);
    }

    @Override
    public double tmrdsawtSeconds() {
        return Util.ToSeconds(this.tmrdsawt());
    }

    @Override
    public long tmrdsawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3288);
    }

    @Override
    public int tmrdsawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3297);
    }

    public static MonitoringTransactionStatistics create(byte[] Data2, int offset, int length) {
        return new MonitoringTransactionStatistics(Data2, offset, length);
    }

    @Override
    public String tmrlparn() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public LocalDateTime tmrptatt() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public BigInteger tmrptattRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrpttsn() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public String tmrpttid() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrptcnt() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrastc() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrasrnc() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrasftc() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrasfrc() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrmpsre() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrmpsra() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrasfwt() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrasfwtSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrasfwtRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrasfwtCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrasrwt() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrasrwtSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrasrwtRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrasrwtCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public String tmrnjapn() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public String tmrsocnm() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmruriop() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmruriopSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmruriopRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmruriopCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrurirc() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrurircSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrurircRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrurircCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrurisn() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrurisnSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrurisnRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrurisnCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrwsinv() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrwsinvSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrwsinvRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrwsinvCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrxsvpw() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrxsvpwSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsvpwRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrxsvpwCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrxsvke() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrxsvkeSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsvkeRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrxsvkeCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrxsvba() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrxsvbaSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsvbaRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrxsvbaCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrxsvjw() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrxsvjwSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsvjwRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrxsvjwCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public Duration tmrsmmwt() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public double tmrsmmwtSeconds() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrsmmwtRawValue() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public int tmrsmmwtCount() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public String tmrsoflg() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public String tmrsotlv() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrttsks() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsnla() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    @Override
    public long tmrxsnlf() {
        throw new NotAvailableException("Not available in CICS 5.3");
    }

    static enum Field {
        mntlen(0, 2),
        mntid(2, 2),
        mntdvers(4, 1),
        tmrtrid(8, 4),
        tmrteid(12, 4),
        tmrusid(16, 8),
        tmrtrty(24, 4),
        tmrattt(28, 8),
        tmrdett(36, 8),
        tmrtrsn(44, 4),
        tmrtpri(48, 4),
        tmrtclsn(52, 8),
        tmrlunm(60, 8),
        tmrpgnm(68, 8),
        tmrnetpx(76, 20),
        tmrnetsx(96, 8),
        tmrrsys(104, 4),
        tmrprcnt(108, 4),
        tmrrmuow(112, 8),
        tmrsrvcl(120, 8),
        tmrrptcl(128, 8),
        tmrfcty(136, 4),
        tmrtrfl1(140, 1),
        tmrtrfl2(141, 1),
        tmrtrfl3(142, 1),
        tmrtrfl4(143, 1),
        tmrtrfl5(144, 1),
        tmrtrfl6(145, 1),
        tmrtrfl7(146, 1),
        tmrtrfl8(147, 1),
        tmrnatur(148, 1),
        tmrsesst(149, 1),
        tmracmth(150, 1),
        tmrdvtcd(151, 1),
        tmrtecnm(152, 4),
        tmrbtrid(156, 4),
        tmrurid(160, 16),
        tmrpname(176, 36),
        tmrptype(212, 8),
        tmrprcid(220, 52),
        tmractid(272, 52),
        tmractnm(324, 16),
        tmrcipad(340, 40),
        tmrtgpid(380, 28),
        tmrnetid(408, 8),
        tmrrlunm(416, 8),
        tmrtcpsv(424, 8),
        tmrportn(432, 4),
        tmrotsid(436, 128),
        tmrcipor(564, 4),
        tmriscnm(568, 8),
        tmronwid(576, 8),
        tmroapid(584, 8),
        tmroattt(592, 8),
        tmrotrsn(600, 4),
        tmrotrid(604, 4),
        tmrousid(608, 8),
        tmrousrc(616, 64),
        tmrotcps(680, 8),
        tmroprtn(688, 4),
        tmrocipa(692, 40),
        tmrocpno(732, 4),
        tmrotrfg(736, 8),
        tmrofcty(744, 8),
        tmrurimn(752, 8),
        tmrpipln(760, 8),
        tmratmsn(768, 8),
        tmrwsvcn(776, 32),
        tmrwsopn(808, 64),
        tmrwpbmn(872, 8),
        tmrphnwd(880, 8),
        tmrphapl(888, 8),
        tmrphatt(896, 8),
        tmrphtsn(904, 4),
        tmrphtid(908, 4),
        tmrphcnt(912, 4),
        tmradpid(916, 64),
        tmradpd1(980, 64),
        tmradpd2(1044, 64),
        tmradpd3(1108, 64),
        tmrsocph(1172, 4),
        tmrcectp(1176, 4),
        tmrcecid(1180, 16),
        tmrmtsks(1196, 4),
        tmrctsks(1200, 4),
        tmrappln(1204, 64),
        tmrplatn(1268, 64),
        tmrmajvr(1332, 4),
        tmrminvr(1336, 4),
        tmrmicvr(1340, 4),
        tmropern(1344, 64),
        tmrerror(1408, 4),
        tmrabcdo(1412, 4),
        tmrabcdc(1416, 4),
        tmrtype(1420, 4),
        tmrpinmc(1424, 4),
        tmrtci1c(1428, 4),
        tmrpoumc(1432, 4),
        tmrtco1c(1436, 4),
        tmrsinmc(1440, 4),
        tmrtci2c(1444, 4),
        tmrsoumc(1448, 4),
        tmrtco2c(1452, 4),
        tmr62imc(1456, 4),
        tmr62ich(1460, 4),
        tmr62omc(1464, 4),
        tmr62och(1468, 4),
        tmrtac(1472, 4),
        tmrscugb(1476, 4),
        tmrscuga(1480, 4),
        tmrsccgb(1484, 4),
        tmrsccga(1488, 4),
        tmrushwb(1492, 4),
        tmrushwa(1496, 4),
        tmrchwmb(1500, 4),
        tmrchwma(1504, 4),
        tmrutsob(1508, 8),
        tmrutsoa(1516, 8),
        tmrcoccb(1524, 8),
        tmrcocca(1532, 8),
        tmrsc24s(1540, 4),
        tmrsc24g(1544, 4),
        tmrsc24f(1548, 4),
        tmrsc31s(1552, 4),
        tmrsc31g(1556, 4),
        tmrsc31f(1560, 4),
        tmrsccgg(1564, 4),
        tmrchwmg(1568, 4),
        tmrscugg(1572, 4),
        tmruhwmg(1576, 4),
        tmrsc64s(1580, 4),
        tmrsc64g(1584, 4),
        tmrsc64f(1588, 4),
        tmrpcuse(1592, 4),
        tmrpc31a(1596, 4),
        tmrpcusb(1600, 4),
        tmrpccah(1604, 4),
        tmrpccbh(1608, 4),
        tmrpcrah(1612, 4),
        tmrpcrbh(1616, 4),
        tmrpcsah(1620, 4),
        tmrpcsbh(1624, 4),
        tmrfcgc(1628, 4),
        tmrfcpc(1632, 4),
        tmrfcbc(1636, 4),
        tmrfcac(1640, 4),
        tmrfcdc(1644, 4),
        tmrfctc(1648, 4),
        tmrfcamc(1652, 4),
        tmrtdgc(1656, 4),
        tmrtdpc(1660, 4),
        tmrtdrc(1664, 4),
        tmrtdtc(1668, 4),
        tmrtsgc(1672, 4),
        tmrtspac(1676, 4),
        tmrtspmc(1680, 4),
        tmrtsgsc(1684, 4),
        tmrtspsc(1688, 4),
        tmrtstc(1692, 4),
        tmrbmmc(1696, 4),
        tmrbmic(1700, 4),
        tmrbmoc(1704, 4),
        tmrbmtc(1708, 4),
        tmrpclic(1712, 4),
        tmrpcxc(1716, 4),
        tmrpcloc(1720, 4),
        tmrpcluc(1724, 4),
        tmrpcdpl(1728, 4),
        tmrpcdll(1732, 4),
        tmrpcdrl(1736, 4),
        tmrpclcc(1740, 4),
        tmrpcxcc(1744, 4),
        tmrpcdcc(1748, 4),
        tmrpcrcc(1752, 4),
        tmrpcrcl(1756, 4),
        tmrjnlct(1760, 4),
        tmrlgwct(1764, 4),
        tmricc(1768, 4),
        tmrictc(1772, 4),
        tmricscc(1776, 4),
        tmricscd(1780, 4),
        tmricsrc(1784, 4),
        tmricsrd(1788, 4),
        tmrsppc(1792, 4),
        tmrcfact(1796, 4),
        tmrszact(1800, 4),
        tmrszrct(1804, 4),
        tmrszsct(1808, 4),
        tmrsztct(1812, 4),
        tmrszcot(1816, 4),
        tmrszcin(1820, 4),
        tmrszato(1824, 4),
        tmrszrto(1828, 4),
        tmrsztot(1832, 4),
        tmrbarsc(1836, 4),
        tmrbarac(1840, 4),
        tmrbalkc(1844, 4),
        tmrbadpc(1848, 4),
        tmrbadac(1852, 4),
        tmrbtpac(1856, 4),
        tmrbspac(1860, 4),
        tmrbrpac(1864, 4),
        tmrbdcpc(1868, 4),
        tmrbaapc(1872, 4),
        tmrbatpc(1876, 4),
        tmrbapdc(1880, 4),
        tmrbaadc(1884, 4),
        tmrbatcc(1888, 4),
        tmrbarec(1892, 4),
        tmrbadic(1896, 4),
        tmrbatac(1900, 4),
        tmrbatec(1904, 4),
        tmrwbrct(1908, 4),
        tmrwbcin(1912, 4),
        tmrwbsct(1916, 4),
        tmrwbcot(1920, 4),
        tmrwbtc(1924, 4),
        tmrwbrpr(1928, 4),
        tmrwbrpw(1932, 4),
        tmrwberc(1936, 4),
        tmrwbbrc(1940, 4),
        tmrwbrrc(1944, 4),
        tmrwbwrc(1948, 4),
        tmrdhcrc(1952, 4),
        tmrdhinc(1956, 4),
        tmrdhstc(1960, 4),
        tmrdhrtc(1964, 4),
        tmrdhdlc(1968, 4),
        tmrdhtc(1972, 4),
        tmrdhtdl(1976, 4),
        tmrsoben(1980, 4),
        tmrsobde(1984, 4),
        tmrsoerc(1988, 4),
        tmrsocns(1992, 4),
        tmrsocps(1996, 4),
        tmrsonhw(2000, 4),
        tmrsophw(2004, 4),
        tmrsorct(2008, 4),
        tmrsocin(2012, 4),
        tmrsosct(2016, 4),
        tmrsocot(2020, 4),
        tmrsotc(2024, 4),
        tmrsoimc(2028, 4),
        tmrsoi1c(2032, 4),
        tmrsoomc(2036, 4),
        tmrsoo1c(2040, 4),
        tmrimsrc(2044, 4),
        tmrdb2rc(2048, 4),
        tmrwmqrc(2052, 4),
        tmrtcbac(2056, 4),
        tmrdsthw(2060, 4),
        tmrwbroc(2064, 4),
        tmrwbwoc(2068, 4),
        tmrwbirc(2072, 4),
        tmrwbi1c(2076, 4),
        tmrwbosc(2080, 4),
        tmrwbo1c(2084, 4),
        tmrwbprc(2088, 4),
        tmrwbboc(2092, 4),
        tmrwbiwc(2096, 4),
        tmrwbrdl(2100, 4),
        tmrwbwdl(2104, 4),
        tmrpgctc(2108, 4),
        tmrpgbcc(2112, 4),
        tmrpggcc(2116, 4),
        tmrpgpcc(2120, 4),
        tmrpgmcc(2124, 4),
        tmrpggcl(2128, 4),
        tmrpgpcl(2132, 4),
        tmrpgccc(2136, 4),
        tmrpgcsh(2140, 4),
        tmrisact(2144, 4),
        tmreictc(2148, 4),
        tmrecsge(2152, 4),
        tmrecfoc(2156, 4),
        tmrecevc(2160, 4),
        tmrecsec(2164, 4),
        tmrtiatc(2168, 4),
        tmrtitc(2172, 4),
        tmrbfdgc(2176, 4),
        tmrbftc(2180, 4),
        tmrmltdl(2184, 4),
        tmrmlxtc(2188, 4),
        tmrwscbc(2192, 4),
        tmrwscgc(2196, 4),
        tmrwsepc(2200, 4),
        tmrwsatc(2204, 4),
        tmrwsfcc(2208, 4),
        tmrwsftc(2212, 4),
        tmrwssfc(2216, 4),
        tmrwsqbl(2220, 4),
        tmrwsrbl(2224, 4),
        tmrjsrql(2228, 4),
        tmrjsrpl(2232, 4),
        tmrmpptx(2236, 4),
        tmrncget(2240, 4),
        tmrdist(2244, 12),
        tmrcput(2256, 12),
        tmroncpt(2268, 12),
        tmrofcpt(2280, 12),
        tmrsust(2292, 12),
        tmrdwt(2304, 12),
        tmrqrdsp(2316, 12),
        tmrqrcpu(2328, 12),
        tmrmsdsp(2340, 12),
        tmrmscpu(2352, 12),
        tmrrodsp(2364, 12),
        tmrrocpu(2376, 12),
        tmrky8ds(2388, 12),
        tmrky8cp(2400, 12),
        tmrky9ds(2412, 12),
        tmrky9cp(2424, 12),
        tmrl8cpu(2436, 12),
        tmrl9cpu(2448, 12),
        tmrs8cpu(2460, 12),
        tmrx8cpu(2472, 12),
        tmrx9cpu(2484, 12),
        tmrt8cpu(2496, 12),
        tmrqrdly(2508, 12),
        tmrotdly(2520, 12),
        tmrxtdly(2532, 12),
        tmrstdly(2544, 12),
        tmrttdly(2556, 12),
        tmrdsmwt(2568, 12),
        tmrcmdly(2580, 12),
        tmrexwt(2592, 12),
        tmrtcwt(2604, 12),
        tmrfcwt(2616, 12),
        tmrfcxwt(2628, 12),
        tmrfcswt(2640, 12),
        tmrjcwt(2652, 12),
        tmrtswt(2664, 12),
        tmrirwt(2676, 12),
        tmrtdwt(2688, 12),
        tmrpclt(2700, 12),
        tmrfddly(2712, 12),
        tmrfdtcl(2724, 12),
        tmrfdmxt(2736, 12),
        tmrnqdly(2748, 12),
        tmrgqdly(2760, 12),
        tmr61wt(2772, 12),
        tmr62wt(2784, 12),
        tmrszwt(2796, 12),
        tmrrmit(2808, 12),
        tmrrmis(2820, 12),
        tmrsynct(2832, 12),
        tmrrlswt(2844, 12),
        tmrrlscp(2856, 12),
        tmrlmdly(2868, 12),
        tmrwtxwt(2880, 12),
        tmrwcewt(2892, 12),
        tmricdly(2904, 12),
        tmrgvpwt(2916, 12),
        tmrtshwt(2928, 12),
        tmrcdtwt(2940, 12),
        tmrsywtt(2952, 12),
        tmrrrswt(2964, 12),
        tmrrtrwt(2976, 12),
        tmrsydly(2988, 12),
        tmrsowt(3000, 12),
        tmrimswt(3012, 12),
        tmrrdqwt(3024, 12),
        tmrconwt(3036, 12),
        tmrmqgwt(3048, 12),
        tmrjvmt(3060, 12),
        tmrjvms(3072, 12),
        tmrsoowt(3084, 12),
        tmrrqrwt(3096, 12),
        tmrrqpwt(3108, 12),
        tmroidwt(3120, 12),
        tmrjvmit(3132, 12),
        tmrjvmrt(3144, 12),
        tmrptpwt(3156, 12),
        tmrdscwt(3168, 12),
        tmriswt(3180, 12),
        tmrjstwt(3192, 12),
        tmrmqast(3204, 12),
        tmrtdilw(3216, 12),
        tmrtdelw(3228, 12),
        tmrrodly(3240, 12),
        tmrsodly(3252, 12),
        tmrisawt(3264, 12),
        tmrtcawt(3276, 12),
        tmrdsawt(3288, 12);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

