/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum DataLoc {
    NA(0),
    BELOW(1),
    ANY(2),
    NOT_DEFINED(-16);

    private static Map<Integer, DataLoc> valueMap;
    private final int pgdprogramdataloc;

    private DataLoc(int pgdprogramdataloc) {
        this.pgdprogramdataloc = pgdprogramdataloc;
    }

    public static DataLoc from(int value) {
        DataLoc result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int pgdprogramdataloc() {
        return this.pgdprogramdataloc;
    }

    static {
        valueMap = new HashMap<Integer, DataLoc>();
        for (DataLoc x : DataLoc.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.pgdprogramdataloc, x);
        }
    }
}

