/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum IpFamily {
    UNKNOWN(0),
    IPV4(1),
    IPV6(2),
    NOT_DEFINED(-16);

    private static Map<Integer, IpFamily> valueMap;
    private final int ejripfamily;

    private IpFamily(int ejripfamily) {
        this.ejripfamily = ejripfamily;
    }

    public static IpFamily from(int value) {
        IpFamily result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int ejripfamily() {
        return this.ejripfamily;
    }

    static {
        valueMap = new HashMap<Integer, IpFamily>();
        for (IpFamily x : IpFamily.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.ejripfamily, x);
        }
    }
}

