/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum SmsAccess {
    CICS(1),
    USER(2),
    READONLY(3),
    TRUSTED(4),
    NOT_DEFINED(-16);

    private static Map<Integer, SmsAccess> valueMap;
    private final int smsaccess;

    private SmsAccess(int smsaccess) {
        this.smsaccess = smsaccess;
    }

    public static SmsAccess from(int value) {
        SmsAccess result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int smsaccess() {
        return this.smsaccess;
    }

    static {
        valueMap = new HashMap<Integer, SmsAccess>();
        for (SmsAccess x : SmsAccess.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.smsaccess, x);
        }
    }
}

