/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.counterid;

import java.util.HashMap;
import java.util.Map;

public enum CryptoCounters {
    KM_DEA(1),
    KM_TDEA_128(2),
    KM_TDEA_192(3),
    KM_Encrypted_DEA(4),
    KM_Encrypted_TDEA_128(5),
    KM_Encrypted_TDEA_192(6),
    KM_AES_128(7),
    KM_AES_192(8),
    KM_AES_256(9),
    KM_Encrypted_AES_128(10),
    KM_Encrypted_AES_192(11),
    KM_Encrypted_AES_256(12),
    KM_XTS_AES_128(13),
    KM_XTS_AES_256(14),
    KM_XTS_Encrypted_AES_128(15),
    KM_XTS_Encrypted_AES_256(16),
    KMC_DEA(17),
    KMC_TDEA_128(18),
    KMC_TDEA_192(19),
    KMC_Encrypted_DEA(20),
    KMC_Encrypted_TDEA_128(21),
    KMC_Encrypted_TDEA_192(22),
    KMC_AES_128(23),
    KMC_AES_192(24),
    KMC_AES_256(25),
    KMC_Encrypted_AES_128(26),
    KMC_Encrypted_AES_192(27),
    KMC_Encrypted_AES_256(28),
    KMC_PRNG(29),
    KMA_GCM_AES_128(30),
    KMA_GCM_AES_192(31),
    KMA_GCM_AES_256(32),
    KMA_GCM_Enc_AES_128(33),
    KMA_GCM_Enc_AES_192(34),
    KMA_GCM_Enc_AES_256(35),
    KMF_DEA(36),
    KMF_TDEA_128(37),
    KMF_TDEA_192(38),
    KMF_Encrypted_DEA(39),
    KMF_Encrypted_TDEA_128(40),
    KMF_Encrypted_TDEA_192(41),
    KMF_AES_128(42),
    KMF_AES_192(43),
    KMF_AES_256(44),
    KMF_Encrypted_AES_128(45),
    KMF_Encrypted_AES_192(46),
    KMF_Encrypted_AES_256(47),
    KMCTR_DEA(48),
    KMCTR_TDEA_128(49),
    KMCTR_TDEA_192(50),
    KMCTR_Encrypted_DEA(51),
    KMCTR_Encrypted_TDEA_128(52),
    KMCTR_Encrypted_TDEA_192(53),
    KMCTR_AES_128(54),
    KMCTR_AES_192(55),
    KMCTR_AES_256(56),
    KMCTR_Encrypted_AES_128(57),
    KMCTR_Encrypted_AES_192(58),
    KMCTR_Encrypted_AES_256(59),
    KMO_DEA(60),
    KMO_TDEA_128(61),
    KMO_TDEA_192(62),
    KMO_Encrypted_DEA(63),
    KMO_Encrypted_TDEA_128(64),
    KMO_Encrypted_TDEA_192(65),
    KMO_AES_128(66),
    KMO_AES_192(67),
    KMO_AES_256(68),
    KMO_Encrypted_AES_128(69),
    KMO_Encrypted_AES_192(70),
    KMO_Encrypted_AES_256(71),
    KIMD_SHA_1(72),
    KIMD_SHA_256(73),
    KIMD_SHA_512(74),
    KIMD_SHA3_224(75),
    KIMD_SHA3_256(76),
    KIMD_SHA3_384(77),
    KIMD_SHA3_512(78),
    KIMD_SHAKE_128(79),
    KIMD_SHAKE_256(80),
    KIMD_GHASH(81),
    KLMD_SHA_1(82),
    KLMD_SHA_256(83),
    KLMD_SHA_512(84),
    KLMD_SHA3_224(85),
    KLMD_SHA3_256(86),
    KLMD_SHA3_384(87),
    KLMD_SHA3_512(88),
    KLMD_SHAKE_128(89),
    KLMD_SHAKE_256(90),
    KMAC_DEA(91),
    KMAC_TDEA_128(92),
    KMAC_TDEA_192(93),
    KMAC_Encrypted_DEA(94),
    KMAC_Encrypted_TDEA_128(95),
    KMAC_Encrypted_TDEA_192(96),
    KMAC_AES_128(97),
    KMAC_AES_192(98),
    KMAC_AES_256(99),
    KMAC_Encrypted_AES_128(100),
    KMAC_Encrypted_AES_192(101),
    KMAC_Encrypted_AES_256(102),
    PCC_CLB_CMAC_Using_DEA(103),
    PCC_CLB_CMAC_TDEA_128(104),
    PCC_CLB_CMAC_TDEA_192(105),
    PCC_CLB_CMAC_E_DEA(106),
    PCC_CLB_CMAC_E_TDEA_128(107),
    PCC_CLB_CMAC_E_TDEA_192(108),
    PCC_CLB_CMAC_AES_128(109),
    PCC_CLB_CMAC_AES_192(110),
    PCC_CLB_CMAC_AES_256(111),
    PCC_CLB_CMAC_E_AES_128(112),
    PCC_CLB_CMAC_E_AES_192(113),
    PCC_CLB_CMAC_E_AES_256A(114),
    PCC_C_XTS_Parm_AES_128(115),
    PCC_C_XTS_Parm_AES_256(116),
    PCC_C_XTS_EParm_AES_128(117),
    PCC_C_XTS_EParm_AES_256(118),
    PCC_Scalar_Mult_P256(119),
    PCC_Scalar_Mult_P384(120),
    PCC_Scalar_Mult_P521(121),
    PCC_Scalar_Mult_Ed25519(122),
    PCC_Scalar_Mult_Ed448(123),
    PCC_Scalar_Mult_X25519(124),
    PCC_Scalar_Mult_X448(125),
    PRNO_SHA_512_DRNG(126),
    PRNO_TRNG_QRTC_Ratio(127),
    PRNO_TRNG(128),
    KDSA_ECDSA_Verify_P256(129),
    KDSA_ECDSA_Verify_P384(130),
    KDSA_ECDSA_Verify_P521(131),
    KDSA_ECDSA_Sign_P256(132),
    KDSA_ECDSA_Sign_P384(133),
    KDSA_ECDSA_Sign_P521(134),
    KDSA_Enc_ECDSA_Sign_P256(135),
    KDSA_Enc_ECDSA_Sign_P384(136),
    KDSA_Enc_ECDSA_Sign_P521(137),
    KDSA_EdDSA_Ver_Ed25519(138),
    KDSA_EdDSA_Ver_Ed448(139),
    KDSA_EdDSA_Sign_Ed25519(140),
    KDSA_EdDSA_Sign_Ed448(141),
    KDSA_EEdDSA_Sign_Ed25519(142),
    KDSA_EEdDSA_Sign_Ed448(143),
    PCKMO_Enc_DEA_key(144),
    PCKMO_Enc_TDEA_128_key(145),
    PCKMO_Enc_TDEA_192_key(146),
    PCKMO_Enc_AES_128_key(147),
    PCKMO_Enc_AES_192_key(148),
    PCKMO_Enc_AES_256_key(149),
    PCKMO_Enc_ECC_P256_key(150),
    PCKMO_Enc_ECC_P384_key(151),
    PCKMO_Enc_ECC_P521_key(152),
    PCKMO_E_ECC_Ed25519_key(153),
    PCKMO_E_ECC_Ed448_key(154),
    NOT_DEFINED(-1);

    private static Map<Integer, CryptoCounters> valueMap;
    private final transient int cryptoCounter;

    private CryptoCounters(int cryptoCounter) {
        this.cryptoCounter = cryptoCounter;
    }

    public static CryptoCounters from(int value) {
        CryptoCounters result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int cryptoCounter() {
        return this.cryptoCounter;
    }

    static {
        valueMap = new HashMap<Integer, CryptoCounters>();
        for (CryptoCounters x : CryptoCounters.values()) {
            if (x.cryptoCounter < 0) continue;
            valueMap.put(x.cryptoCounter, x);
        }
    }
}

