/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2.section;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.db2.section.QmdaCics;
import com.blackhillsoftware.smf.db2.section.QmdaInfo;
import com.blackhillsoftware.smf.db2.section.QmdaRest;
import com.blackhillsoftware.smf.db2.section.QmdaSqli;
import com.blackhillsoftware.smf.db2.section.Qmdaastr;
import com.blackhillsoftware.smf.db2.section.QmdaastrD;
import com.blackhillsoftware.smf.db2.section.QmdalocnD;
import com.blackhillsoftware.smf.internal.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Qmda
extends SmfData {
    private QmdalocnD m_QmdalocnD = null;
    private QmdaastrD m_QmdaastrD = null;
    public static final int QMDAEND = 260;
    public static final String QMDASDSN = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(12903125).array(), 1, 3);
    public static final String QMDASARI = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(12704201).array(), 1, 3);
    public static final String QMDASSQL = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(14866643).array(), 1, 3);
    public static final String QMDASJCC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(13747139).array(), 1, 3);
    public static final String QMDASQSQ = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(14213848).array(), 1, 3);
    public static final String QMDASDFH = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(12895944).array(), 1, 3);
    public static final String QMDASHTP = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(13165527).array(), 1, 3);
    public static final String QMDASHTS = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(13165538).array(), 1, 3);
    public static final String QMDASLRT = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(13883875).array(), 1, 3);

    private Qmda(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        super(Data2, offset, length);
        boolean utf8 = parent.qwhs().qwhsUnicode();
        if (this.data.length >= Field.qmdalocnOff.offset + Field.qmdalocnOff.length && this.qmdalocnOff() != 0) {
            this.m_QmdalocnD = QmdalocnD.create(Data2, offset + this.qmdalocnOff(), Util.ConvertUnsignedBinary2(Data2, offset + this.qmdalocnOff()) + 2, utf8);
        }
        if (this.data.length >= Field.qmdaastrOff.offset + Field.qmdaastrOff.length && this.qmdaastrOff() != 0) {
            this.m_QmdaastrD = QmdaastrD.create(Data2, offset + this.qmdaastrOff(), Util.ConvertUnsignedBinary2(Data2, offset + this.qmdaastrOff()) + 2);
        }
    }

    public int qmdaasln() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public byte[] qmdaainf() {
        if (this.data.length >= 1 + this.qmdaasln()) {
            byte[] result = new byte[this.qmdaasln()];
            System.arraycopy(this.data, 1, result, 0, this.qmdaasln());
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1) + " Data length: " + Integer.toString(this.qmdaasln()));
    }

    public String qmdaprid() {
        return Util.ConvertEbcdic(this.data, 1, 8);
    }

    public String qmdaptyp() {
        return Util.ConvertEbcdic(this.data, 1, 3);
    }

    public String qmdapver() {
        return Util.ConvertEbcdic(this.data, 4, 2);
    }

    public String qmdaprel() {
        return Util.ConvertEbcdic(this.data, 6, 2);
    }

    public String qmdapmod() {
        return Util.ConvertEbcdic(this.data, 8, 1);
    }

    public Qmdaastr qmdaastr() {
        int length = this.qmdaasln() - Field.qmdaastr.offset + 1;
        if (this.data.length >= 9 + length) {
            if (this.qmdaptyp().equals(QMDASDSN)) {
                return QmdaInfo.create(this.data, 9, length, this.m_QmdaastrD);
            }
            if (this.qmdaptyp().equals(QMDASDFH)) {
                return QmdaCics.create(this.data, 9, length, this.m_QmdaastrD);
            }
            if (this.qmdaptyp().equals(QMDASSQL) || this.qmdaptyp().equals(QMDASJCC)) {
                return QmdaSqli.create(this.data, 9, length, this.m_QmdaastrD);
            }
            if (this.qmdaptyp().equals(QMDASHTP) || this.qmdaptyp().equals(QMDASHTS)) {
                return QmdaRest.create(this.data, 9, length, this.m_QmdaastrD);
            }
            return new Qmdaastr(this.data, 9, length, this.m_QmdaastrD);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(9) + " Data length: " + Integer.toString(length));
    }

    public int qmdalocnOff() {
        return Util.ConvertUnsignedBinary2(this.data, 256);
    }

    public String qmdalocn() {
        if (this.m_QmdalocnD != null) {
            return this.m_QmdalocnD.qmdalocnVar();
        }
        return null;
    }

    public int qmdaastrOff() {
        return Util.ConvertUnsignedBinary2(this.data, 258);
    }

    public static Qmda create(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        return new Qmda(Data2, offset, length, parent);
    }

    static enum Field {
        qmdaasln(0, 1),
        qmdaainf(1, 0),
        qmdaprid(1, 8),
        qmdaptyp(1, 3),
        qmdapver(4, 2),
        qmdaprel(6, 2),
        qmdapmod(8, 1),
        qmdaastr(9, 247),
        qmdalocnOff(256, 2),
        qmdaastrOff(258, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

