/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.monitoring.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CicsDictionaryCollection {
    private static Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
    private static Map<CicsInstanceId, CicsInstanceId> noDictionaryInstances = new HashMap<CicsInstanceId, CicsInstanceId>();
    private static Object lockObject = new Object();
    private static Map<CicsInstanceId, Dictionary> dictionaryByInstance = new HashMap<CicsInstanceId, Dictionary>();
    private static Map<Integer, Dictionary> dictionaryByVersion = new HashMap<Integer, Dictionary>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary getDictionary(CicsInstanceId instance) {
        Object object = lockObject;
        synchronized (object) {
            Dictionary result = dictionaryByInstance.get(instance);
            if (result == null && (result = dictionaryByVersion.get(instance.getRvn())) != null && !result.getCicsInstance().equals(noDictionaryInstances.get(instance))) {
                slf4jLogger.warn("No CICS Dictionary for " + instance + ", using same version dictionary for " + result.getCicsInstance());
                noDictionaryInstances.put(instance, result.getCicsInstance());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putDictionary(CicsInstanceId instance, Dictionary dictionary) {
        Object object = lockObject;
        synchronized (object) {
            dictionaryByInstance.put(instance, dictionary);
            dictionaryByVersion.put(instance.getRvn(), dictionary);
        }
    }
}

